/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.block;

import DE.siemens.ad.logo.model.AnalogWatchdogParameter;
import DE.siemens.ad.logo.model.BinaryInBlockConnector;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.MessageManager;
import DE.siemens.ad.logo.model.MessageParameter;
import DE.siemens.ad.logo.model.ParameterInBlockConnector;
import DE.siemens.ad.logo.model.PseudoParameter;
import DE.siemens.ad.logo.model.SpecialBlock;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import DE.siemens.ad.logo.util.MessageLine;
import java.util.ArrayList;

public class MessageBlock
extends SpecialBlock {
    static final long serialVersionUID = 1L;
    private int serializedDataVersion = 1;

    public MessageBlock() {
    }

    public MessageBlock(WiringDiagram wiringDiagram) {
        super(wiringDiagram);
    }

    public Block deepCopy() {
        Block clonedBlock = super.deepCopy();
        MessageParameter srcParam = (MessageParameter)this.getParameter();
        MessageParameter cloneParam = (MessageParameter)clonedBlock.getParameter();
        if (srcParam.isRTF()) {
            for (int j = 0; j < 2; ++j) {
                MessageParameter.MessageText srcText = srcParam.getMessageRTF(j);
                if (srcText == null) continue;
                cloneParam.getMessageRTFs()[j] = new MessageParameter.MessageText();
                cloneParam.getMessageRTF(j).copyFrom(srcText, cloneParam);
            }
            cloneParam.setMessage(null);
        } else {
            int i;
            MessageLine[] srcLines = srcParam.getMessage();
            MessageLine[] cloneLines = cloneParam.getMessage();
            for (i = 0; i < cloneLines.length; ++i) {
                cloneLines[i].copyFrom(srcLines[i], false);
            }
            for (i = 0; i < cloneParam.getMessageRTFs().length; ++i) {
                cloneParam.getMessageRTFs()[i] = null;
            }
        }
        return clonedBlock;
    }

    protected boolean calculateBinaryValue() {
        return this.getParameter().getValue(((BinaryInBlockConnector)this.fInConnectors[0]).calculateBinaryValue());
    }

    protected int getDefaultOrder() {
        return 2100;
    }

    public int[] getMemoryResources(Hardware hardware) {
        int[] result = super.getMemoryResources(hardware);
        result[12] = 1;
        return result;
    }

    public int getResourceIndex() {
        return 12;
    }

    protected void initInConnectors() {
        this.fInConnectors = new InBlockConnector[3];
        this.fInConnectors[0] = new BinaryInBlockConnector(this, false, "En");
        MessageParameter paraObj = new MessageParameter(this);
        this.fInConnectors[1] = new ParameterInBlockConnector((Block)this, paraObj, "P");
        this.fInConnectors[2] = new ParameterInBlockConnector((Block)this, new PseudoParameter(this), "Par");
    }

    public boolean postDelete(WiringDiagram wd) {
        MessageParameter messageParameter = (MessageParameter)this.getParameter();
        MessageLine[] messageLines = messageParameter.getMessage();
        for (int i = 0; i < messageLines.length; ++i) {
            messageLines[i].removeAsParameterListener();
        }
        return true;
    }

    public void setWiringDiagram(WiringDiagram wd) {
        super.setWiringDiagram(wd);
        MessageParameter msgParam = (MessageParameter)this.getParameter();
        if (wd != null && wd.getMessageManager().isRTFMessage() && !msgParam.isRTF() && !msgParam.enableTextRTF(wd.getMessageGlobalInfo().getCurCharSetID())) {
            System.out.println("error in reset message");
        }
    }

    public String preInsert(WiringDiagram wd) {
        Integer oldPrio;
        super.preInsert(wd);
        MessageParameter msgParam = (MessageParameter)this.getParameter();
        MessageManager msgManager = wd.getMessageManager();
        Integer oldNumber = msgParam.getMsgNumber();
        if (msgManager.isMsgNumberUsed(oldNumber)) {
            msgParam.setMsgNumber(msgManager.getFreeMessageNumber());
        }
        if (msgManager.isPriorityUsed(oldPrio = msgParam.getPriority())) {
            msgParam.setPriority(msgManager.getFreePriority());
            return this.getLocalizedName(true) + ": " + Language.getString("dialog.parameter.message.priority", "Priotity:") + oldPrio + " --> " + msgParam.getPriority() + " | " + Language.getString("msg.textDeleted", "Text deleted");
        }
        MessageLine[] messageLines = msgParam.getMessage();
        boolean empty = true;
        for (int i = 0; i < messageLines.length; ++i) {
            empty &= messageLines[i].isEmpty();
            messageLines[i].addAsParameterListener();
        }
        if (empty) {
            return this.getLocalizedName(true) + ": " + Language.getString("msg.textDeleted", "Text deleted");
        }
        return null;
    }

    public void hardwareChangeFinished(HardwareChangedEvent hardwareChangedEvent) {
        super.hardwareChangeFinished(hardwareChangedEvent);
        ((MessageParameter)this.getParameter()).hardwareChangeFinished(hardwareChangedEvent);
    }

    public boolean isResourceAvailable(WiringDiagram wd) {
        boolean result = super.isResourceAvailable(wd);
        if (wd.getMessageManager().isRTFMessage() && wd.getMessageManager().getFreeMessageTextID() == -1) {
            result = false;
        }
        return result;
    }

    public boolean isResourceAvailable(WiringDiagram wd, ArrayList errorList) {
        boolean result = super.isResourceAvailable(wd, errorList);
        if (wd.getMessageManager().isRTFMessage() && wd.getMessageManager().getFreeMessageTextID() == -1) {
            result = false;
            String s = Language.getString("hardware.MessageText", "Resource");
            s = Language.getString("error.notAvailable", "% not available", s);
            errorList.add(new ErrorInfo(this, s, wd.getHardware()));
        }
        return result;
    }

    public void setHardware(Hardware hardware) {
        MessageParameter param = (MessageParameter)this.getParameter();
        if (hardware != null && this.getHardware() != null && param != null && !param.isRTF()) {
            boolean curSupports = this.getHardware().supports("analogWatchdogWithTwoDelta");
            boolean newSupports = hardware.supports("analogWatchdogWithTwoDelta");
            if (curSupports && !newSupports) {
                MessageLine[] messageLines = param.getMessage();
                for (int i = 0; i < messageLines.length; ++i) {
                    if (!(messageLines[i].getBlockParameter() instanceof AnalogWatchdogParameter) || !messageLines[i].getParameterItemIdentifier().equals("D1") && !messageLines[i].getParameterItemIdentifier().equals("D2")) continue;
                    messageLines[i].setParameterItemIdentifier("D");
                }
            } else if (!curSupports && newSupports) {
                MessageLine[] messageLines = param.getMessage();
                for (int i = 0; i < messageLines.length; ++i) {
                    if (!(messageLines[i].getBlockParameter() instanceof AnalogWatchdogParameter) || !messageLines[i].getParameterItemIdentifier().equals("D")) continue;
                    messageLines[i].setParameterItemIdentifier("D1");
                }
            }
        }
        super.setHardware(hardware);
    }
}

