/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.block;

import DE.siemens.ad.logo.model.AbstractInputSimulationParameter;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.ConstantBlock;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareFactory;
import DE.siemens.ad.logo.model.InputParameter;
import DE.siemens.ad.logo.model.InputSimulationParameter;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.SimulationParameter;
import DE.siemens.ad.logo.model.WiringDiagram;

public class InputBlock
extends ConstantBlock {
    static final long serialVersionUID = -7082639110170811148L;
    private int inputBlockSerializedDataVersion = 1;
    public static final int BINARY_BLOCK = 0;
    public static final int ANALOGOUS_BLOCK = 1;
    protected int fSimulationType = 0;
    InputParameter fInputParameter = new InputParameter(this);
    public static final int FIRST_OPCODE = 192;
    public static final int LAST_OPCODE = 203;

    public InputBlock() {
    }

    public InputBlock(WiringDiagram wiringDiagram) {
        super(wiringDiagram);
    }

    public int getOutConnectorValueType() {
        if (this.getSimulationBlockType() == 0) {
            return 0;
        }
        return 1;
    }

    public double calculateAnalogValue() {
        if (this.fSimulationParameter != null) {
            return ((InputSimulationParameter)this.fSimulationParameter).getInternAnalogValue();
        }
        return 0.0;
    }

    protected boolean calculateBinaryValue() {
        if (this.fSimulationParameter != null) {
            return ((InputSimulationParameter)this.fSimulationParameter).getBinaryValue();
        }
        return false;
    }

    protected int getDefaultOrder() {
        return 10100;
    }

    public int[] getMemoryResources(Hardware hardware) {
        int[] result = new int[HardwareFactory.getInstance().getResourceNames().length];
        result[this.getNumberType()] = 1;
        return result;
    }

    public String getNumberPrefix() {
        return "I";
    }

    public int getNumberType() {
        return 6;
    }

    public BlockParameter getParameter() {
        return this.fInputParameter;
    }

    public int getResourceIndex() {
        return 6;
    }

    public int getSimulationBlockType() {
        AbstractInputSimulationParameter simulationParameter = (AbstractInputSimulationParameter)this.getSimulationParameter();
        if (simulationParameter != null && (simulationParameter.getSwitchMode() == 2 || simulationParameter.getSwitchMode() == 4)) {
            return 1;
        }
        return 0;
    }

    public SimulationParameter getSimulationParameter() {
        if (this.fSimulationParameter == null) {
            this.fSimulationParameter = new InputSimulationParameter(this, 0, 0);
        }
        return this.fSimulationParameter;
    }

    protected void initInConnectors() {
        this.fInConnectors = null;
    }

    public void setSimulationBlockType(int newType) {
        this.fSimulationType = newType;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        if (this.getSimulationParameter() != null) {
            this.getSimulationParameter().init(interpreter, forceReset);
        }
    }
}

