/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.block;

import DE.siemens.ad.logo.model.Analog;
import DE.siemens.ad.logo.model.AnalogBlock;
import DE.siemens.ad.logo.model.AnalogInBlockConnector;
import DE.siemens.ad.logo.model.AnalogWatchdogParameter;
import DE.siemens.ad.logo.model.BinaryInBlockConnector;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.ParameterInBlockConnector;
import DE.siemens.ad.logo.model.ParameterSetListener;
import DE.siemens.ad.logo.model.SpecialBlock;
import DE.siemens.ad.logo.model.WiringDiagram;
import java.util.List;

public class AnalogWatchdogBlock
extends SpecialBlock
implements AnalogBlock {
    static final long serialVersionUID = -846054736915873751L;
    private int blockSerializedDataVersion = 1;

    public AnalogWatchdogBlock() {
    }

    public AnalogWatchdogBlock(WiringDiagram wiringDiagram) {
        super(wiringDiagram);
    }

    protected void initInConnectors() {
        this.fInConnectors = new InBlockConnector[3];
        this.fInConnectors[0] = new BinaryInBlockConnector(this, false, "En");
        this.fInConnectors[1] = new AnalogInBlockConnector(this, 0.0, "Ax");
        String name = "DE.siemens.ad.logo.model.AnalogWatchdogParameter";
        this.fInConnectors[2] = new ParameterInBlockConnector((Block)this, name, "Par");
    }

    public void addMeasurementBoundsChangedListener(ParameterSetListener listener) {
        this.getParameter().addParameterSetListener(listener);
    }

    public void collectSensors(List sensorContainer) {
        Analog analogParameter = (Analog)this.getParameter();
        sensorContainer.add(analogParameter.getMeasurement().getSensor());
    }

    public void removeMeasurementBoundsChangedListener(ParameterSetListener listener) {
        this.getParameter().removeParameterSetListener(listener);
    }

    protected boolean calculateBinaryValue() {
        boolean enable = ((BinaryInBlockConnector)this.fInConnectors[0]).calculateBinaryValue();
        double ax = ((AnalogInBlockConnector)this.fInConnectors[1]).calculateAnalogValue();
        boolean result = ((AnalogWatchdogParameter)this.getParameter()).getValue(enable, ax);
        return result;
    }

    public void hardwareChanged(HardwareChangedEvent hardwareChangedEvent) {
        super.hardwareChanged(hardwareChangedEvent);
        ((AnalogWatchdogParameter)this.getParameter()).updateRemanenceAvailable(this);
    }
}

