/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.block;

import DE.siemens.ad.logo.model.AnalogBlock;
import DE.siemens.ad.logo.model.AnalogInBlockConnector;
import DE.siemens.ad.logo.model.AnalogOutBlockConnector;
import DE.siemens.ad.logo.model.AnalogOutputParameter;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.ParameterSetListener;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.logo.util.BlockEnumeration;
import java.util.List;

public class AnalogOutputBlock
extends OutputBlock
implements AnalogBlock {
    static final long serialVersionUID = -1180667617226972254L;
    private int serializedDataVersion = 1;
    private transient double fProcessImageAnalogValue;
    private transient double fAnalogValue;

    public AnalogOutputBlock() {
    }

    public AnalogOutputBlock(WiringDiagram wiringDiagram) {
        super(wiringDiagram);
    }

    public int getNumberType() {
        return 13;
    }

    public String getNumberPrefix() {
        return "AQ";
    }

    public int getResourceIndex() {
        return 13;
    }

    protected void initInConnectors() {
        this.fInConnectors = new InBlockConnector[1];
        this.fInConnectors[0] = new AnalogInBlockConnector(this, 0.0, "1");
    }

    public void setBinaryValue(boolean binaryValue) {
        throw new IllegalArgumentException("setBinaryValue darf bei Analogausg\u00e4ngen nicht gerufen werden!");
    }

    public void setAnalogValue(double analogValue) {
        this.fAnalogValue = analogValue;
    }

    protected void initOutConnectors() {
        this.fOutConnectors = new OutBlockConnector[1];
        this.fOutConnectors[0] = new AnalogOutBlockConnector(this);
    }

    public double calculateAnalogValue() {
        this.fAnalogValue = ((AnalogInBlockConnector)this.getInConnector(0)).calculateAnalogValue();
        return this.fProcessImageAnalogValue;
    }

    public double getAnalogValue() {
        return this.fAnalogValue;
    }

    public void collectSensors(List sensorContainer) {
        BlockEnumeration nextAnalogBlocks = this.getOutConnector(0).getLinkedBlocks();
        while (nextAnalogBlocks.hasMoreElements()) {
            AnalogBlock analogBlock = (AnalogBlock)((Object)nextAnalogBlocks.nextBlock());
            analogBlock.collectSensors(sensorContainer);
        }
    }

    public void addMeasurementBoundsChangedListener(ParameterSetListener listener) {
        BlockEnumeration analogBlocks = this.getOutConnector(0).getLinkedBlocks();
        while (analogBlocks.hasMoreElements()) {
            AnalogBlock analogBlock = (AnalogBlock)((Object)analogBlocks.nextBlock());
            analogBlock.addMeasurementBoundsChangedListener(listener);
        }
    }

    public void removeMeasurementBoundsChangedListener(ParameterSetListener listener) {
        BlockEnumeration analogBlocks = this.getOutConnector(0).getLinkedBlocks();
        while (analogBlocks.hasMoreElements()) {
            AnalogBlock analogBlock = (AnalogBlock)((Object)analogBlocks.nextBlock());
            analogBlock.removeMeasurementBoundsChangedListener(listener);
        }
    }

    public void endCalculation() {
        this.fProcessImageAnalogValue = this.fAnalogValue = ((AnalogInBlockConnector)this.fInConnectors[0]).calculateAnalogValue();
    }

    public BlockParameter getParameter() {
        if (this.fOutputParameter == null) {
            this.fOutputParameter = new AnalogOutputParameter(this);
        }
        return this.fOutputParameter;
    }
}

