/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.TimeProtectionParameter;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import java.util.List;

public class WipingRelayParameter
extends TimeProtectionParameter {
    static final long serialVersionUID = 0L;
    private int wipingRelayParameterSerializedDataVersion = 1;

    public WipingRelayParameter() {
    }

    public WipingRelayParameter(Block block) {
        super(block);
        this.init(null, true);
        this.fParameter = 1;
        this.fData = 1;
        this.fAllocatedTimer = 1;
        this.fState = 0;
        this.setParameterNameKeys();
    }

    public boolean calculateValue(boolean trigger) {
        boolean result = false;
        if (this.fState == 0) {
            if (!trigger) {
                this.getTimer().reset();
            } else {
                this.getTimer().start();
                this.fState = 2;
            }
        }
        if (this.fState == 2) {
            if (!trigger) {
                this.fState = 0;
                this.getTimer().reset();
            } else if (!this.getTimer().isFinished()) {
                result = true;
            } else {
                this.fState = 1;
            }
        }
        if (this.fState == 1 && !trigger) {
            this.fState = 0;
        }
        return result;
    }

    public boolean getValue(boolean trigger) {
        boolean rw = this.calculateValue(trigger);
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        this.fireParameterUpdateEvent();
        return rw;
    }

    protected void setParameterNameKeys() {
        this.getTimer().setNameKey("dialog.parameter.offTime");
    }

    public boolean isAvailable(Hardware hw, List errorList) {
        boolean result = super.isAvailable(hw, errorList);
        if (this.getParamTime().isReference() && !hw.supports("WipingRelay_ref")) {
            errorList.add(new ErrorInfo(this, Language.getString("error.hardware.referenceNotSupported", "The reference is not supported by the device %.", hw.getLocalizedPath() + hw.getLocalizedName()), hw));
            result &= false;
        }
        return result;
    }
}

