/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.FrequencyParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import java.io.IOException;
import java.util.List;

public class TriggerParameter
extends FrequencyParameter {
    static final long serialVersionUID = 0L;
    private int triggerParameterSerializedDataVersion = 1;
    protected int fCounterValue;
    protected int fCounterValueOld;
    protected boolean fFreOld;
    private boolean f0BA4CalculationMode = false;

    public TriggerParameter() {
    }

    public TriggerParameter(Block block) {
        super(block);
        this.fParameter = 3;
        this.fData = 3;
        this.fAllocatedTimer = 1;
        this.fState = false;
        this.fCounterValueOld = 0;
        this.fCounterValue = 0;
        this.getTimeInterval().setParamTime(1, 0, "dialog.timeParameter.seconds");
    }

    public boolean calculateValue(double fre) {
        if (this.fTimeInterval.isFinished()) {
            this.fCounterValue = this.fCounterValueOld = (int)Math.round((double)((float)this.fTimeInterval.getPassedTime().getMilliseconds() / 1000.0f) * fre);
            this.fTimeInterval.start();
        }
        if (this.f0BA4CalculationMode) {
            this.setState0BA4();
        } else {
            this.setState();
        }
        return this.fState;
    }

    protected boolean calculateValue(boolean fre) {
        if (!this.fFreOld && fre && this.fCounterValue < this.fMax) {
            ++this.fCounterValue;
        }
        this.fFreOld = fre;
        if (this.fTimeInterval.isFinished()) {
            this.fCounterValueOld = this.fCounterValue;
            this.fCounterValue = 0;
            this.fTimeInterval.start();
        }
        if (this.f0BA4CalculationMode) {
            this.setState0BA4();
        } else {
            this.setState();
        }
        return this.fState;
    }

    private void setState() {
        if (this.fCounterValueOld > this.fOnThreshold) {
            this.fState = true;
        }
        if (this.fCounterValueOld <= this.fOffThreshold) {
            this.fState = false;
        }
    }

    private void setState0BA4() {
        if (this.fOnThreshold >= this.fOffThreshold) {
            if (this.fCounterValueOld >= this.fOnThreshold) {
                this.fState = true;
            } else if (this.fCounterValueOld < this.fOffThreshold) {
                this.fState = false;
            }
        } else {
            this.fState = this.fOnThreshold < this.fOffThreshold && this.fCounterValueOld >= this.fOnThreshold && this.fCounterValueOld < this.fOffThreshold;
        }
    }

    public String calculateCurrentParameterText() {
        String value = Integer.toString(this.fCounterValueOld);
        value = "      ".substring(value.length()) + value;
        return value + "\n" + this.fTimeInterval.getPassedTime().getTimeAsString();
    }

    public String getParameterText() {
        return "ON =" + this.getOnThreshold().getCurrentValue() + this.getProtectionSign() + "\n" + "OFF=" + this.getOffThreshold().getCurrentValue() + "\n" + "G_T=" + this.getTimeInterval().getParamTime().getParameterText();
    }

    public Integer getFrequency() {
        return new Integer(this.fCounterValueOld);
    }

    public void setFrequency(Integer newCounterValue) {
        throw new IllegalStateException("The method " + this.getClass().getName() + ".setFrequency(Integer) is not supported");
    }

    public boolean getValue(double fre) {
        boolean result = this.calculateValue(fre);
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        this.fireParameterUpdateEvent();
        return result;
    }

    public boolean getValue(boolean fre) {
        boolean result = this.calculateValue(fre);
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        this.fireParameterUpdateEvent();
        return result;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        this.fTimeInterval.init(interpreter);
        this.fState = false;
        this.fCounterValueOld = 0;
        this.fCounterValue = 0;
        this.fTimeInterval.reset();
        this.fTimeInterval.start();
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fCounterValue = dr.readInt();
        this.fCounterValueOld = dr.readInt();
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fCounterValue);
        dw.writeInt(this.fCounterValueOld);
    }

    public void hardwareChanged(HardwareChangedEvent hardwareChangedEvent) {
        super.hardwareChanged(hardwareChangedEvent);
        Hardware newHardware = (Hardware)hardwareChangedEvent.getNewValue();
        this.f0BA4CalculationMode = newHardware.supports("0BA4Calculation");
    }

    public boolean isAvailable(Hardware hw, List errorList) {
        boolean result = super.isAvailable(hw, errorList);
        if (this.getIntervalTimerParamTime().isReference() && !hw.supports("Trigger_ref")) {
            errorList.add(new ErrorInfo(this, Language.getString("error.hardware.referenceNotSupported", "The reference is not supported by the device %.", hw.getLocalizedPath() + hw.getLocalizedName()), hw));
            result &= false;
        }
        return result;
    }
}

