/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.AbstractTimer;
import DE.siemens.ad.logo.model.TimeUnit;
import java.io.IOException;

public class Timer
extends AbstractTimer {
    static final long serialVersionUID = 0L;
    private int timerSerializedDataVersion = 1;

    public Timer() {
        this.setParamTime(0, 0, "dialog.timeParameter.seconds");
    }

    public Timer(TimeUnit timeUnit) {
        this.setParamTime(timeUnit);
    }

    public Timer(String name) {
        this(name, name);
    }

    public Timer(String name, String defaultName) {
        this();
        this.setNameKey(name);
    }

    public TimeUnit getPassedTime() {
        if (this.isFinished()) {
            this.fState = 2;
        }
        if (this.fState == 0) {
            this.fPassedTime.setMilliseconds(0L);
        }
        if (this.fState == 2) {
            this.fPassedTime.setMilliseconds(this.fParamTime.getMilliseconds());
        }
        if (this.fState == 1) {
            this.fPassedTime.setMilliseconds(this.getCurrentTime() - this.fStartTime);
        }
        return this.fPassedTime;
    }

    public int getPassedTimeUnitValue() {
        if ("dialog.timeParameter.highResolutionSeconds".equals(this.fParamTime.getUnitKey())) {
            return (int)this.getPassedTime().getMilliseconds() / 10;
        }
        if ("dialog.timeParameter.seconds".equals(this.fParamTime.getUnitKey())) {
            return (int)this.getPassedTime().getMilliseconds() / 10;
        }
        if ("dialog.timeParameter.minutes".equals(this.fParamTime.getUnitKey())) {
            return (int)this.getPassedTime().getMilliseconds() / 1000;
        }
        if ("dialog.timeParameter.hours".equals(this.fParamTime.getUnitKey())) {
            return (int)this.getPassedTime().getMilliseconds() / 1000 / 60;
        }
        System.out.println("Can't not find the UNIT_KEY '" + this.fParamTime.getUnitKey() + "'!");
        return 0;
    }

    public TimeUnit getRemainingTime() {
        if (this.isFinished()) {
            this.fState = 2;
        }
        if (this.fState == 0) {
            this.fPassedTime.setMilliseconds(this.fParamTime.getMilliseconds());
        }
        if (this.fState == 2) {
            this.fPassedTime.setMilliseconds(0L);
        }
        if (this.fState == 1) {
            this.fPassedTime.setMilliseconds(this.fParamTime.getMilliseconds() - (this.getCurrentTime() - this.fStartTime));
        }
        return this.fPassedTime;
    }

    public TimeUnit getRemainingTimeForShowing() {
        return TimeUnit.timeUnitSub(this.getParamTime(), this.getPassedTime());
    }

    public boolean isFinished() {
        if (this.fState == 2) {
            return true;
        }
        if (this.fState == 1 && this.getCurrentTime() - this.fStartTime >= this.fParamTime.getMilliseconds()) {
            this.fState = 2;
            return true;
        }
        return false;
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
    }

    public void write(StorableOutput dw) {
        super.write(dw);
    }
}

