/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.BlockPropertyChangeEvent;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.Logo;
import DE.siemens.ad.logo.model.MemoryUsageTable;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.DifferenceTableModel;
import java.util.HashMap;

public class SpecialBlock
extends Block {
    static final long serialVersionUID = 1911195630685775372L;
    private int specialBlockSerializedDataVersion = 1;

    public SpecialBlock() {
    }

    public SpecialBlock(WiringDiagram wiringDiagram) {
        super(wiringDiagram);
    }

    protected int getDefaultOrder() {
        return 300;
    }

    public int[] getMemoryResources(Hardware hardware) {
        int[] result = super.getMemoryResources(hardware);
        result[0] = 1;
        BlockParameter param = this.getParameter();
        if (param != null) {
            MemoryUsageTable blockREMMemoryUsageTable;
            result[1] = param.getAllocatedRAM();
            result[2] = param.getAllocatedREM();
            result[3] = param.getAllocatedParameter();
            result[4] = param.getAllocatedTimer();
            MemoryUsageTable blockMemoryUsageTable = (MemoryUsageTable)hardware.getProperty("blockMemoryTable");
            result[14] = blockMemoryUsageTable != null ? blockMemoryUsageTable.getMemoryUsage(this.getClass()) : 0;
            if (param.getRemanenceAvailable() && param.getRemanenceObject().getRemanence() && (blockREMMemoryUsageTable = (MemoryUsageTable)hardware.getProperty("blockREMMemoryTable")) != null) {
                result[2] = blockREMMemoryUsageTable.getMemoryUsage(this);
            }
        }
        if (this.isUserDefinedNameAvailable()) {
            result[15] = 1;
        }
        return result;
    }

    public int getNumberType() {
        return 0;
    }

    public int getOpcode(Hardware hw, int blockNr) throws IllegalArgumentException {
        return ((Logo)hw).getOpcodeSF(this.getName());
    }

    public String getToolTipText() {
        if (this.fToolTipText == null) {
            this.fToolTipText = super.getToolTipText();
            this.fToolTipText = this.fToolTipText + "(";
            InBlockConnector[] conns = this.getInConnectors();
            if (conns != null) {
                int i = 0;
                while (i < conns.length) {
                    this.fToolTipText = this.fToolTipText + conns[i].getName();
                    i = conns.length;
                }
                for (i = 1; i < conns.length; ++i) {
                    this.fToolTipText = this.fToolTipText + "," + conns[i].getName();
                }
            }
            this.fToolTipText = this.fToolTipText + ")";
        }
        return this.fToolTipText;
    }

    public String getType() {
        return "Special";
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        BlockParameter param = this.getParameter();
        if (param != null) {
            param.init(interpreter, forceReset);
        }
    }

    public boolean isLeftTerminal() {
        return false;
    }

    public boolean compareTo(Block otherBlock, DifferenceTableModel differences) {
        if (!super.compareTo(otherBlock, differences) && this.getClass() != otherBlock.getClass()) {
            return false;
        }
        BlockParameter param = this.getParameter();
        if (param != null) {
            return param.compareTo(otherBlock.getParameter(), differences);
        }
        return true;
    }

    public void hardwareChanged(HardwareChangedEvent hardwareChangedEvent) {
        super.hardwareChanged(hardwareChangedEvent);
        this.getParameter().hardwareChanged(hardwareChangedEvent);
    }

    public void setTimerRemanence(Hardware hardware) {
        boolean newRem;
        BlockParameter param = this.getParameter();
        boolean oldRem = param.getRemanenceAvailable();
        if (oldRem != (newRem = hardware.supports("REMTimer"))) {
            if (newRem) {
                this.getParameter().setRemanenceAvailable(true);
            } else {
                this.getParameter().setRemanenceAvailable(false);
            }
            this.fireBlockPropertyChangeEvent(new BlockPropertyChangeEvent(this, "param;"));
        }
    }

    public void setWiringDiagram(WiringDiagram newWiringDiagram) {
        super.setWiringDiagram(newWiringDiagram);
    }

    public boolean supportsUserDefinedName() {
        try {
            return this.getWiringDiagram().getHardware().supports("userBlockName");
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("block.supportsUserDefinedName(): Noch keine Hardware definiert");
        }
    }

    public void deleteReferences(HashMap dict) {
        BlockParameter param = this.getParameter();
        if (param != null) {
            param.deleteReferencesToParameterItem(dict);
        }
    }
}

