/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.UnlimitedHours;
import DE.siemens.ad.logo.util.IntValueProperties;
import java.io.IOException;

public class Reference
extends TimeUnit {
    static final long serialVersionUID = 3103795312873884716L;
    private int referenceSerializedDataVersion = 1;
    protected TimeUnit fTimeUnit;
    protected ParameterItem fReference;

    public String getDefaultUnitString() {
        return "Reference";
    }

    public IntValueProperties getHigh() {
        TimeUnit timeUnit = this.getTimeUnit();
        timeUnit.setTime(this.getReferenceValue());
        return timeUnit.getHigh();
    }

    public int getHighValue() {
        TimeUnit timeUnit = this.getTimeUnit();
        timeUnit.setTime(this.getReferenceValue());
        return timeUnit.getHighValue();
    }

    public int[] getLogoTime() {
        int[] result = new int[]{this.getTimeUnit() instanceof UnlimitedHours ? 0 : this.getTimeUnit().getLogoTime()[0], this.getReference().getParameter().getBlock().getNumber()};
        return result;
    }

    public IntValueProperties getLow() {
        TimeUnit timeUnit = this.getTimeUnit();
        timeUnit.setTime(this.getReferenceValue());
        return timeUnit.getLow();
    }

    public int getLowValue() {
        TimeUnit timeUnit = this.getTimeUnit();
        timeUnit.setTime(this.getReferenceValue());
        return timeUnit.getLowValue();
    }

    public long getMilliseconds() {
        TimeUnit timeUnit = this.getTimeUnit();
        timeUnit.setTime(this.getReferenceValue());
        return timeUnit.getMilliseconds();
    }

    private int getReferenceValue() {
        int ret = ((IntValueProperties)this.getReference().getValue()).getCurrentValue();
        if (this.getTimeUnit() instanceof UnlimitedHours) {
            ret *= 60;
        }
        return ret;
    }

    public String getUnitAbbreviation() {
        return this.getTimeUnit().getUnitAbbreviation();
    }

    public String getUnitKey() {
        return this.getTimeUnit().getUnitKey();
    }

    public void setTime(int high, int low) {
        this.getTimeUnit().setTime(high, low);
    }

    public TimeUnit setTime(int value) {
        this.getTimeUnit().setTime(value);
        return this;
    }

    public ParameterItem getReference() {
        return this.fReference;
    }

    public TimeUnit getTimeUnit() {
        return this.fTimeUnit;
    }

    public void setReference(ParameterItem reference) {
        this.fReference = reference;
    }

    public void setTimeUnit(TimeUnit value) {
        this.fTimeUnit = value;
    }

    public String getParameterText() {
        BlockParameter param = this.getReference().getParameter();
        StringBuffer result = new StringBuffer();
        try {
            Block block = this.getReference().getParameter().getBlock();
            result.append(block.getNumberPrefix()).append(Integer.toString(block.getNumber()));
            if (this.getTimeUnit() instanceof UnlimitedHours) {
                result.append("h");
            } else {
                result.append(this.getLowValueUnitAbbreviation());
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.getReference() == null) {
            result.append("noReference/");
        } else {
            BlockParameter param = this.getReference().getParameter();
            if (param != null) {
                result.append(param.getBlock().getNumberString());
                result.append("/");
            } else {
                result.append("noParameter/");
            }
            result.append(super.getParameterText());
        }
        return result.toString();
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.fTimeUnit);
        dw.writeStorable(this.fReference);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fTimeUnit = (TimeUnit)dr.readStorable();
        this.fReference = (ParameterItem)dr.readStorable();
    }

    public String getLowValueUnitKey() {
        return this.getTimeUnit().getLowValueUnitKey();
    }

    public String getLowValueUnitAbbreviation() {
        return this.getTimeUnit().getLowValueUnitAbbreviation();
    }
}

