/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.Logo;
import DE.siemens.ad.logo.model.SpecialBlock;
import DE.siemens.ad.logo.model.WiringDiagram;

public class RamRemSpecialBlock
extends SpecialBlock {
    static final long serialVersionUID = 1L;
    private int specialBlockSerializedDataVersion = 1;

    public RamRemSpecialBlock() {
    }

    public RamRemSpecialBlock(WiringDiagram wiringDiagram) {
        super(wiringDiagram);
    }

    public boolean isResourceAvailable(WiringDiagram wd) {
        boolean result = super.isResourceAvailable(wd);
        if (!result) {
            Logo hardware = (Logo)wd.getHardware();
            int[] needResources = hardware.getSubstitutionBlock(this).getMemoryResources(hardware);
            int[] freeResources = wd.getFreeResources();
            int temp = needResources[2];
            needResources[2] = needResources[1];
            needResources[1] = temp;
            result = true;
            for (int i = 0; i < freeResources.length; ++i) {
                if (needResources[i] <= freeResources[i]) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public String preInsert(WiringDiagram wd) {
        super.preInsert(wd);
        int[] freeResources = wd.getFreeResources();
        BlockParameter param = this.getParameter();
        if (param != null) {
            if (freeResources[1] < param.getAllocatedRAM() && this.getParameter().getRemanenceAvailable()) {
                this.getParameter().getRemanenceObject().setRemanence(true);
                return this.getLocalizedName(true) + ": RAM --> REM";
            }
            if (freeResources[2] < param.getAllocatedREM()) {
                this.getParameter().getRemanenceObject().setRemanence(false);
                return this.getLocalizedName(true) + ": REM --> RAM";
            }
        }
        return null;
    }
}

