/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.Interpreter;
import java.io.IOException;
import java.io.ObjectInputStream;

public class PulseRelayParameter
extends BlockParameter {
    public static final String SET_PREFERRED = "SR";
    public static final String RESET_PREFERRED = "RS";
    public static final String PREFERENCE_UNSUPPORTED = "preferenceUnsupported";
    static final long serialVersionUID = 0L;
    private int pulseRelayParameterSerializedDataVersion = 2;
    private String fPreference = "preferenceUnsupported";
    protected boolean fTriggerOld;
    protected boolean fState;

    public PulseRelayParameter() {
    }

    public PulseRelayParameter(Block block) {
        super(block);
        this.fPreference = PREFERENCE_UNSUPPORTED;
        this.fParameter = 0;
        this.fData = 1;
        this.fAllocatedTimer = 0;
        this.fState = false;
        this.fTriggerOld = false;
    }

    public boolean getValue(boolean trigger, boolean set, boolean reset) {
        if (set != reset) {
            this.fState = set;
        } else if (set) {
            this.fState = this.isSetPreferred();
        } else if (trigger && !this.fTriggerOld) {
            this.fState = !this.fState;
        }
        this.fTriggerOld = trigger;
        return this.fState;
    }

    public boolean getValueOld(boolean trigger, boolean reset) {
        if (!this.fTriggerOld && trigger) {
            this.fTriggerOld = true;
            boolean bl = this.fState = !this.fState;
        }
        if (this.fTriggerOld && !trigger) {
            this.fTriggerOld = false;
        }
        if (reset) {
            this.fTriggerOld = trigger;
            this.fState = false;
        }
        return this.fState;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        if (!this.getRemanenceAvailable() || !this.getRemanenceObject().getRemanence() || forceReset) {
            this.fState = false;
            this.fTriggerOld = false;
        }
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fTriggerOld = dr.readBoolean();
        this.fState = dr.readBoolean();
        this.fPreference = dr.readString();
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeBoolean(this.fTriggerOld);
        dw.writeBoolean(this.fState);
        dw.writeString(this.fPreference);
    }

    public boolean isSetPreferred() {
        return this.fPreference.equals(SET_PREFERRED);
    }

    public void setSetPreferred(boolean setPreferred) {
        this.fPreference = setPreferred ? SET_PREFERRED : RESET_PREFERRED;
    }

    public String getPreference() {
        return this.fPreference;
    }

    public void setPreference(String preference) {
        this.fPreference = preference;
    }

    public String getParameterText() {
        String parameterText = null;
        parameterText = !this.fPreference.equals(PREFERENCE_UNSUPPORTED) ? this.fPreference + "\n" + super.getParameterText() : super.getParameterText();
        return parameterText;
    }

    public void hardwareChanged(HardwareChangedEvent hardwareChangedEvent) {
        super.hardwareChanged(hardwareChangedEvent);
        Hardware oldHardware = (Hardware)hardwareChangedEvent.getOldValue();
        Hardware newHardware = (Hardware)hardwareChangedEvent.getNewValue();
        if (newHardware != null && newHardware.supports("pulseRelayWithSetInput") && this.fPreference.equals(PREFERENCE_UNSUPPORTED)) {
            this.fPreference = RESET_PREFERRED;
            this.fireParameterSetEvent();
        }
        if (newHardware != null && !newHardware.supports("pulseRelayWithSetInput")) {
            this.fPreference = PREFERENCE_UNSUPPORTED;
            this.fireParameterSetEvent();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.pulseRelayParameterSerializedDataVersion < 2) {
            this.pulseRelayParameterSerializedDataVersion = 2;
            if (this.fPreference == null) {
                this.fPreference = PREFERENCE_UNSUPPORTED;
            }
        }
    }
}

