/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.model.AnalogOrBlockReference;
import DE.siemens.ad.logo.model.ClockHours;
import DE.siemens.ad.logo.model.IntegerOrBlockReference;
import DE.siemens.ad.logo.model.Mode;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.Remanence;
import DE.siemens.ad.logo.model.SoftkeyParameter;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.util.AnalogValueProperties;
import DE.siemens.ad.logo.util.DoubleValueProperties;
import DE.siemens.ad.logo.util.IntValueProperties;
import DE.siemens.ad.logo.util.MessageLine;
import DE.siemens.ad.logo.util.TimeValueProperties;
import DE.siemens.ad.logo.util.Util;
import java.lang.reflect.Array;
import java.sql.Time;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class ParameterItemValueFormatter {
    private static ParameterItemValueFormatter fSingletonInstance;
    public static final String[] DAYS;

    public String formatLogo(ParameterItem parameterItem, Object parameterValue) {
        String formattedString = null;
        if (parameterValue.getClass().isArray()) {
            int length = Array.getLength(parameterValue);
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < length; ++i) {
                Object arrayElement = Array.get(parameterValue, i);
                buffer.append(this.formatLogo(parameterItem, arrayElement)).append('\n');
            }
            formattedString = buffer.toString();
        } else if (parameterValue instanceof TimeUnit) {
            formattedString = ((TimeUnit)parameterValue).getTimeAsString();
        } else if (parameterValue.getClass() == IntValueProperties.class) {
            formattedString = this.getIntValueString(parameterItem, (IntValueProperties)parameterValue);
        } else if (parameterValue instanceof TimeValueProperties) {
            formattedString = ((TimeValueProperties)parameterValue).getCurrentValue().getParameterText();
        } else if (parameterValue.getClass() == Time.class) {
            formattedString = this.getTimeString(parameterItem, (Time)parameterValue);
        } else if (parameterValue.getClass() == Date.class) {
            formattedString = this.getDateString(parameterItem, (Date)parameterValue);
        } else if (parameterValue instanceof ClockHours) {
            formattedString = this.getClockHoursString(parameterItem, (ClockHours)parameterValue);
        } else if (parameterValue instanceof Mode) {
            formattedString = this.getModeString(parameterItem, (Mode)parameterValue);
        } else if (parameterValue instanceof Remanence) {
            formattedString = this.getRemanenceString(parameterItem, (Remanence)parameterValue);
        } else if (parameterValue instanceof SoftkeyParameter.SwitchState) {
            formattedString = ((SoftkeyParameter.SwitchState)parameterValue).toString();
        } else if (parameterValue.getClass() == AnalogValueProperties.class) {
            formattedString = this.getAnalogValueString(parameterItem, (AnalogValueProperties)parameterValue);
        } else if (parameterValue instanceof IntegerOrBlockReference) {
            formattedString = parameterValue instanceof AnalogOrBlockReference ? (((AnalogOrBlockReference)parameterValue).isReference() ? this.getAnalogOrReferenceString(parameterItem, (AnalogOrBlockReference)parameterValue) : this.getAnalogValueString(parameterItem, ((AnalogOrBlockReference)parameterValue).getAnalogValueProperties())) : this.getIntegerOrReferenceString(parameterItem, (IntegerOrBlockReference)parameterValue);
        } else if (parameterValue instanceof MessageLine) {
            formattedString = "'" + ((MessageLine)parameterValue).getParameterText() + "'/";
        } else if (parameterValue instanceof Integer) {
            formattedString = Util.addLeadingSpaces(((Integer)parameterValue).toString(), parameterItem.getMinWidth());
        } else if (parameterValue instanceof DoubleValueProperties && (formattedString = this.getDoubleValueString(parameterItem, (DoubleValueProperties)parameterValue)).length() < parameterItem.getWidth()) {
            formattedString = Util.addLeadingSpaces(formattedString, parameterItem.getWidth());
        }
        if (formattedString == null) {
            formattedString = parameterValue.toString();
        }
        if (formattedString.length() < parameterItem.getWidth()) {
            formattedString = Util.addTrailingSpaces(formattedString, parameterItem.getWidth());
        }
        if (formattedString == null) {
            throw new IllegalArgumentException("ParameterItemValueFormatter.formatLogo(): No formatter found for type " + parameterValue.getClass());
        }
        return formattedString;
    }

    private String getDoubleValueString(ParameterItem parameterItem, DoubleValueProperties properties) {
        return properties.toString();
    }

    private String getAnalogOrReferenceString(ParameterItem parameterItem, AnalogOrBlockReference analogOrBlockReference) {
        return Util.addLeadingSpaces(analogOrBlockReference.getParameterText(), parameterItem.getMinWidth());
    }

    public Number asNumber(ParameterItem item) {
        Object parameterValue = item.getValue();
        Number result = null;
        if (parameterValue instanceof TimeUnit) {
            result = new Long(((TimeUnit)parameterValue).getMilliseconds());
        } else if (parameterValue.getClass() == IntValueProperties.class) {
            result = new Integer(this.getIntValueString(item, (IntValueProperties)parameterValue));
        } else if (parameterValue instanceof TimeValueProperties) {
            result = new Long(((TimeValueProperties)parameterValue).getCurrentValue().getMilliseconds());
        } else if (parameterValue.getClass() == Time.class) {
            result = new Long(((Time)parameterValue).getTime());
        } else if (parameterValue.getClass() == Date.class) {
            result = new Long(((Date)parameterValue).getTime());
        } else if (parameterValue instanceof ClockHours) {
            result = new Long(((ClockHours)parameterValue).getMilliseconds());
        } else if (parameterValue instanceof SoftkeyParameter.SwitchState) {
            result = new Integer(((SoftkeyParameter.SwitchState)parameterValue).getState() ? 1 : 0);
        } else if (parameterValue.getClass() == AnalogValueProperties.class) {
            result = new Integer(((AnalogValueProperties)parameterValue).getCurrentValue());
        } else if (parameterValue instanceof IntegerOrBlockReference) {
            result = new Integer(((IntegerOrBlockReference)parameterValue).getValue());
        } else if (parameterValue instanceof Integer) {
            result = (Integer)parameterValue;
        }
        if (result == null) {
            throw new IllegalArgumentException("ParameterItemValueFormatter.asNumber(): No formatter found for type " + parameterValue.getClass());
        }
        return result;
    }

    private String getAnalogValueString(ParameterItem parameterItem, AnalogValueProperties properties) {
        boolean suppressLeadingZeroes;
        int value = properties.getCurrentValue();
        char sign = value < 0 ? (char)'-' : '+';
        value = Math.abs(value);
        int width = parameterItem.getMinWidth();
        int nachkommastellen = properties.getDecimalPlace();
        String valueString = Integer.toString(value);
        StringBuffer sb = new StringBuffer(valueString);
        boolean bl = suppressLeadingZeroes = !parameterItem.isLeadingZeros();
        if (suppressLeadingZeroes) {
            while (sb.length() <= nachkommastellen) {
                sb.insert(0, '0');
            }
            if (properties.getMin() < 0 && sign == '-') {
                sb.insert(0, sign);
            }
            if (nachkommastellen > 0) {
                sb.insert(sb.length() - nachkommastellen, '.');
            } else {
                sb.append(" ");
            }
            while (sb.length() < width) {
                sb.insert(0, " ");
            }
        } else {
            --width;
            while (sb.length() < width) {
                sb.insert(0, '0');
            }
            if (nachkommastellen > 0) {
                sb.insert(sb.length() - nachkommastellen, '.');
            }
            if (properties.getMin() < 0) {
                sb.insert(0, sign);
            } else {
                sb.insert(0, '0');
            }
        }
        return sb.toString();
    }

    private String getRemanenceString(ParameterItem parameterItem, Remanence remanence) {
        String remString = null;
        remString = remanence.getRemanence() ? "on" : "off";
        return remString;
    }

    private String getIntegerOrReferenceString(ParameterItem parameterItem, IntegerOrBlockReference integerOrBlockReference) {
        return Util.addLeadingSpaces(integerOrBlockReference.getParameterText(), parameterItem.getMinWidth());
    }

    protected String getClockHoursString(ParameterItem parameterItem, ClockHours clockHours) {
        if (clockHours.isInactive()) {
            return "--:--";
        }
        return clockHours.getTimeAsString();
    }

    protected String getDateString(ParameterItem parameterItem, Date date) {
        Calendar calendar = DateFormat.getDateInstance(3, Locale.US).getCalendar();
        calendar.setTime(date);
        StringBuffer dateString = new StringBuffer();
        dateString.append(Util.addLeadingZeros(Integer.toString(calendar.get(1)), 4));
        dateString.append('-');
        dateString.append(Util.addLeadingZeros(Integer.toString(calendar.get(2) + 1), 2));
        dateString.append('-');
        dateString.append(Util.addLeadingZeros(Integer.toString(calendar.get(5)), 2));
        return dateString.toString();
    }

    protected String getIntValueString(ParameterItem parameterItem, IntValueProperties intValueProperties) {
        int value = intValueProperties.getCurrentValue();
        char sign = value < 0 ? (char)'-' : '+';
        value = Math.abs(value);
        String text = Integer.toString(value);
        int length = parameterItem.getMinWidth();
        text = sign == '-' ? (parameterItem.isLeadingZeros() ? sign + Util.addLeadingZeros(text, length - 1) : Util.addLeadingSpaces(sign + text, length)) : (parameterItem.isLeadingZeros() ? Util.addLeadingZeros(text, length) : Util.addLeadingSpaces(text, length));
        return text;
    }

    private String getModeString(ParameterItem parameterItem, Mode mode) {
        return mode.getAbbreviation();
    }

    protected String getTimeString(ParameterItem parameterItem, Time time) {
        DateFormat dateFormat = DateFormat.getTimeInstance(3, Locale.US);
        Calendar calendar = DateFormat.getDateInstance(3, Locale.US).getCalendar();
        calendar.setTime(time);
        StringBuffer timeString = new StringBuffer();
        timeString.append(DAYS[calendar.get(7) - 1]);
        timeString.append(' ');
        timeString.append(Util.addLeadingZeros(Integer.toString(calendar.get(11)), 2));
        timeString.append(':');
        timeString.append(Util.addLeadingZeros(Integer.toString(calendar.get(12)), 2));
        return timeString.toString();
    }

    public static ParameterItemValueFormatter getInstance() {
        if (fSingletonInstance == null) {
            fSingletonInstance = new ParameterItemValueFormatter();
        }
        return fSingletonInstance;
    }

    static {
        DAYS = new String[]{"Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"};
    }
}

