/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.model.ClockHours;
import DE.siemens.ad.logo.model.IntegerOrBlockReference;
import DE.siemens.ad.logo.model.Mode;
import DE.siemens.ad.logo.model.Months;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ParameterItemValueFormatter;
import DE.siemens.ad.logo.model.Reference;
import DE.siemens.ad.logo.model.Remanence;
import DE.siemens.ad.logo.model.SoftkeyParameter;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.util.AnalogValueProperties;
import DE.siemens.ad.logo.util.DoubleValueProperties;
import DE.siemens.ad.logo.util.IntValueProperties;
import DE.siemens.ad.logo.util.MessageLine;
import DE.siemens.ad.logo.util.TimeValueProperties;
import DE.siemens.ad.logo.util.Util;
import java.lang.reflect.Array;
import java.sql.Time;
import java.util.Date;

public class ParameterItemValueComparator {
    private static ParameterItemValueComparator fSingletonInstance;

    public boolean compare(ParameterItem parameterItem1, ParameterItem parameterItem2) {
        if (parameterItem1 == null && parameterItem2 == null) {
            return true;
        }
        if (parameterItem1 == null || parameterItem2 == null) {
            return false;
        }
        Object value1 = parameterItem1.getValue();
        Object value2 = parameterItem2.getValue();
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        if (value1.getClass().isArray()) {
            int length = Array.getLength(value1);
            if (length != Array.getLength(value2)) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                if (this.compareValues(parameterItem1, Array.get(value1, i), parameterItem2, Array.get(value2, i))) continue;
                return false;
            }
            return true;
        }
        return this.compareValues(parameterItem1, value1, parameterItem2, value2);
    }

    private boolean compareValues(ParameterItem item1, Object value1, ParameterItem item2, Object value2) {
        try {
            return this.compareValues_old(value1, value2);
        }
        catch (ClassCastException e1) {
            try {
                return this.compareValues_old(value2, value1);
            }
            catch (ClassCastException e2) {
                ParameterItemValueFormatter formatter = ParameterItemValueFormatter.getInstance();
                String thisString = formatter.formatLogo(item1, value1);
                String otherString = formatter.formatLogo(item1, value2);
                return thisString.equals(otherString);
            }
        }
    }

    private boolean compareValues_old(Object value1, Object value2) {
        if (value1 instanceof Integer) {
            return ((Integer)value1).equals((Integer)value2);
        }
        if (value1.getClass() == Reference.class) {
            Reference ref1 = (Reference)value1;
            Reference ref2 = (Reference)value2;
            return this.compareParameterItem(ref1.getReference(), ref2.getReference()) && ref1.getTimeUnit().getUnitKey().equals(ref2.getTimeUnit().getUnitKey());
        }
        if (value1.getClass() == Months.class) {
            return this.compareMonths((Months)value1, (Months)value2);
        }
        if (value1 instanceof TimeUnit) {
            return this.compareTimeUnit((TimeUnit)value1, (TimeUnit)value2);
        }
        if (value1.getClass() == IntValueProperties.class) {
            return this.compareIntValueProperties((IntValueProperties)value1, (IntValueProperties)value2);
        }
        if (value1 instanceof TimeValueProperties) {
            return this.compareTimeValueProperties((TimeValueProperties)value1, (TimeValueProperties)value2);
        }
        if (value1.getClass() == Time.class) {
            return value1.equals(value2);
        }
        if (value1.getClass() == Date.class) {
            return value1.equals(value2);
        }
        if (value1 instanceof ClockHours) {
            return this.compareTimeUnit((TimeUnit)value1, (TimeUnit)value2);
        }
        if (value1 instanceof Mode) {
            return ((Mode)value1).getLogoMode() == ((Mode)value2).getLogoMode();
        }
        if (value1 instanceof Remanence) {
            return ((Remanence)value1).getRemanence() == ((Remanence)value2).getRemanence();
        }
        if (value1 instanceof SoftkeyParameter.SwitchState) {
            return ((SoftkeyParameter.SwitchState)value1).getState() == ((SoftkeyParameter.SwitchState)value2).getState();
        }
        if (value1.getClass() == AnalogValueProperties.class) {
            return ((AnalogValueProperties)value1).getCurrentValue() == ((AnalogValueProperties)value2).getCurrentValue();
        }
        if (value1 instanceof IntegerOrBlockReference) {
            IntegerOrBlockReference iobr1 = (IntegerOrBlockReference)value1;
            IntegerOrBlockReference iobr2 = (IntegerOrBlockReference)value2;
            if (iobr1.isReference() != iobr2.isReference()) {
                return false;
            }
            if (iobr1.isReference()) {
                return this.compareParameterItem(iobr1.getReference(), iobr2.getReference());
            }
            return this.compareIntValueProperties(iobr1.getIntValueProperties(), iobr2.getIntValueProperties());
        }
        if (value1 instanceof MessageLine) {
            return this.compareMessageLine((MessageLine)value1, (MessageLine)value2);
        }
        if (value1 instanceof Boolean) {
            return value1.equals(value2);
        }
        if (value1 instanceof Character) {
            return value1.equals(value2);
        }
        if (value1 instanceof DoubleValueProperties) {
            return this.compareDoubleValueProperties((DoubleValueProperties)value1, (DoubleValueProperties)value2);
        }
        if (value1 instanceof String) {
            return value1.equals(value2);
        }
        throw new IllegalArgumentException("No comparator for argument class " + value1.getClass());
    }

    private boolean compareDoubleValueProperties(DoubleValueProperties value1, DoubleValueProperties value2) {
        return value1.getCurrentValue() == value2.getCurrentValue();
    }

    private boolean compareMonths(Months months1, Months months2) {
        if (months1.getLowValue() != months2.getLowValue()) {
            return false;
        }
        if (months1.isEveryMonth()) {
            return months2.isEveryMonth();
        }
        return months1.getHighValue() == months2.getHighValue();
    }

    private boolean compareMessageLine(MessageLine line1, MessageLine line2) {
        return Util.trimRight(line1.getText()).equals(Util.trimRight(line2.getText())) && line1.getParameterPosition() == line2.getParameterPosition() && this.compareParameterItem(line1.getParameterItem(), line2.getParameterItem());
    }

    private boolean compareTimeValueProperties(TimeValueProperties properties1, TimeValueProperties properties2) {
        return this.compareTimeUnit(properties1.getCurrentValue(), properties2.getCurrentValue());
    }

    private boolean compareParameterItem(ParameterItem item1, ParameterItem item2) {
        if (item1 == null && item2 == null) {
            return true;
        }
        if (item1 == null || item2 == null) {
            return false;
        }
        return item1.getParameterClass() == item2.getParameterClass() && item1.getParameter().getBlock().getNumberString().equals(item2.getParameter().getBlock().getNumberString()) && item1.getIdentifier().equals(item2.getIdentifier());
    }

    private boolean compareIntValueProperties(IntValueProperties properties1, IntValueProperties properties2) {
        return properties1.getCurrentValue() == properties2.getCurrentValue();
    }

    public boolean compareTimeUnit(TimeUnit timeUnit1, TimeUnit timeUnit2) {
        if (timeUnit1 instanceof Reference && !(timeUnit2 instanceof Reference) || !(timeUnit1 instanceof Reference) && timeUnit2 instanceof Reference) {
            return false;
        }
        if (timeUnit1 instanceof Reference && timeUnit2 instanceof Reference) {
            Reference ref1 = (Reference)timeUnit1;
            Reference ref2 = (Reference)timeUnit2;
            return this.compareParameterItem(ref1.getReference(), ref2.getReference()) && ref1.getTimeUnit().getUnitKey().equals(ref2.getTimeUnit().getUnitKey());
        }
        return timeUnit1.getUnitAbbreviation().equals(timeUnit2.getUnitAbbreviation()) && timeUnit1.getLowValue() == timeUnit2.getLowValue() && timeUnit1.getHighValue() == timeUnit2.getHighValue();
    }

    public static ParameterItemValueComparator getInstance() {
        if (fSingletonInstance == null) {
            fSingletonInstance = new ParameterItemValueComparator();
        }
        return fSingletonInstance;
    }
}

