/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.util.ValueOrItemReference;
import java.util.ArrayList;
import java.util.Iterator;

public class ParameterItemList
extends ArrayList {
    protected Class fParameterClass;

    public ParameterItemList(Class parameterClass, int elementCount) {
        super(elementCount);
        this.fParameterClass = parameterClass;
    }

    public ParameterItem getParameterItem(String parameterItemIdentifier) {
        for (ParameterItem parameterItem : this) {
            if (!parameterItem.getIdentifier().equals(parameterItemIdentifier)) continue;
            return parameterItem;
        }
        return null;
    }

    public ParameterItem getParameterItem(int parameterNumber) {
        for (ParameterItem parameterItem : this) {
            if (parameterItem.getParameterNumber() != parameterNumber) continue;
            return parameterItem;
        }
        return null;
    }

    public Class getParameterClass() {
        return this.fParameterClass;
    }

    public ParameterItemList getPublicParameterItemList() {
        ParameterItemList publicItemList = new ParameterItemList(this.getParameterClass(), this.size());
        for (ParameterItem item : this) {
            if (!item.isPublicAccessible()) continue;
            publicItemList.add(item);
        }
        return publicItemList;
    }

    public ParameterItemList getParameterItemListOfType(int type) {
        ParameterItemList subList = new ParameterItemList(this.getParameterClass(), this.size());
        for (ParameterItem parameterItem : this) {
            if (parameterItem.getParameterValueType() != type) continue;
            subList.add(parameterItem);
        }
        return subList;
    }

    public ParameterItemList getPrivateParameterItemList() {
        ParameterItemList privateItemList = new ParameterItemList(this.getParameterClass(), this.size());
        for (ParameterItem item : this) {
            if (item.isPublicAccessible()) continue;
            privateItemList.add(item);
        }
        return privateItemList;
    }

    public ParameterItemList getParameterSourceItems() {
        ParameterItemList newItemList = new ParameterItemList(this.getParameterClass(), this.size() / 2);
        for (ParameterItem item : this) {
            if (!item.isParameterSourceUsable()) continue;
            newItemList.add(item);
        }
        return newItemList;
    }

    public ParameterItemList instance(BlockParameter parameter) {
        ParameterItemList newItemList = new ParameterItemList(this.getParameterClass(), this.size());
        for (ParameterItem item : this) {
            newItemList.add(item.getInstanceForParameter(parameter));
        }
        return newItemList;
    }

    public ParameterItemList getValueOrReferenceItems() {
        ParameterItemList newItemList = new ParameterItemList(this.getParameterClass(), this.size() / 2);
        for (ParameterItem item : this) {
            if (item.getValueOrReferenceID() == 0) continue;
            newItemList.add(item);
        }
        return newItemList;
    }

    public ParameterItemList getItemsWithReference(BlockParameter param) {
        ParameterItemList newItemList = new ParameterItemList(this.getParameterClass(), this.size() / 2);
        Iterator sourceList = this.getValueOrReferenceItems().iterator();
        while (sourceList.hasNext()) {
            ParameterItem item = ((ParameterItem)sourceList.next()).getInstanceForParameter(param);
            ValueOrItemReference value = (ValueOrItemReference)item.getValue();
            if (!value.isReference()) continue;
            newItemList.add(item);
        }
        return newItemList;
    }
}

