/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Analog;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.TimeParameterInterface;
import DE.siemens.ad.logo.model.TimeProtectionParameter;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.Timer;
import DE.siemens.ad.logo.util.AnalogValueProperties;
import DE.siemens.ad.logo.util.IntValueProperties;
import DE.siemens.ad.logo.util.TimeValueProperties;
import java.io.IOException;

public class PWMParameter
extends Analog
implements TimeParameterInterface {
    private static final long serialVersionUID = 5624616447304866494L;
    private int blockSerializedDataVersion = 1;
    TimeParameter fPeriodTimeParameter = new TimeParameter();
    private int fRangeMin = 0;
    private transient AnalogValueProperties fRangeMinProperties;
    private int fRangeMax = 1000;
    private transient AnalogValueProperties fRangeMaxProperties;
    private transient AnalogValueProperties fAx_TProperties;
    transient long fPeriodTimeLength;
    transient String fStrPeriodTime;
    transient long fPeriodStartTime;
    transient int fAmplifiedX_T;
    transient int fRangeMax_T;
    transient int fRangeMin_T;
    private transient boolean fParamUpdated = false;
    private static final int WAIT_EN = 0;
    private static final int RUN_CYCLE = 1;

    public PWMParameter() {
    }

    public PWMParameter(Block block) {
        super(block);
    }

    public boolean getValue(boolean enable, double ax) {
        boolean result = this.calculateValue(enable, ax);
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        this.fireParameterUpdateEvent();
        return result;
    }

    private boolean calculateValue(boolean enable, double ax) {
        this.fXInput = ax;
        boolean result = false;
        this.fAmplifiedX = this.getMeasurement().getAmplifiedValue((int)ax);
        switch (this.fState) {
            case 0: {
                this.updatePeriodParameters(this.fInterpreter.getCurrentSimulationClockTime(), this.isAmplifiedXInRange());
                if (enable && this.isAmplifiedXInRange()) {
                    this.fState = 1;
                }
                this.fParamUpdated = false;
                break;
            }
            case 1: {
                if (enable) {
                    boolean negative;
                    long elapseTime = this.fInterpreter.getCurrentSimulationClockTime() - this.fPeriodStartTime;
                    boolean bl = negative = this.fRangeMin_T > this.fRangeMax_T;
                    if (this.fRangeMax_T == this.fRangeMin_T || this.fPeriodTimeLength == 0L) {
                        result = false;
                    } else {
                        int max = Math.max(this.fRangeMax_T, this.fRangeMin_T);
                        int min = Math.min(this.fRangeMax_T, this.fRangeMin_T);
                        double onLen = (double)Math.abs(this.fAmplifiedX_T - min) * (double)this.fPeriodTimeLength / (double)(max - min);
                        long onLenNew = Math.round(onLen / (double)this.getFWResolution()) * this.getFWResolution();
                        if (this.fAmplifiedX_T >= max) {
                            result = true;
                        } else if (this.fAmplifiedX_T <= min) {
                            result = false;
                        } else {
                            boolean bl2 = result = elapseTime % this.fPeriodTimeLength < onLenNew;
                        }
                        boolean bl3 = negative ? !result : (result = result);
                    }
                    if (elapseTime <= this.fPeriodTimeLength && !this.fParamUpdated) break;
                    this.fParamUpdated = false;
                    if (this.isAmplifiedXInRange()) {
                        this.updatePeriodParameters(this.fPeriodStartTime + elapseTime, true);
                        break;
                    }
                    this.fState = 0;
                    break;
                }
                this.fState = 0;
            }
        }
        return result;
    }

    public void notifyParamUpdated() {
        this.fParamUpdated = true;
        System.out.println("Next cycle");
    }

    private long getFWResolution() {
        return 10L;
    }

    private boolean isAmplifiedXInRange() {
        int max = Math.max(this.fRangeMax, this.fRangeMin);
        int min = Math.min(this.fRangeMax, this.fRangeMin);
        return this.fAmplifiedX >= min && this.fAmplifiedX <= max;
    }

    private long getPeriodTimeLength() {
        return this.getTimer().getParamTime().getMilliseconds();
    }

    private void updatePeriodParameters(long currentTime, boolean isAxInRange) {
        this.fAmplifiedX_T = this.fAmplifiedX;
        this.fRangeMax_T = this.fRangeMax;
        this.fRangeMin_T = this.fRangeMin;
        if (isAxInRange) {
            long s = this.getFWResolution();
            this.fPeriodTimeLength = this.getPeriodTimeLength() / s * s;
            this.fStrPeriodTime = this.getTimer().getParamTime().getTimeAsString();
        } else {
            this.fPeriodTimeLength = 0L;
            TimeUnit tu = TimeUnit.getNewTimeObject(this.getTimer().getParamTime().getUnitKey());
            tu.setMilliseconds(0L);
            this.fStrPeriodTime = tu.getTimeAsString();
        }
        this.fPeriodStartTime = currentTime;
    }

    public TimeValueProperties getParamTime() {
        return this.fPeriodTimeParameter.getParamTime();
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fPeriodTimeParameter.setTimer((Timer)dr.readStorable());
        this.fRangeMin = dr.readInt();
        this.fRangeMax = dr.readInt();
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.getTimer());
        dw.writeInt(this.fRangeMin);
        dw.writeInt(this.fRangeMax);
    }

    protected String calculateCurrentParameterText() {
        String rMin;
        String rMax;
        String bars = "      ";
        String period = this.fStrPeriodTime.length() < bars.length() ? bars.substring(this.fStrPeriodTime.length()) + this.fStrPeriodTime : this.fStrPeriodTime;
        bars = "    ";
        String Ax = String.valueOf(this.fAmplifiedX_T);
        if (Ax.length() < bars.length()) {
            Ax = bars.substring(Ax.length()) + Ax;
        }
        if ((rMax = String.valueOf(this.fRangeMax_T)).length() < bars.length()) {
            rMax = bars.substring(rMax.length()) + rMax;
        }
        if ((rMin = String.valueOf(this.fRangeMin_T)).length() < bars.length()) {
            rMin = bars.substring(rMin.length()) + rMin;
        }
        return "Period_T=" + period + "\nAX_T=      " + Ax + "\nRangeMin_T=" + rMin + "\nRangeMax_T=" + rMax;
    }

    public String getParameterText() {
        StringBuffer buffer = new StringBuffer(50);
        buffer.append("RangeMax=").append(this.fRangeMax).append("\n");
        buffer.append("RangeMin=").append(this.fRangeMin).append("\n");
        buffer.append(this.getTimer().getParamTime().getParameterText());
        buffer.append(this.getProtectionSign());
        return buffer.toString();
    }

    public int getRangeMin() {
        return this.fRangeMin;
    }

    public void setRangeMin(int rangeMin) {
        this.fRangeMin = rangeMin;
    }

    public int getRangeMax() {
        return this.fRangeMax;
    }

    public void setRangeMax(int rangeMin) {
        this.fRangeMax = rangeMin;
    }

    public int getTimebase() {
        return 0;
    }

    public void setTimebase(int timebase) {
    }

    public void setParamTime(TimeValueProperties newTime) {
        this.fPeriodTimeParameter.setParamTime(newTime);
    }

    public int getSensorType() {
        return this.fMeasurement.getSensor().getSensorTypeID();
    }

    public void setSensorType(int sensorTypeID) {
        this.fMeasurement.setSensor(sensorTypeID, this.getBlock().getWiringDiagram().getHardware());
    }

    public Timer getTimer() {
        Timer timer = this.fPeriodTimeParameter.getTimer();
        timer.setNameKey("dialog.parameter.PWM.Period");
        return timer;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        this.fState = 0;
    }

    public IntValueProperties getRangeMinProperties() {
        if (this.fRangeMinProperties == null) {
            this.fRangeMinProperties = new AnalogValueProperties(MIN_TRIGGER, MAX_TRIGGER, 1, this.getRangeMin(), this.getDecimalPlace(), this.isAnalogValueDecimalPlacesAvailable(), "error.dialog.invalidValue", "Invalid value");
        } else {
            this.fRangeMinProperties.setCurrentValue(this.getRangeMin());
            this.fRangeMinProperties.setDecimalPlace(this.getDecimalPlace());
            this.fRangeMinProperties.setSuppressLeadingZeroes(this.isAnalogValueDecimalPlacesAvailable());
        }
        return this.fRangeMinProperties;
    }

    public IntValueProperties getRangeMaxProperties() {
        if (this.fRangeMaxProperties == null) {
            this.fRangeMaxProperties = new AnalogValueProperties(MIN_TRIGGER, MAX_TRIGGER, 1, this.getRangeMax(), this.getDecimalPlace(), this.isAnalogValueDecimalPlacesAvailable(), "error.dialog.invalidValue", "Invalid value");
        } else {
            this.fRangeMaxProperties.setCurrentValue(this.getRangeMax());
            this.fRangeMaxProperties.setDecimalPlace(this.getDecimalPlace());
            this.fRangeMaxProperties.setSuppressLeadingZeroes(this.isAnalogValueDecimalPlacesAvailable());
        }
        return this.fRangeMaxProperties;
    }

    public AnalogValueProperties getAx_TProperties() {
        if (this.fAx_TProperties == null) {
            this.fAx_TProperties = new AnalogValueProperties(MIN_TRIGGER, MAX_TRIGGER, 1, this.fAmplifiedX_T, this.getDecimalPlace(), this.isAnalogValueDecimalPlacesAvailable(), "error.dialog.invalidValue", "Invalid value");
        } else {
            this.fAx_TProperties.setCurrentValue(this.fAmplifiedX_T);
            this.fAx_TProperties.setDecimalPlace(this.getDecimalPlace());
            this.fAx_TProperties.setSuppressLeadingZeroes(this.isAnalogValueDecimalPlacesAvailable());
        }
        return this.fAx_TProperties;
    }

    protected static class TimeParameter
    extends TimeProtectionParameter {
        private static final long serialVersionUID = 4288331559885755059L;

        protected TimeParameter() {
        }
    }
}

