/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockConnector;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.InBlockConnectorEnumeration;
import DE.siemens.ad.logo.model.OutBlockConnectorEnumeration;
import DE.siemens.ad.logo.util.BlockEnumeration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;

public abstract class OutBlockConnector
extends BlockConnector {
    static final long serialVersionUID = -1327265253335074110L;
    private int serializedDataVersion = 1;
    transient boolean fValidData = false;
    transient boolean fValidDataAnalog;
    transient double fAnalogValue;
    protected Vector fNextConnectors = null;
    protected boolean fUseConstantValue;

    public OutBlockConnector() {
    }

    public OutBlockConnector(Block aggregat) {
        this.fOwner = aggregat;
    }

    public void connect(InBlockConnector previous) {
        if (!this.isConnected(previous)) {
            this.getNextConnectorsVar().add(previous);
            previous.connect(this);
            this.setWiringDiagramModified();
        }
    }

    public void disconnect(InBlockConnector connector) {
        if (this.fNextConnectors != null) {
            this.fNextConnectors.remove(connector);
        }
        this.setWiringDiagramModified();
    }

    public void disconnectAll() {
        InBlockConnectorEnumeration linkedConnectors = this.getLinkedConnectors();
        while (linkedConnectors.hasMoreElements()) {
            linkedConnectors.nextElement().disconnect(this);
        }
        this.fNextConnectors = null;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public int getValueTyp() {
        return this.getOwner().getOutConnectorValueType();
    }

    public BlockEnumeration getLinkedBlocks() {
        this.getNextConnectorsVar();
        return new BlockEnumeration(){
            int count = 0;

            public boolean hasMoreElements() {
                return this.count < OutBlockConnector.this.fNextConnectors.size();
            }

            public Block nextBlock() {
                if (this.count < OutBlockConnector.this.fNextConnectors.size()) {
                    return ((InBlockConnector)OutBlockConnector.this.fNextConnectors.elementAt(this.count++)).getOwner();
                }
                throw new NoSuchElementException("getNextBlocks-Enumeration");
            }
        };
    }

    public InBlockConnectorEnumeration getLinkedConnectors() {
        this.getNextConnectorsVar();
        return new InBlockConnectorEnumeration(){
            int count = 0;

            public boolean hasMoreElements() {
                return this.count < OutBlockConnector.this.fNextConnectors.size();
            }

            public InBlockConnector nextElement() {
                if (this.count < OutBlockConnector.this.fNextConnectors.size()) {
                    return (InBlockConnector)OutBlockConnector.this.fNextConnectors.elementAt(this.count++);
                }
                throw new NoSuchElementException("InBlockConnectorEnumeration");
            }
        };
    }

    public int getLinkedConnectorsCount() {
        return this.getNextConnectorsVar().size();
    }

    public String getLocalizedName(boolean longDescription) {
        return this.getOwner().getNumberString();
    }

    private Vector getNextConnectorsVar() {
        if (this.fNextConnectors == null) {
            this.fNextConnectors = new Vector(4, 2);
        }
        return this.fNextConnectors;
    }

    public double calculateAnalogValue() {
        if (!this.fValidDataAnalog) {
            this.fValidDataAnalog = true;
            double newValue = this.getOwner().calculateAnalogValue();
            if (newValue != this.fAnalogValue) {
                this.fAnalogValue = newValue;
                this.fireValueChanged();
            }
        }
        return this.fAnalogValue;
    }

    public int getConnectorPosition(BlockConnector connector) {
        return this.getOwner().getOutConnectorPosition((OutBlockConnector)connector);
    }

    public boolean isConnected(InBlockConnector connector) {
        if (this.fNextConnectors == null) {
            return false;
        }
        Vector nextConnectors = this.getNextConnectorsVar();
        Enumeration enumeration = nextConnectors.elements();
        if (enumeration.hasMoreElements()) {
            InBlockConnector oldConnector = (InBlockConnector)enumeration.nextElement();
            return oldConnector.getOwner() == connector.getOwner() && oldConnector.getOwner().getInConnectorPosition(oldConnector) == connector.getOwner().getInConnectorPosition(connector);
        }
        return false;
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
    }

    public void setDataInvalid() {
        this.fValidData = false;
        this.fValidDataAnalog = false;
    }

    public void write(StorableOutput dw) {
        super.write(dw);
    }

    public List findParallelOutBlockConnectors() {
        ArrayList<OutBlockConnector> parallelOutConnectors = new ArrayList<OutBlockConnector>();
        ArrayList inConnectors = new ArrayList();
        parallelOutConnectors.add(this);
        this.findParallelOutBlockConectorsRecursive(parallelOutConnectors, inConnectors);
        parallelOutConnectors.remove(this);
        return parallelOutConnectors;
    }

    public boolean isInvolvedInCrossConnection(List outConnectors, List inConnectors) {
        outConnectors.add(this);
        this.findParallelOutBlockConectorsRecursive(outConnectors, inConnectors);
        return outConnectors.size() >= 2 && inConnectors.size() >= 2;
    }

    private void findParallelOutBlockConectorsRecursive(List parallelOutBlockConnectors, List visitedInBlockConnectors) {
        InBlockConnectorEnumeration successors = this.getLinkedConnectors();
        InBlockConnector inBlockConnector = null;
        while (successors.hasMoreElements()) {
            inBlockConnector = successors.nextElement();
            if (visitedInBlockConnectors.contains(inBlockConnector)) continue;
            visitedInBlockConnectors.add(inBlockConnector);
            OutBlockConnector outBlockConnector = null;
            OutBlockConnectorEnumeration predecessors = inBlockConnector.getLinkedConnectors();
            while (predecessors.hasMoreElements()) {
                outBlockConnector = predecessors.nextElement();
                if (parallelOutBlockConnectors.contains(outBlockConnector)) continue;
                parallelOutBlockConnectors.add(outBlockConnector);
                outBlockConnector.findParallelOutBlockConectorsRecursive(parallelOutBlockConnectors, visitedInBlockConnectors);
            }
        }
    }

    public int getInputOutputType() {
        return 1;
    }

    public boolean isConstantValue() {
        return this.fUseConstantValue;
    }

    public void setUseConstantValue(boolean useConstantValue) {
        this.fUseConstantValue = useConstantValue;
    }
}

