/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.model.OptionsIfc;
import DE.siemens.ad.logo.util.ColorDialog;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.LogoPreviewPanel;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class OptionProperties
implements OptionsIfc,
Serializable {
    static final long serialVersionUID = -2094473870177617071L;
    private int optionsPropertiesSerializedDataVersion = 1;
    boolean fAutodetect = false;
    protected transient String fComPort = "";
    boolean fDisplayCommentLines = true;
    boolean fDisplayComments = true;
    boolean fDisplayConnectorNames = true;
    String fLanguage = "language.en_US";
    String[] fLanguages = new String[]{"language.de_DE", "language.en_US"};
    int fHorizontalPages = 1;
    int fVerticalPages = 1;
    boolean fPrintCommentLines = true;
    boolean fPrintComments = true;
    boolean fPrintConnectorNames = true;
    boolean fPrintParameterList = false;
    boolean fPrintProperties = false;
    protected transient boolean splitConnectionsOnImport = true;

    public OptionProperties() {
        this.fComPort = LogoProperties.instance().getProperty("port", "COM2");
        this.fLanguage = "language." + LogoProperties.instance().getProperty("language", "en_US");
    }

    public OptionProperties(LogoDrawing drawing) {
        this.fComPort = LogoProperties.instance().getProperty("port", "COM2");
        this.fLanguage = "language." + LogoProperties.instance().getProperty("language", "en_US");
    }

    public boolean getDisplayCommentLines() {
        return this.fDisplayCommentLines;
    }

    public boolean getDisplayComments() {
        return this.fDisplayComments;
    }

    public boolean getDisplayConnectorNames() {
        return this.fDisplayConnectorNames;
    }

    public String getLanguage() {
        String language = LogoProperties.instance().getProperty("language");
        if (language != null) {
            this.fLanguage = "language." + language;
        }
        return this.fLanguage;
    }

    public String[] getLanguages() {
        File directory = new File(Global.PATHBASE);
        final int resourceBundlePrefixLength = "Language".length();
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".properties") && name.startsWith("Language_") && name.length() == resourceBundlePrefixLength + "_xx_XX.properties".length();
            }
        };
        String[] properties = directory.list(filter);
        if (properties != null) {
            int size = properties.length;
            this.fLanguages = new String[size];
            for (int i = 0; i < size; ++i) {
                String languageKey = properties[i].substring(resourceBundlePrefixLength + 1, resourceBundlePrefixLength + 1 + "xx_XX".length());
                this.fLanguages[i] = "language." + languageKey;
            }
        } else {
            this.fLanguages = new String[1];
            this.fLanguages[0] = this.fLanguage;
        }
        return this.fLanguages;
    }

    public int getPagesHorizontal() {
        return this.fHorizontalPages;
    }

    public int getPagesVertical() {
        return this.fVerticalPages;
    }

    public boolean getPrintCommentLines() {
        return this.fPrintCommentLines;
    }

    public boolean getPrintComments() {
        return this.fPrintComments;
    }

    public boolean getPrintConnectorNames() {
        return this.fPrintConnectorNames;
    }

    public boolean getPrintParameterList() {
        return this.fPrintParameterList;
    }

    public boolean getPrintProperties() {
        return this.fPrintProperties;
    }

    public boolean getShowParameterValuesDuringSimulation() {
        String showParameterValuesString = LogoProperties.instance().getProperty("simulation.showCurrentParameter");
        if (showParameterValuesString != null) {
            return Boolean.valueOf(showParameterValuesString);
        }
        return true;
    }

    public boolean getShowStatesDuringSimulation() {
        String showStatesString = LogoProperties.instance().getProperty("simulation.showStates");
        if (showStatesString != null) {
            return Boolean.valueOf(showStatesString);
        }
        return true;
    }

    public boolean getSplitConnectionsOnImport() {
        String splitConnectinString = LogoProperties.instance().getProperty("splitConnectionsOnImport");
        if (splitConnectinString != null) {
            this.splitConnectionsOnImport = Boolean.valueOf(splitConnectinString);
        }
        return this.splitConnectionsOnImport;
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.fComPort = LogoProperties.instance().getProperty("port", "COM2");
    }

    public void setColor(Vector vector) {
        LogoProperties properties = LogoProperties.instance();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                LogoPreviewPanel prev = (LogoPreviewPanel)vector.get(i);
                String simColor = ColorDialog.getRGBofColor(prev.getColor());
                String property = null;
                if (prev.getKey().equals("Background")) {
                    property = "backColor";
                }
                if (prev.getKey().equals("Connection_Low")) {
                    property = "simulation.color.low";
                }
                if ((property = prev.getKey().equals("Connection_High") ? "simulation.color.high" : prev.getKey()) == null) continue;
                properties.setProperty(property, simColor);
            }
            Global.refreshColors();
        }
        properties.saveProperties();
    }

    public void setComPort(String cp) {
        if (!this.fComPort.equals(cp)) {
            this.fComPort = cp;
            LogoProperties.instance().setProperty("port", cp);
            LogoProperties.instance().saveProperties();
        }
    }

    public void setComPortAutoDetected(boolean ad) {
        this.fAutodetect = ad;
    }

    public void setDisplayCommentLines(boolean dcl) {
        if (this.fDisplayCommentLines != dcl) {
            // empty if block
        }
    }

    public void setDisplayComments(boolean dc) {
        if (this.fDisplayComments != dc) {
            // empty if block
        }
    }

    public void setDisplayConnectorNames(boolean dcn) {
        if (this.fDisplayConnectorNames != dcn) {
            // empty if block
        }
    }

    public void setLanguage(String l) {
        if (l.startsWith("language.")) {
            this.fLanguage = l;
            LogoProperties.instance().setProperty("language", this.fLanguage.substring(9));
            LogoProperties.instance().saveProperties();
        }
    }

    public void setPages(int ph, int pv) {
        this.fHorizontalPages = ph;
        this.fVerticalPages = pv;
    }

    public void setPrintCommentLines(boolean pcl) {
        this.fPrintCommentLines = pcl;
    }

    public void setPrintComments(boolean pc) {
        this.fPrintComments = pc;
    }

    public void setPrintConnectorNames(boolean pcn) {
        this.fPrintConnectorNames = pcn;
    }

    public void setPrintFlags(boolean comments, boolean commentLines, boolean connectorNames, boolean parameterList, boolean properties) {
        if (this.fPrintCommentLines != commentLines || this.fPrintConnectorNames != connectorNames) {
            // empty if block
        }
        this.fPrintComments = comments;
        this.fPrintCommentLines = commentLines;
        this.fPrintConnectorNames = connectorNames;
        this.fPrintParameterList = parameterList;
        this.fPrintProperties = properties;
    }

    public void setPrintParameterList(boolean ppl) {
        this.fPrintParameterList = ppl;
    }

    public void setPrintProperties(boolean pp) {
        this.fPrintProperties = pp;
    }

    public void setShowParameterValuesDuringSimulation(boolean newShowParameterValuesDuringSimulation) {
        LogoProperties.instance().setProperty("simulation.showCurrentParameter", new Boolean(newShowParameterValuesDuringSimulation).toString());
        LogoProperties.instance().saveProperties();
    }

    public void setShowStatesDuringSimulation(boolean newShowStatesDuringSimulation) {
        LogoProperties.instance().setProperty("simulation.showStates", new Boolean(newShowStatesDuringSimulation).toString());
        LogoProperties.instance().saveProperties();
    }

    public void setSplitConnectionsOnImport(boolean newSplitConnectionsOnImport) {
        LogoProperties.instance().setProperty("splitConnectionsOnImport", new Boolean(newSplitConnectionsOnImport).toString());
        LogoProperties.instance().saveProperties();
    }
}

