/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Time2ProtectionParameter;
import DE.siemens.ad.logo.model.TimeUnit;

public class OnOffDelayParameter
extends Time2ProtectionParameter {
    static final long serialVersionUID = 0L;
    private int serializedDataVersion = 1;

    public OnOffDelayParameter() {
    }

    public OnOffDelayParameter(Block block) {
        super(block);
        this.fParameter = 2;
        this.fData = 1;
        this.fAllocatedTimer = 1;
        this.setParameterNameKeys();
    }

    public boolean calculateValue(boolean trg) {
        boolean result = false;
        switch (this.fState) {
            case 0: {
                if (!trg) break;
                this.fTimer = this.getHTimer();
                this.fTimer.start();
                this.fState = 1;
                break;
            }
            case 1: {
                if (trg) {
                    if (!this.fTimer.isFinished()) break;
                    this.fState = 3;
                    result = true;
                    break;
                }
                this.fState = 0;
                this.fTimer.reset();
                break;
            }
            case 3: {
                if (!trg) {
                    this.fTimer = this.getLTimer();
                    this.fTimer.start();
                    this.fState = 2;
                }
                result = true;
                break;
            }
            case 2: {
                if (!trg) {
                    if (this.fTimer.isFinished()) {
                        this.fState = 0;
                        break;
                    }
                    result = true;
                    break;
                }
                this.fState = 0;
            }
        }
        return result;
    }

    public TimeUnit getRestTimeH() {
        if (this.fState == 1 || this.fState == 3) {
            return this.getHTimer().getRemainingTimeForShowing();
        }
        return TimeUnit.getNewTimeObject(this.getHTimer().getParamTime().getUnitKey());
    }

    protected void setParameterNameKeys() {
        this.getHTimer().setNameKey("dialog.parameter.onTime");
        this.getLTimer().setNameKey("dialog.parameter.offTime");
    }
}

