/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Hours;
import DE.siemens.ad.logo.util.Language;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;

public abstract class Mode
implements Serializable,
Storable {
    static final long serialVersionUID = 909132834597380441L;
    private int serializedDataVersion = 1;
    protected int fLogoMode;
    protected int[] fDays = new int[0];
    protected String fKey = "dialog.parameter.cam.mode";
    protected String fAbbreviation = "";

    public boolean contains(int day) {
        for (int i = 0; i < this.fDays.length; ++i) {
            if (this.fDays[i] != day) continue;
            return true;
        }
        return false;
    }

    public String getAbbreviation() {
        return this.fAbbreviation;
    }

    public Calendar getAbsoluteSwitchTime(Hours switchTime, Calendar currentTime) {
        Calendar absoluteSwitchTime = switchTime.overlay(currentTime);
        while (!this.contains(absoluteSwitchTime.get(7)) || absoluteSwitchTime.after(currentTime)) {
            absoluteSwitchTime.add(7, -1);
        }
        return absoluteSwitchTime;
    }

    public int[] getDays() {
        return this.fDays;
    }

    public int getLogoMode() {
        return this.fLogoMode;
    }

    public boolean isPredefinedMode() {
        return true;
    }

    public void read(StorableInput dr) throws IOException {
        int count = dr.readInt();
        if (count > 0) {
            this.fDays = new int[count];
            for (int i = 0; i < count; ++i) {
                this.fDays[i] = dr.readInt();
            }
        }
        this.fKey = dr.readString();
    }

    public void setDays(int[] days) {
        this.fDays = days;
    }

    public String toString() {
        return Language.getString(this.fKey, this.fKey);
    }

    public void write(StorableOutput dw) {
        dw.writeInt(this.fDays.length);
        for (int i = 0; i < this.fDays.length; ++i) {
            dw.writeInt(this.fDays[i]);
        }
        dw.writeString(this.fKey);
    }
}

