/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.util.IntValueProperties;
import DE.siemens.ad.logo.util.Util;
import java.io.IOException;

public class Minutes
extends TimeUnit {
    static final long serialVersionUID = 0L;
    private int minutesSerializedDataVersion = 1;
    public static final String UNIT_KEY = "dialog.timeParameter.minutes";
    public static final String DEFAULT_UNIT_STRING = "minutes";
    public static final String UNIT_ABBREVIATION = "m";

    public Minutes() {
        this.fHighMin = 0;
        this.fHighMax = 99;
        this.fHighInc = 1;
        this.fLowMin = 0;
        this.fLowMax = 59;
        this.fLowInc = 1;
    }

    public String getDefaultUnitString() {
        return DEFAULT_UNIT_STRING;
    }

    public Minutes(TimeUnit timeUnit) {
        this.setMilliseconds(timeUnit.getMilliseconds());
    }

    public IntValueProperties getHigh() {
        return new IntValueProperties(this.fHighMin, this.fHighMax, this.fHighInc, this.getHighValue(), "error.dialog.invalidValue", "Invalid Value for Minutes.");
    }

    public int getHighValue() {
        return (int)(this.fTime / 60000L);
    }

    public int[] getLogoTime() {
        int time = this.getHighValue() * 60 + this.getLowValue();
        int[] lTime = new int[]{time / 256 | 0x80, time % 256};
        return lTime;
    }

    public IntValueProperties getLow() {
        return new IntValueProperties(this.fLowMin, this.fLowMax, this.fLowInc, this.getLowValue(), "error.dialog.invalidValue", "Invalid Value for seconds.");
    }

    public int getLowValue() {
        return (int)(this.fTime / 1000L % 60L);
    }

    public String getUnitAbbreviation() {
        return UNIT_ABBREVIATION;
    }

    public String getUnitKey() {
        return UNIT_KEY;
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
    }

    public void setTime(int high, int low) {
        this.fTime = high * 1000 * 60 + low * 1000;
    }

    public TimeUnit setTime(int value) {
        int rangedValue = Util.getValueInRange(0, 5999, value);
        this.setTime(0, rangedValue);
        return this;
    }

    public void write(StorableOutput dw) {
        super.write(dw);
    }

    public String getLowValueUnitKey() {
        return "dialog.timeParameter.seconds";
    }

    public String getLowValueUnitAbbreviation() {
        return "s";
    }
}

