/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.dialog.comp.MessageDisplay;
import DE.siemens.ad.logo.dialog.comp.MessageReceiptListener;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.MessageParameterDisplayModelPlain;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.MessageManager;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ParameterItemList;
import DE.siemens.ad.logo.model.ParameterItemTable;
import DE.siemens.ad.logo.model.ProtectionParameter;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import DE.siemens.ad.logo.util.MessageGlobalInfo;
import DE.siemens.ad.logo.util.MessageLine;
import DE.siemens.ad.logo.util.MessageLineRTF;
import java.awt.Point;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Time;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;

public class MessageParameter
extends ProtectionParameter
implements MessageReceiptListener {
    private static transient Hashtable fSpecialCharactersTable;
    static final long serialVersionUID = 1L;
    private int serializedDataVersion = 2;
    private Integer fPriority = null;
    private boolean fReceipt = false;
    private boolean fReceiptDone = true;
    private MessageLine[] fMessage;
    private MessageText[] fMessageRTFs;
    private int fDefaultCharSetID = 0;
    private static final int MAX_CHARSET_COUNT = 2;
    private int fMsgNumber = -1;
    private transient boolean fOldInput1 = false;
    private transient long fEnableTime;
    private transient long fLastUpdateTime;
    private transient boolean fLastValue;

    private String replaceSpecialCharacters(String s) {
        Hashtable specialCharacters = MessageParameter.getSpecialCharactersTable();
        StringBuffer returnString = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char currentCharacter = s.charAt(i);
            if (!specialCharacters.containsKey(new Integer(currentCharacter))) {
                returnString.append(currentCharacter);
                continue;
            }
            String displayedString = (String)specialCharacters.get(new Integer(currentCharacter));
            if (displayedString == null) {
                returnString.append("!!!unknown special character!!!");
                continue;
            }
            returnString.append(displayedString);
        }
        return returnString.toString();
    }

    public MessageText getMessageRTF(int index) {
        if (index < 0 || index >= 2) {
            return null;
        }
        return this.getMessageRTFs()[index];
    }

    public MessageText[] getMessageRTFs() {
        if (this.fMessageRTFs == null) {
            this.fMessageRTFs = new MessageText[2];
        }
        return this.fMessageRTFs;
    }

    public int getCurrentTextID() {
        if (this.getMessageRTFs()[this.fDefaultCharSetID] == null) {
            this.fDefaultCharSetID = 1 - this.fDefaultCharSetID;
        }
        return this.fDefaultCharSetID;
    }

    public void setCurrentTextID(int index) {
        this.fDefaultCharSetID = index % 2;
    }

    public MessageParameter() {
    }

    public MessageParameter(Block block) {
        super(block);
        this.fParameter = 1;
        if (this.getBlock().getWiringDiagram() != null) {
            this.setPriority(this.getPriority());
            if (this.getBlock().getHardware() != null && this.getBlock().getHardware().supports("NeedMessageNumber")) {
                this.setMsgNumber(this.getMsgNumber());
            }
            if (this.getBlock().getWiringDiagram().getMessageManager().isRTFMessage()) {
                this.enableTextRTF(this.getMessageGlobalInfo().getCurCharSetID());
            }
        }
    }

    public boolean isRTF() {
        boolean ret = false;
        for (int i = 0; i < this.getMessageRTFs().length; ++i) {
            if (this.getMessageRTFs()[i] == null) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public boolean enableTextRTF(int charSetID) {
        int textID = this.getMessageManager().getFreeMessageTextID();
        if (textID == -1 || this.getMessageRTFs()[charSetID] != null) {
            return false;
        }
        this.getMessageRTFs()[charSetID] = new MessageText(textID, this.getMessageGlobalInfo().getSelectedCharSet(charSetID), this);
        System.out.println("TextID: " + this.getMessageRTFs()[charSetID].getTextID());
        this.fDefaultCharSetID = charSetID;
        return true;
    }

    public boolean disableTextRTF(int charSetID) {
        if (this.getMessageRTFs()[charSetID] == null || this.getMessageRTFs()[1 - charSetID] == null) {
            System.out.println("Delete message failed!");
            return false;
        }
        this.getMessageRTFs()[charSetID] = null;
        this.fDefaultCharSetID = 1 - charSetID;
        return true;
    }

    private MessageManager getMessageManager() {
        return this.getBlock().getWiringDiagram().getMessageManager();
    }

    private MessageGlobalInfo getMessageGlobalInfo() {
        return this.getBlock().getWiringDiagram().getMessageGlobalInfo();
    }

    protected boolean calculateValue(boolean input1) {
        long currentTime;
        boolean result;
        if (input1) {
            result = true;
            if (!this.fLastValue && this.isReceiptDone()) {
                this.fEnableTime = this.fInterpreter.getCurrentSimulationClockTime();
            }
            this.setReceiptDone(false);
        } else {
            result = !this.isReceiptDone();
        }
        if (this.fOldInput1 != input1) {
            this.getParameterUpdateEvent().setBinaryValue("I0", input1);
            this.fOldInput1 = input1;
            this.fCurrentParameterText = this.calculateCurrentParameterText();
            this.fireParameterUpdateEvent();
        }
        if ((currentTime = this.fInterpreter.getCurrentSimulationClockTime()) - this.fLastUpdateTime > 1000L) {
            this.fLastUpdateTime = currentTime;
            this.getParameterUpdateEvent().setBinaryValue("timeUpdated", false);
            this.fCurrentParameterText = this.calculateCurrentParameterText();
            this.fireParameterUpdateEvent();
        }
        this.fLastValue = result;
        return result;
    }

    public boolean getEnableInput() {
        return this.fOldInput1;
    }

    public MessageLine[] getMessage() {
        if (this.fMessage == null) {
            this.fMessage = new MessageLine[this.getNrOfMessageLines()];
            for (int i = 0; i < this.getNrOfMessageLines(); ++i) {
                this.fMessage[i] = new MessageLine(i);
            }
        }
        return this.fMessage;
    }

    public int getMsgNumber() {
        if (this.fMsgNumber == -1) {
            this.fMsgNumber = this.getMessageManager().getFreeMessageNumber();
        }
        return this.fMsgNumber;
    }

    protected int getNrOfMessageLines() {
        return 4;
    }

    public String getParameterText() {
        MessageLine[] messages = this.getMessage();
        StringBuffer result = new StringBuffer(46);
        StringBuffer crlf = new StringBuffer("\n");
        result.append("Prio = ").append(this.getPriority().toString()).append("\n");
        result.append(this.isReceipt() ? "Quit = on" : "Quit = off");
        if (this.isRTF()) {
            for (int i = 0; i < this.getMessageRTFs().length; ++i) {
                result.append(crlf);
                result.append("Text" + i);
                if (this.getMessageRTFs()[i] != null) {
                    result.append(MessageGlobalInfo.getCharSetName(this.getMessageGlobalInfo().getSelectedCharSet(i)));
                    continue;
                }
                result.append(": disabled");
            }
        } else {
            for (int i = 0; i < this.getMessage().length; ++i) {
                String s = this.getMessage()[i].getParameterText();
                if (s.trim().length() == 0) {
                    crlf.append("\n");
                    continue;
                }
                result.append(crlf);
                crlf.setLength(0);
                crlf.append("\n");
                result.append(this.replaceSpecialCharacters(s));
            }
        }
        return result.toString();
    }

    public Integer getPriority() {
        if (this.fPriority == null) {
            this.fPriority = this.getMessageManager().getFreePriority();
        }
        return this.fPriority;
    }

    public boolean getValue(boolean input1) {
        boolean result = this.calculateValue(input1);
        this.getParameterUpdateEvent().setBinaryValue(result);
        if (this.fLastBinaryValue != result) {
            this.fCurrentParameterText = this.calculateCurrentParameterText();
            this.fireParameterUpdateEvent();
            this.fLastBinaryValue = result;
        }
        return result;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        this.fOldInput1 = false;
        this.setReceiptDone(true);
        this.getParameterUpdateEvent().setBinaryValue("I0", false);
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        this.fireParameterUpdateEvent();
    }

    public boolean isReceipt() {
        return this.fReceipt;
    }

    public boolean isReceiptAllowed() {
        return false;
    }

    public boolean isReceiptDone() {
        return this.isReceipt() ? this.fReceiptDone : true;
    }

    public void messageReceipt(MessageDisplay messageDisplay) {
        this.setReceiptDone(true);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fPriority = new Integer(dr.readInt());
        this.setReceipt(dr.readBoolean());
        int numberOfMessageLines = this.getNrOfMessageLines();
        this.fMessage = new MessageLine[numberOfMessageLines];
        for (int i = 0; i < numberOfMessageLines; ++i) {
            this.fMessage[i] = new MessageLine(i);
        }
        this.fMsgNumber = dr.readInt();
    }

    public void setMessage(MessageLine[] newMessage) {
        if (newMessage != this.fMessage) {
            this.messageLinesCleared();
            this.fMessage = newMessage;
        }
    }

    public void setMessageRTF(MessageText newMessageText, int charSetID) {
        this.getMessageRTFs()[charSetID] = newMessageText;
    }

    public void setMsgNumber(int newMsgNumber) {
        this.fMsgNumber = newMsgNumber;
    }

    private boolean areMessageTextAndParametersMixed() {
        MessageLine[] messageLines = this.getMessage();
        for (int i = 0; i < messageLines.length; ++i) {
            ParameterItem parameterItem = messageLines[i].getParameterItem();
            if (parameterItem == null || messageLines[i].getLength() <= parameterItem.getWidth()) continue;
            return true;
        }
        return false;
    }

    private boolean areParameterItemsAvailable(Hardware newHardware) {
        if (this.isRTF()) {
            System.err.println("The 0BA7 newly added ParameterItems are imcompatible with 0BA6.");
        }
        MessageLine[] messageLines = this.getMessage();
        ParameterItemTable newParameterItemTable = null;
        try {
            newParameterItemTable = (ParameterItemTable)newHardware.getProperty("parameterItemTable");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        if (newParameterItemTable == null) {
            return false;
        }
        for (int i = 0; i < messageLines.length; ++i) {
            ParameterItem parameterItem = messageLines[i].getParameterItem();
            if (parameterItem != null) {
                String parameterItemIDinNewHardware;
                BlockParameter originalBlockParameter = messageLines[i].getBlockParameter();
                Block block = newHardware.getSubstitutionBlock(originalBlockParameter.getBlock());
                BlockParameter substitutedBlockParameter = block.getParameter();
                ParameterItemList parameterItemList = newParameterItemTable.getParameterItems(substitutedBlockParameter);
                if (parameterItemList.getParameterItem(parameterItemIDinNewHardware = newParameterItemTable.getSubstituteParameterItem(parameterItem.getIdentifier(), originalBlockParameter, substitutedBlockParameter)) != null) continue;
                return false;
            }
            BlockParameter blockParameter = messageLines[i].getBlockParameter();
            String parameterItemIdentifier = messageLines[i].getParameterItemIdentifier();
            if (blockParameter == null || parameterItemIdentifier == null) continue;
            return false;
        }
        return true;
    }

    public void hardwareChangeFinished(HardwareChangedEvent hardwareChangedEvent) {
        int i;
        Hardware oldHardware = (Hardware)hardwareChangedEvent.getOldValue();
        Hardware newHardware = (Hardware)hardwareChangedEvent.getNewValue();
        ParameterItemTable newParameterItemTable = (ParameterItemTable)newHardware.getProperty("parameterItemTable");
        MessageLine[] messageLines = this.getMessage();
        for (i = 0; i < messageLines.length; ++i) {
            BlockParameter blockParameter;
            String parameterItemIdentifier = messageLines[i].getParameterItemIdentifier();
            BlockParameter newBlockParameter = blockParameter = messageLines[i].getBlockParameter();
            if (blockParameter == null) continue;
            Block block = blockParameter.getBlock();
            if (hardwareChangedEvent.getSubstitutedBlocksDictionary().containsKey(block)) {
                Block newBlock = (Block)hardwareChangedEvent.getSubstitutedBlocksDictionary().get(block);
                newBlockParameter = newBlock.getParameter();
                messageLines[i].setBlockParameter(newBlockParameter);
            }
            if (parameterItemIdentifier != null && !parameterItemIdentifier.equals("")) {
                String parameterItemIDinNewHardware = newParameterItemTable.getSubstituteParameterItem(parameterItemIdentifier, blockParameter, newBlockParameter);
                if (parameterItemIdentifier.equals(parameterItemIDinNewHardware)) continue;
                messageLines[i].setParameterItemIdentifier(parameterItemIDinNewHardware);
                continue;
            }
            System.err.println(this + ": No parameterItemIdentifier set although blockReference is set!");
        }
        if (this.isRTF()) {
            for (i = 0; i < this.getMessageRTFs().length; ++i) {
                if (this.getMessageRTFs()[i] == null) continue;
                for (int j = 0; j < this.getNrOfMessageLines(); ++j) {
                    this.getMessageRTF(i).getMessageLineRTF()[j].hardwareChangeFinished(hardwareChangedEvent);
                }
            }
        }
    }

    public boolean isAvailable(Hardware hw, List errorList) {
        boolean available = true;
        if (!super.isAvailable(hw, errorList)) {
            available = false;
        }
        if (this.isRTF() && !hw.supports("supportAsiaLanguage")) {
            errorList.add(new ErrorInfo(this, "error.convert.messageBlock.RTFNotSupported", hw));
            available = false;
        }
        if (this.containsSpecialCharacters() && !hw.supports("mixedMessageTextAndParameter")) {
            errorList.add(new ErrorInfo(this, "error.convert.messageBlock.specialCharactersNotSupported", hw));
            available = false;
        }
        if (this.areMessageTextAndParametersMixed() && !hw.supports("mixedMessageTextAndParameter")) {
            errorList.add(new ErrorInfo(this, "error.convert.messageBlock.parameterTextMixingNotSupported", hw));
            available = false;
        }
        if (this.isReceipt() && !hw.supports("messageBlockWithReceipt")) {
            errorList.add(new ErrorInfo(this, "error.convert.messageBlock.receiptNotSupported", hw));
            available = false;
        }
        if (!this.areParameterItemsAvailable(hw)) {
            errorList.add(new ErrorInfo(this, "error.convert.messageBlock.parameterItemNotAvailable", hw));
            available = false;
        }
        int maxWidth = hw.getIntProperty("displayWidth");
        if (this.getMinimumDisplayColumns() > maxWidth) {
            MessageLine[] messageLines = this.getMessage();
            StringBuffer wrongLines = new StringBuffer("[");
            for (int i = 0; i < messageLines.length; ++i) {
                if (messageLines[i].getLength() <= maxWidth) continue;
                wrongLines.append(i + 1).append(",");
            }
            wrongLines.deleteCharAt(wrongLines.length() - 1);
            if (wrongLines.length() == 2) {
                wrongLines.deleteCharAt(0);
            } else {
                wrongLines.append("]");
            }
            Object[] msgParam = new Object[]{wrongLines, new Integer(maxWidth)};
            if (wrongLines.length() == 1) {
                errorList.add(new ErrorInfo(this, "error.convert.messageBlock.oneLineTooSmall", msgParam, hw));
            } else if (wrongLines.length() < 6) {
                errorList.add(new ErrorInfo(this, "error.convert.messageBlock.linesToSmall", msgParam, hw));
            } else {
                msgParam = new Object[]{new Integer(maxWidth)};
                errorList.add(new ErrorInfo(this, "error.convert.messageBlock.displayToSmall", msgParam, hw));
            }
            available = false;
        }
        if (this.getPriority() > hw.getIntProperty("msgPrioCount") - 1) {
            errorList.add(new ErrorInfo(this, "error.convert.messageBlock.tooMuchPrio", hw));
            available = false;
        }
        return available;
    }

    private boolean containsSpecialCharacters() {
        if (this.fMessage == null) {
            return false;
        }
        for (int i = 0; i < this.fMessage.length; ++i) {
            String text = this.fMessage[i].getText();
            for (int j = 0; j < text.length(); ++j) {
                char currentCharacter = text.charAt(j);
                if (!MessageParameter.getSpecialCharactersTable().containsKey(new Integer(currentCharacter))) continue;
                return true;
            }
        }
        return false;
    }

    public static Hashtable getSpecialCharactersTable() {
        if (fSpecialCharactersTable == null) {
            fSpecialCharactersTable = new Hashtable();
            fSpecialCharactersTable.put(new Integer(143), "\u00b0C");
            fSpecialCharactersTable.put(new Integer(159), "\u00b0F");
            fSpecialCharactersTable.put(new Integer(204), "\u00b0");
            fSpecialCharactersTable.put(new Integer(128), Character.toString('\u25b2'));
            fSpecialCharactersTable.put(new Integer(129), Character.toString('\u25bc'));
            fSpecialCharactersTable.put(new Integer(130), Character.toString('\u25c4'));
            fSpecialCharactersTable.put(new Integer(131), Character.toString('\u25ba'));
            fSpecialCharactersTable.put(new Integer(186), Character.toString('\u00b1'));
        }
        return fSpecialCharactersTable;
    }

    private int getMinimumDisplayColumns() {
        MessageLine[] messageLines = this.getMessage();
        int maxColumn = -1;
        for (int i = 0; i < messageLines.length; ++i) {
            int currentLineLength = messageLines[i].getLength();
            maxColumn = Math.max(maxColumn, currentLineLength);
        }
        return maxColumn;
    }

    public void setPriority(Integer newPriority) {
        this.fPriority = newPriority;
    }

    public void setReceipt(boolean newReceipt) {
        this.fReceipt = newReceipt;
        if (newReceipt) {
            if (!this.fOldInput1) {
                this.setReceiptDone(true);
            } else {
                this.setReceiptDone(false);
            }
        } else if (this.fOldInput1) {
            this.setReceiptDone(false);
        } else {
            this.setReceiptDone(true);
        }
    }

    public void setReceiptDone(boolean newReceiptDone) {
        this.fReceiptDone = newReceiptDone;
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fPriority);
        dw.writeBoolean(this.isReceipt());
        dw.writeInt(this.fMsgNumber);
    }

    public Time getEnableTime() {
        return new Time(this.fEnableTime);
    }

    public void setEnableTime(Time newTime) {
        this.fEnableTime = newTime.getTime();
    }

    public Date getEnableDate() {
        return new Date(this.fEnableTime);
    }

    public void setEnableDate(Date newDate) {
        this.fEnableTime = newDate.getTime();
    }

    public Time getCurrentTime() {
        if (this.fInterpreter != null) {
            return new Time(this.fInterpreter.getCurrentSimulationClockTime());
        }
        return new Time(System.currentTimeMillis());
    }

    public void setCurrentTime(Time value) {
        throw new IllegalStateException("The method " + this.getClass().getName() + ".setCurrentTime(Time) is not supported");
    }

    public void setCurrentDate(Date value) {
        throw new IllegalStateException("The method " + this.getClass().getName() + ".setCurrentDate(Date) is not supported");
    }

    public Date getCurrentDate() {
        if (this.fInterpreter != null) {
            return new Date(this.fInterpreter.getCurrentSimulationClockTime());
        }
        return new Date(System.currentTimeMillis());
    }

    public boolean syncPlainToRTFStyle() {
        MessageParameterDisplayModelPlain preModel = new MessageParameterDisplayModelPlain(this);
        DisplayElement dispElement = null;
        Point point = new Point();
        this.getMessageRTFs()[0] = null;
        this.getMessageRTFs()[1] = null;
        this.enableTextRTF(0);
        for (int y = 0; y < preModel.getDisplayDimension().height; ++y) {
            int x = 0;
            while (x < preModel.getDisplayDimension().width) {
                point.setLocation(x, y);
                dispElement = preModel.getElementAt(point);
                if (dispElement != null) {
                    this.getMessageRTFs()[0].getMessageLineRTF()[y].setDisplayElement(dispElement, x);
                    x += dispElement.getWidth();
                    continue;
                }
                ++x;
            }
        }
        this.messageLinesCleared();
        return true;
    }

    private void messageLinesCleared() {
        if (this.fMessage != null) {
            for (int i = 0; i < this.fMessage.length; ++i) {
                this.fMessage[i].removeAsParameterListener();
            }
            this.fMessage = null;
        }
    }

    public boolean syncRTFToPlainStyle() {
        if (this.getMessageRTFs() == null) {
            System.out.println("error, no messageLineRTF to remove.");
            return true;
        }
        for (int i = 0; i < this.getMessageRTFs().length; ++i) {
            this.getMessageRTFs()[i] = null;
        }
        return true;
    }

    public static class MessageText
    implements Serializable {
        private static final long serialVersionUID = -6462193082274717830L;
        private int fTickerType = 0;
        private int fShowDest = 3;
        private int fTextID = -1;
        private MessageParameter fOwner;
        private MessageLineRTF[] fMessageLineRTF;

        public MessageText(int textID, int charSet, MessageParameter owner) {
            this.fTextID = textID;
            this.fOwner = owner;
            this.fMessageLineRTF = new MessageLineRTF[this.fOwner.getNrOfMessageLines()];
            for (int i = 0; i < this.fMessageLineRTF.length; ++i) {
                this.fMessageLineRTF[i] = new MessageLineRTF(owner, i, charSet);
            }
        }

        public MessageText() {
        }

        public void copyFrom(MessageText source, MessageParameter cloneParam) {
            this.fMessageLineRTF = new MessageLineRTF[4];
            this.setTickerType(source.getTickerType());
            this.setShowDest(source.getShowDest());
            this.fTextID = source.getTextID();
            this.fOwner = source.fOwner;
            MessageLineRTF[] srcLines = source.getMessageLineRTF();
            MessageLineRTF[] cloneLines = this.getMessageLineRTF();
            for (int i = 0; i < cloneLines.length; ++i) {
                cloneLines[i] = new MessageLineRTF(cloneParam);
                cloneLines[i].copyFrom(srcLines[i], false);
            }
        }

        public void clearMapInfo() {
            for (int i = 0; i < this.fMessageLineRTF.length; ++i) {
                this.fMessageLineRTF[i].clearMapInfo();
            }
        }

        public int getTickerType() {
            return this.fTickerType;
        }

        public void setTickerType(int tickerType) {
            this.fTickerType = tickerType % 2;
        }

        public int getShowDest() {
            return this.fShowDest;
        }

        public void setShowDest(int dest) {
            this.fShowDest = dest;
        }

        public int getTextID() {
            return this.fTextID;
        }

        public MessageLineRTF[] getMessageLineRTF() {
            return this.fMessageLineRTF;
        }
    }
}

