/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.MessageParameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.MessageBlock;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.MessageGlobalInfo;
import DE.siemens.ad.logo.util.MessageLine;
import DE.siemens.ad.logo.util.MessageLineRTF;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;

public class MessageManager {
    private WiringDiagram fWiringDiagram;

    private MessageManager() {
        System.out.println("Warnung: new MessageManager() enth\u00e4lt kein wiringDiagram");
    }

    public MessageManager(WiringDiagram wd) {
        this.setWiringDiagram(wd);
    }

    public int getFreeMessageNumber() {
        int i;
        MessageBlock[] msgBlocks = this.getMessageBlocks();
        boolean[] used = new boolean[this.getWiringDiagram().getHardware().getMaxResource(12)];
        for (i = 0; i < msgBlocks.length; ++i) {
            int number = ((MessageParameter)msgBlocks[i].getParameter()).getMsgNumber();
            if (used[number]) {
                System.err.println("error, duplicated Message number (for uploading, it's OK)");
            }
            used[number] = true;
        }
        for (i = 0; i < used.length; ++i) {
            if (used[i]) continue;
            return i;
        }
        System.out.println("Error MessageManager.getFreeMessageNumber(): Zu wenig Meldetextnummern verf\u00fcgbar!");
        return 0;
    }

    public Vector getFreePriorities() {
        MessageBlock[] msgBlocks = this.getMessageBlocks();
        boolean[] used = new boolean[this.getNrOfPriority()];
        Vector<Integer> result = new Vector<Integer>();
        for (int i = 0; i < msgBlocks.length; ++i) {
            used[((MessageParameter)msgBlocks[i].getParameter()).getPriority().intValue()] = true;
        }
        boolean j = false;
        for (int i = 0; i < used.length; ++i) {
            if (used[i]) continue;
            result.add(new Integer(i));
        }
        return result;
    }

    public int getFreeMessageTextID() {
        int ret;
        int maxCount = 50;
        boolean[] used = new boolean[maxCount];
        MessageBlock[] msgBlocks = this.getMessageBlocks();
        for (int i = 0; i < msgBlocks.length; ++i) {
            for (int j = 0; j < 2; ++j) {
                MessageParameter.MessageText msgText = ((MessageParameter)msgBlocks[i].getParameter()).getMessageRTF(j);
                if (msgText == null) continue;
                int textID = msgText.getTextID();
                if (used[textID]) {
                    System.err.println("error, duplicated Text ID (for uploading, it's OK)");
                    continue;
                }
                used[textID] = true;
            }
        }
        for (ret = 0; ret < maxCount && used[ret]; ++ret) {
        }
        if (ret == maxCount) {
            ret = -1;
        }
        return ret;
    }

    public int getUsedTextIDCount() {
        int ret = 0;
        MessageBlock[] msgBlocks = this.getMessageBlocks();
        for (int i = 0; i < msgBlocks.length; ++i) {
            for (int j = 0; j < 2; ++j) {
                MessageParameter.MessageText msgText = ((MessageParameter)msgBlocks[i].getParameter()).getMessageRTF(j);
                if (msgText == null) continue;
                ++ret;
            }
        }
        return ret;
    }

    public int getFreeID(int type, Block block, Vector currentUsedIDs) {
        int ret;
        int i;
        int maxCount = this.getMaxIDResource(type);
        boolean[] used = new boolean[maxCount];
        MessageBlock[] msgBlocks = this.getMessageBlocks();
        for (i = 0; i < msgBlocks.length; ++i) {
            if (msgBlocks[i] == block) continue;
            for (int j = 0; j < 2; ++j) {
                MessageParameter.MessageText msgText = ((MessageParameter)msgBlocks[i].getParameter()).getMessageRTF(j);
                if (msgText == null) continue;
                MessageLineRTF[] lines = msgText.getMessageLineRTF();
                for (int k = 0; k < lines.length; ++k) {
                    Object[] IDs = this.getIdArray(lines[k], type);
                    for (int p = 0; p < IDs.length; ++p) {
                        used[((Integer)IDs[p]).intValue()] = true;
                    }
                }
            }
        }
        for (i = 0; i < currentUsedIDs.size(); ++i) {
            used[((Integer)currentUsedIDs.elementAt((int)i)).intValue()] = true;
        }
        for (ret = 0; ret < maxCount && used[ret]; ++ret) {
        }
        if (ret == maxCount) {
            ret = -1;
        }
        return ret;
    }

    private int getMaxIDResource(int type) {
        if (type == MessageLineRTF.BAR_ID) {
            return 32;
        }
        if (type == MessageLineRTF.STATUS_NAME_IO_ID) {
            return 20;
        }
        return 0;
    }

    private Object[] getIdArray(MessageLineRTF line, int type) {
        if (type == MessageLineRTF.BAR_ID) {
            return line.getBarGraphMap().keySet().toArray();
        }
        if (type == MessageLineRTF.STATUS_NAME_IO_ID) {
            return line.getIONameMap().keySet().toArray();
        }
        return null;
    }

    private int getNrOfPriority() {
        return this.fWiringDiagram.getHardware().getIntProperty("msgPrioCount");
    }

    public Integer getFreePriority() {
        int i;
        MessageBlock[] msgBlocks = this.getMessageBlocks();
        boolean[] used = new boolean[this.getNrOfPriority()];
        for (i = 0; i < msgBlocks.length; ++i) {
            used[((MessageParameter)msgBlocks[i].getParameter()).getPriority().intValue()] = true;
        }
        for (i = 0; i < used.length; ++i) {
            if (used[i]) continue;
            return new Integer(i);
        }
        System.out.println("Error MessageManager.getFreePriority(): Zu wenig Priorit\u00e4ten verf\u00fcgbar!");
        return new Integer(0);
    }

    public MessageBlock[] getMessageBlocks() {
        Enumeration blocks = this.getWiringDiagram().getBlocks().elements();
        Vector<Block> msgBlocks = new Vector<Block>();
        while (blocks.hasMoreElements()) {
            Block block = (Block)blocks.nextElement();
            if (!(block instanceof MessageBlock)) continue;
            msgBlocks.add(block);
        }
        return msgBlocks.toArray(new MessageBlock[msgBlocks.size()]);
    }

    public MessageBlock[] getMessageBlocksToOutput() {
        Vector allOpenBlocks = this.getWiringDiagram().getOpenBlocks();
        MessageBlock[] msgBlocks = this.getMessageBlocks();
        Vector<MessageBlock> result = new Vector<MessageBlock>(5);
        int size = allOpenBlocks.size();
        for (int i = 0; i < msgBlocks.length; ++i) {
            if (allOpenBlocks.contains(msgBlocks[i])) continue;
            result.add(msgBlocks[i]);
        }
        return result.toArray(new MessageBlock[result.size()]);
    }

    protected WiringDiagram getWiringDiagram() {
        return this.fWiringDiagram;
    }

    public boolean isPriorityUsed(Integer testPrio) {
        MessageBlock[] msgBlocks = this.getMessageBlocks();
        boolean[] used = new boolean[this.getNrOfPriority()];
        for (int i = 0; i < msgBlocks.length; ++i) {
            used[((MessageParameter)msgBlocks[i].getParameter()).getPriority().intValue()] = true;
        }
        return used[testPrio];
    }

    public boolean isMsgNumberUsed(Integer msgNUmber) {
        MessageBlock[] msgBlocks = this.getMessageBlocks();
        boolean[] used = new boolean[this.getWiringDiagram().getHardware().getMaxResource(12)];
        for (int i = 0; i < msgBlocks.length; ++i) {
            used[((MessageParameter)msgBlocks[i].getParameter()).getMsgNumber()] = true;
        }
        return used[msgNUmber];
    }

    private void setWiringDiagram(WiringDiagram newWiringDiagram) {
        this.fWiringDiagram = newWiringDiagram;
    }

    public String toString() {
        return super.toString();
    }

    public void verifyMessageLineParameterReferences() {
        MessageParameter messageParameter = null;
        Object blockParameter = null;
        MessageBlock[] messageBlocks = this.getMessageBlocks();
        for (int i = 0; i < messageBlocks.length; ++i) {
            boolean messageLineCleared = false;
            messageParameter = (MessageParameter)messageBlocks[i].getParameter();
            messageLineCleared = this.messageLinesCleared(messageParameter);
            if (!messageLineCleared) continue;
            messageParameter.fireParameterSetEvent();
        }
    }

    private boolean messageLinesCleared(MessageParameter param) {
        boolean messageLineCleared = false;
        if (!this.isRTFMessage()) {
            MessageLine[] messageLines = param.getMessage();
            for (int i = 0; i < messageLines.length; ++i) {
                if (!messageLines[i].messageLineCleared()) continue;
                messageLineCleared = true;
            }
        } else {
            for (int index = 0; index < 2; ++index) {
                if (param.getMessageRTF(index) == null) continue;
                MessageLineRTF[] messageLines = param.getMessageRTF(index).getMessageLineRTF();
                for (int i = 0; i < messageLines.length; ++i) {
                    if (!messageLines[i].messageLineCleared()) continue;
                    messageLineCleared = true;
                }
            }
        }
        return messageLineCleared;
    }

    public boolean isRTFMessage() {
        boolean ret = this.fWiringDiagram.getMessageGlobalInfo().isFUseNewFeature();
        if (ret && !this.fWiringDiagram.getHardware().supports("supportAsiaLanguage")) {
            System.err.println("Conliction in RTF new feature setting.");
        }
        return ret;
    }

    public boolean transferToRTF() {
        int i;
        MessageParameter messageParameter = null;
        boolean ret = true;
        MessageBlock[] messageBlocks = this.getMessageBlocks();
        for (i = 0; i < messageBlocks.length; ++i) {
            messageParameter = (MessageParameter)messageBlocks[i].getParameter();
            if (ret &= messageParameter.syncPlainToRTFStyle()) continue;
            System.out.println(messageParameter.getBlock().getNumberString());
            break;
        }
        Log.println("" + i + " " + Language.getString("dialog.parameter.message.transferToRTF", " Message blocks transferred to RTF style."));
        return ret;
    }

    public boolean transferToPlain() {
        int i;
        MessageParameter messageParameter = null;
        boolean ret = true;
        MessageBlock[] messageBlocks = this.getMessageBlocks();
        for (i = 0; i < messageBlocks.length; ++i) {
            messageParameter = (MessageParameter)messageBlocks[i].getParameter();
            if (ret &= messageParameter.syncRTFToPlainStyle()) continue;
            System.out.println(messageParameter.getBlock().getNumberString());
            break;
        }
        Log.println("" + i + " " + Language.getString("dialog.parameter.message.transferToNonRTF", " Message blocks transferred to plain style."));
        return ret;
    }

    public boolean transferToNewCharset(int charSetID, int newCharSet) {
        if (charSetID < 0 || charSetID >= 2 || MessageGlobalInfo.getCharSetName(newCharSet) == null) {
            System.err.println("MessageManager.transferToNewCharset(), invalid parameter.");
            return false;
        }
        MessageParameter messageParameter = null;
        MessageBlock[] msgBlocks = this.getMessageBlocks();
        for (int i = 0; i < msgBlocks.length; ++i) {
            messageParameter = (MessageParameter)msgBlocks[i].getParameter();
            MessageParameter.MessageText text = messageParameter.getMessageRTF(charSetID);
            if (text == null) continue;
            int textID = text.getTextID();
            int showDest = text.getShowDest();
            MessageParameter.MessageText newText = new MessageParameter.MessageText(textID, newCharSet, messageParameter);
            newText.setShowDest(showDest);
            messageParameter.setMessageRTF(newText, charSetID);
        }
        this.fWiringDiagram.getMessageGlobalInfo().setSelectedCharSets(newCharSet, charSetID);
        return true;
    }

    public boolean isTextExisted(int charsetID) {
        boolean ret = false;
        MessageBlock[] msgBlocks = this.getMessageBlocks();
        for (int i = 0; i < msgBlocks.length; ++i) {
            if (((MessageParameter)msgBlocks[i].getParameter()).getMessageRTF(charsetID % 2) == null) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public int getActiveCurCharSetID() {
        Block block = this.getMarkerWithLeftConnected(27);
        if (block != null) {
            return block.getBinaryValue() ? 1 : 0;
        }
        return this.fWiringDiagram.getMessageGlobalInfo().getCurCharSetID();
    }

    public Color getLEDBackLightColor() {
        Block block = this.getMarkerWithLeftConnected(25);
        if (block != null && block.getBinaryValue()) {
            return Global.LOGO_DISPLAY_COLOR_LED_ON;
        }
        return Global.LOGO_DISPLAY_COLOR;
    }

    private Block getMarkerWithLeftConnected(int blockNumber) {
        Block block = this.fWiringDiagram.getBlockByNumberExt(10, blockNumber);
        return block;
    }

    public void setFreeMessageNumber() {
        MessageBlock[] msgBlocks = this.getMessageBlocks();
        boolean[] used = new boolean[this.getWiringDiagram().getHardware().getMaxResource(12)];
        for (int i = 0; i < msgBlocks.length; ++i) {
            ((MessageParameter)msgBlocks[i].getParameter()).setMsgNumber(i);
            used[i] = true;
        }
    }

    public void clearMessageNumber() {
        MessageBlock[] msgBlocks = this.getMessageBlocks();
        for (int i = 0; i < msgBlocks.length; ++i) {
            ((MessageParameter)msgBlocks[i].getParameter()).setMsgNumber(0);
        }
    }
}

