/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.TransmissionFailedException;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.DrawingHistoryEntry;
import DE.siemens.ad.logo.model.DrawingProperties;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareFactory;
import DE.siemens.ad.logo.model.LogoConstants;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.visitor.build.CompilerFromHardware;
import DE.siemens.ad.logo.model.visitor.build.CompilerToHardware;
import DE.siemens.ad.logo.model.visitor.build.LinkerToLogo;
import DE.siemens.ad.logo.util.ExceptionAlreadyHandledException;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.Memory;
import DE.siemens.ad.logo.util.ProgramException;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.logo.util.Version;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;

public abstract class Logo
implements Serializable,
Hardware,
LogoConstants {
    static final long serialVersionUID = 1L;
    private int hardwareSerializedDataVersion = 1;
    protected static Hashtable cSystemInfoDict = new Hashtable(20);
    protected static final int INIT_SYSTEM_INFO_DICT_ITEMS = 20;
    protected transient Memory[] fMemories = null;
    protected transient Vector[] fAvailabelBlocks;
    protected transient WiringDiagram fDownloadedWiringDiagram;
    protected static int ADR_CHECKSUM = 1;
    protected static int ADR_FIRMWARE_ID = 2;
    protected static int ADR_PROGRAM_NAME = 3;
    protected static int ADR_SW_VERSION = 4;

    public abstract CompilerFromHardware getCompilerFromHardware();

    public int calculateBlockNumber(int opcode) throws IllegalArgumentException {
        if (opcode < 212) {
            return opcode - 192 + 1;
        }
        if (opcode < 216) {
            return opcode - 212 + 1;
        }
        if (opcode < 224) {
            return opcode - 216 + 1;
        }
        if (opcode < 232) {
            return opcode - 224 + 1;
        }
        if (opcode < 236) {
            throw new IllegalArgumentException();
        }
        if (opcode < 240) {
            return opcode - 236 + 1;
        }
        if (opcode < 242) {
            return opcode - 240 + 1;
        }
        if (opcode < 252) {
            throw new IllegalArgumentException();
        }
        if (opcode < 255) {
            return 0;
        }
        throw new IllegalArgumentException();
    }

    public void clearPasswordOnLogo(DataTransfer dt) throws TransmissionFailedException {
    }

    public void setPasswordOnLogo(DataTransfer dt) throws TransmissionFailedException {
    }

    public void downloadBlocks(DataTransfer dt) throws TransmissionFailedException {
        Memory[] memArr = this.getMemories();
        for (int i = 0; i < memArr.length; ++i) {
            memArr[i].download(dt);
        }
    }

    protected boolean downloadChecksum(DataTransfer dt, int checksum) throws TransmissionFailedException {
        dt.writeByte(this.getAdress(ADR_CHECKSUM), (checksum & 0xFF00) >> 8);
        dt.writeNextByte(checksum & 0xFF);
        return true;
    }

    protected boolean verifyChecksum(DataTransfer dt, int checksum) throws TransmissionFailedException {
        int deviceChecksume = this.uploadChecksum(dt);
        if (checksum == deviceChecksume) {
            System.out.println("checksum OK.");
        } else {
            if (dt.getHardware().getID() > 64) {
                throw new TransmissionFailedException(241);
            }
            System.err.println("Checksum error.");
        }
        return true;
    }

    public void downloadFirmwareID(int firmwareID) throws ExceptionAlreadyHandledException {
    }

    protected void downloadTransferScreenOn(DataTransfer dt) throws ExceptionAlreadyHandledException {
    }

    public void downloadPassword(DataTransfer dt) throws TransmissionFailedException {
    }

    protected void downloadAddtionalInfo(DataTransfer dt) throws TransmissionFailedException {
        this.downloadProgramName(dt);
        this.downloadPassword(dt);
        this.downloadAnalogOutputTable(dt);
        this.downloadStartScreen(dt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadProgram(DataTransfer dt, WiringDiagram wd) throws ExceptionAlreadyHandledException {
        boolean tryAgain;
        this.fDownloadedWiringDiagram = wd;
        do {
            tryAgain = false;
            try {
                dt.reset();
                this.downloadTransferScreenOn(dt);
                this.downloadBlocks(dt);
                int checksum = this.getChecksum();
                this.downloadChecksum(dt, checksum);
                this.downloadAddtionalInfo(dt);
                dt.writeCommandByte(16640, 0, this.getResetTimeout());
                this.verifyChecksum(dt, checksum);
            }
            catch (TransmissionFailedException tfe) {
                tryAgain = LogoError.checkRepeatTransmission(tfe);
                if (tryAgain) continue;
                throw new ExceptionAlreadyHandledException();
            }
        } while (tryAgain);
    }

    public int getResetTimeout() {
        return 1001;
    }

    protected void downloadProgramName(DataTransfer dt) throws TransmissionFailedException {
    }

    protected void downloadAnalogOutputTable(DataTransfer dt) throws TransmissionFailedException {
    }

    protected void downloadStartScreen(DataTransfer dt) throws TransmissionFailedException {
    }

    public void downloadSummerWintertime(DataTransfer dt, int[] param) throws UnsupportedOperationException, TransmissionFailedException {
        throw new UnsupportedOperationException();
    }

    public Vector[] getAvailableBlocks() {
        if (this.fAvailabelBlocks == null) {
            String[][] blockNames = this.getBlockClassNames();
            Vector[] result = new Vector[blockNames.length];
            for (int arrCount = 0; arrCount < blockNames.length; ++arrCount) {
                Vector<Block> resultArr = new Vector<Block>();
                for (int elementCount = 0; elementCount < blockNames[arrCount].length; ++elementCount) {
                    try {
                        resultArr.addElement(Block.createTemplate(blockNames[arrCount][elementCount]));
                        continue;
                    }
                    catch (ExceptionAlreadyHandledException e) {
                        // empty catch block
                    }
                }
                result[arrCount] = resultArr;
            }
            this.fAvailabelBlocks = Block.sort(result);
        }
        return this.fAvailabelBlocks;
    }

    private String[][] getBlockClassNames() {
        String[][] blockNames = (String[][])this.getProperty("knownBlocks");
        String[][] blockClassNames = new String[blockNames.length][];
        for (int i = 0; i < blockNames.length; ++i) {
            blockClassNames[i] = new String[blockNames[i].length];
            blockClassNames[i][0] = "DE.siemens.ad.logo.model." + blockNames[i][0] + "Block";
            for (int j = 1; j < blockNames[i].length; ++j) {
                blockClassNames[i][j] = "DE.siemens.ad.logo.model.block." + blockNames[i][j] + "Block";
            }
        }
        return blockClassNames;
    }

    protected int getChecksum() {
        int result = 0;
        Memory[] memArr = this.getMemories();
        for (int i = 0; i < memArr.length; ++i) {
            if (!memArr[i].isChecksumRelevant()) continue;
            result += memArr[i].getChecksum();
        }
        return result;
    }

    public int getChecksum(WiringDiagram wd) {
        wd.compile();
        int result = this.getChecksum();
        return result;
    }

    public abstract CompilerToHardware getCompilerToHardware();

    public abstract LinkerToLogo getLinkerToHardware();

    public int getFirmwareID() {
        throw new UnsupportedOperationException("FW-ID not defined in: " + this.getClass().getName());
    }

    public Icon getIcon() {
        return Global.getIcon(this.getIconName());
    }

    protected String getIconName() {
        String name = "";
        String className = this.getClass().getName();
        StringTokenizer st = new StringTokenizer(className, ".");
        while (st.hasMoreTokens()) {
            name = st.nextToken();
        }
        name = name.substring(0, name.length() - 1);
        name = name + "Icon.gif";
        return name;
    }

    public int getID() {
        return 255;
    }

    public String getLocalizedName() {
        String name = this.getName();
        return Language.getString("hardware." + name, name);
    }

    public String getLocalizedName(boolean longDescription) {
        if (longDescription) {
            return this.getLocalizedPath() + this.getLocalizedName();
        }
        return this.getLocalizedName();
    }

    public int getMaxResource(int resource) {
        int result = 0;
        int[] arr = (int[])this.getProperty("maxValues");
        if (resource < arr.length) {
            result = arr[resource];
        }
        return result;
    }

    public int[] getMaxResources() {
        int[] result = null;
        int[] arr = (int[])this.getProperty("maxValues");
        result = new int[HardwareFactory.getInstance().getResourceNames().length];
        System.arraycopy(arr, 0, result, 0, arr.length);
        return result;
    }

    public Memory[] getMemories() {
        return new Memory[0];
    }

    public Memory getMemory(String name) throws IndexOutOfBoundsException {
        int i = 0;
        Memory[] memArr = this.getMemories();
        while (memArr[i].getName() != name) {
            ++i;
        }
        return memArr[i];
    }

    protected int getMemorySize() {
        Memory mem = this.getMemory("Parameter");
        return mem.getOffsetAdress() + mem.size() * mem.getBlockSize();
    }

    public String getName() {
        String name = "";
        String className = this.getClass().getName();
        StringTokenizer st = new StringTokenizer(className, ".");
        while (st.hasMoreTokens()) {
            name = st.nextToken();
        }
        return name;
    }

    public abstract int getNumberOfTransferBytes();

    protected int getOpcodeCO(String name, int blockNr) throws IllegalArgumentException {
        --blockNr;
        if (name.equals("Input")) {
            return 192 + blockNr;
        }
        if (name.equals("AnalogInput")) {
            return 240 + blockNr;
        }
        if (name.equals("AsiInput")) {
            return 212 + blockNr;
        }
        if (name.equals("Output")) {
            return 216 + blockNr;
        }
        if (name.equals("Marker")) {
            return 224 + blockNr;
        }
        if (name.equals("AsiOutput")) {
            return 236 + blockNr;
        }
        if (name.equals("High")) {
            return 253;
        }
        if (name.equals("Low")) {
            return 254;
        }
        throw new IllegalArgumentException();
    }

    protected int getOpcodeGF(String name) throws IllegalArgumentException {
        if (name.equals("And")) {
            return 1;
        }
        if (name.equals("Or")) {
            return 2;
        }
        if (name.equals("Not")) {
            return 3;
        }
        if (name.equals("Nand")) {
            return 4;
        }
        if (name.equals("Nor")) {
            return 5;
        }
        if (name.equals("Xor")) {
            return 6;
        }
        if (name.equals("PecAnd")) {
            return 7;
        }
        if (name.equals("PecNand")) {
            return 8;
        }
        throw new IllegalArgumentException();
    }

    protected int getOpcodeSF(String name) throws IllegalArgumentException {
        if (name.equals("OnDelay")) {
            return 33;
        }
        if (name.equals("OffDelay")) {
            return 34;
        }
        if (name.equals("PulseRelay")) {
            return 35;
        }
        if (name.equals("Clock")) {
            return 36;
        }
        if (name.equals("LatchingRelay")) {
            return 37;
        }
        if (name.equals("SymPulseGenerator")) {
            return 38;
        }
        if (name.equals("RetentiveOnDelay")) {
            return 39;
        }
        if (name.equals("Counter")) {
            return 40;
        }
        if (name.equals("HoursCounter")) {
            return 41;
        }
        if (name.equals("WipingRelay")) {
            return 42;
        }
        if (name.equals("Trigger")) {
            return 44;
        }
        if (name.equals("AsymPulseGenerator")) {
            return 45;
        }
        if (name.equals("YearClock")) {
            return 46;
        }
        if (name.equals("OnOffDelay")) {
            return 47;
        }
        if (name.equals("Random")) {
            return 48;
        }
        if (name.equals("StairsSwitch")) {
            return 49;
        }
        if (name.equals("ComfortSwitch")) {
            return 50;
        }
        if (name.equals("WipingRelayPEC")) {
            return 51;
        }
        if (name.equals("Message")) {
            return 52;
        }
        if (name.equals("AnalogTrigger")) {
            return 53;
        }
        if (name.equals("AnalogComparator")) {
            return 54;
        }
        if (name.equals("Softkey")) {
            return 55;
        }
        throw new IllegalArgumentException();
    }

    protected int getAdress(int name) {
        throw new IllegalArgumentException("Adress: " + name + " not found in class Logo0");
    }

    public String getLocalizedPath() {
        return Language.getString("hardware.group." + this.getName(), "") + ".";
    }

    public Block getSubstitutionBlock(Block orgBlock) {
        return orgBlock;
    }

    public Object getProperty(String propertyName) throws IllegalArgumentException {
        String name = this.getName();
        Dictionary dict = (Dictionary)cSystemInfoDict.get(name);
        Object result = dict.get(propertyName);
        return result;
    }

    public Object getPropertyWithoutException(String propertyName) {
        String name = this.getName();
        Dictionary dict = (Dictionary)cSystemInfoDict.get(name);
        Object result = dict.get(propertyName);
        return result;
    }

    public int getIntProperty(String propertyName) throws IllegalArgumentException {
        int result = 0;
        Object property = this.getProperty(propertyName);
        if (property == null) {
            throw new IllegalArgumentException("Unknown Propertyname");
        }
        try {
            result = (Integer)property;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return result;
    }

    public String getSystemInfoString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Language.getString("dialog.hardware.knownBlocks", "Known blocks:"));
        buffer.append("\n");
        Vector[] allBlocks = this.getAvailableBlocks();
        for (int i = 0; i < allBlocks.length; ++i) {
            Enumeration enumeration = allBlocks[i].elements();
            buffer.append(((Block)enumeration.nextElement()).getLocalizedName(false)).append(":\t");
            while (enumeration.hasMoreElements()) {
                buffer.append(((Block)enumeration.nextElement()).getLocalizedName(false)).append(",");
            }
            buffer.setLength(buffer.length() - 1);
            buffer.append("\n");
        }
        buffer.append("\n");
        buffer.append(Language.getString("dialog.hardware.maxResources", "Max. Resources:"));
        buffer.append("\n");
        int[] iArr = (int[])this.getProperty("maxValues");
        for (int idx = 0; idx < iArr.length; ++idx) {
            String[] resNames = HardwareFactory.getInstance().getResourceNames();
            if (iArr[idx] == 0) continue;
            StringBuffer buf = new StringBuffer();
            buf.append(Language.getString("hardware." + resNames[idx], resNames[idx]));
            buf.append("                                           ").setLength(30);
            buffer.append(buf.toString() + iArr[idx] + "\n");
        }
        return buffer.toString();
    }

    public boolean isBlockNameAvailable(String searchValue) {
        String[][] blockNames = (String[][])this.getProperty("knownBlocks");
        for (int i = 0; i < blockNames.length; ++i) {
            String[] blockArr = blockNames[i];
            for (int j = 1; j < blockArr.length; ++j) {
                if (!blockArr[j].equals(searchValue)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isTypeIncluded(Hardware[] hwArr) {
        boolean retValue = false;
        String thisName = this.getName();
        for (int i = 0; i < hwArr.length; ++i) {
            if (!hwArr[i].getName().equals(thisName)) continue;
            retValue = true;
            break;
        }
        return retValue;
    }

    public Hardware prepareDownload(DataTransfer dt, WiringDiagram wd) throws ProgramException, ExceptionAlreadyHandledException {
        this.fDownloadedWiringDiagram = wd;
        if (!this.isHardwareProgrammable(dt)) {
            throw new ProgramException(Language.getString("error.deviceNeedOtherSWVersion", "You need a newer Software-Version"));
        }
        return this;
    }

    private boolean isHardwareProgrammable(DataTransfer dt) throws ExceptionAlreadyHandledException {
        if (this.supports("swVersion")) {
            try {
                int adress = this.getAdress(ADR_SW_VERSION);
                int remoteMajor = dt.readByte(adress);
                int remoteMinor = dt.readByte(adress + 1);
                Version version = Version.getCurrentVersion();
                if (remoteMajor > version.getMajorVersion() || remoteMinor > version.getMinorVersion()) {
                    return false;
                }
            }
            catch (TransmissionFailedException e) {
                throw new ExceptionAlreadyHandledException();
            }
        }
        return true;
    }

    public void prepareUpload(DataTransfer dt) throws ProgramException, ExceptionAlreadyHandledException {
        if (!this.isHardwareProgrammable(dt)) {
            throw new ProgramException(Language.getString("error.deviceNeedOtherSWVersion", "You need a newer Software-Version"));
        }
    }

    public boolean supports(String property) {
        Object result = this.getPropertyWithoutException(property);
        if (result == null) {
            return false;
        }
        return (Boolean)result;
    }

    public String toString() {
        return this.getName();
    }

    public void uploadBlocks(DataTransfer dt) throws TransmissionFailedException {
        Memory[] memArr = this.getMemories();
        for (int i = 0; i < memArr.length; ++i) {
            memArr[i].upload(dt);
        }
    }

    protected int uploadChecksum(DataTransfer dt) throws TransmissionFailedException {
        int retWert = 0;
        retWert = (dt.readByte(this.getAdress(ADR_CHECKSUM)) & 0xFF) << 8;
        return retWert += dt.readNextByte();
    }

    public int uploadFirmwareID(DataTransfer dt) throws TransmissionFailedException {
        int retWert = 0;
        retWert = (dt.readByte(this.getAdress(ADR_FIRMWARE_ID)) & 0xFF) << 8;
        return retWert += dt.readNextByte();
    }

    public String uploadFunctionParameter(DataTransfer dt, int prgLine, int opcode, int parameterNr) throws UnsupportedOperationException, TransmissionFailedException {
        throw new UnsupportedOperationException();
    }

    protected String uploadPassword(DataTransfer dt) throws TransmissionFailedException {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WiringDiagram uploadProgram(DataTransfer dt) throws ExceptionAlreadyHandledException, ProgramException {
        WiringDiagram wd = null;
        boolean tryAgain = true;
        while (tryAgain) {
            System.out.println("Transfering data...");
            tryAgain = false;
            try {
                dt.reset();
                this.downloadTransferScreenOn(dt);
                this.prepareUpload(dt);
                this.uploadBlocks(dt);
                DrawingProperties drawingProp = this.uploadAddtionalInfo(dt);
                int checksum = this.getChecksum();
                int loadedChecksum = this.uploadChecksum(dt);
                if ((checksum &= 0xFFFF) != loadedChecksum) {
                    System.err.println("Checksumerror");
                    System.err.println("CS calculated: " + Integer.toHexString((checksum & 0xFF00) >> 8) + " " + Integer.toHexString(checksum & 0xFF));
                    System.err.println("CS loaded    : " + Integer.toHexString((loadedChecksum & 0xFF00) >> 8) + " " + Integer.toHexString(loadedChecksum & 0xFF));
                    throw new TransmissionFailedException(241);
                }
                System.out.println("Creating drawing...");
                wd = this.getCompilerFromHardware().compile(this);
                wd.setDrawingProperties(drawingProp);
            }
            catch (TransmissionFailedException tfe) {
                tryAgain = LogoError.checkRepeatTransmission(tfe);
                if (tryAgain) continue;
                throw new ExceptionAlreadyHandledException();
                return wd;
            }
        }
    }

    protected DrawingProperties uploadAddtionalInfo(DataTransfer dt) throws TransmissionFailedException {
        DrawingProperties ret = new DrawingProperties();
        ret.addHistoryEntry(new DrawingHistoryEntry());
        String programName = this.uploadProgramName(dt);
        String password = this.uploadPassword(dt);
        int[] analogOutputTable = this.uploadAnalogOutputTable(dt);
        boolean startScreen = this.uploadStarScreen(dt);
        ret.setProgramName(programName);
        ret.setPassword(password);
        ret.setStartScreenIO(startScreen);
        if (analogOutputTable != null) {
            ret.setAnalogOutputLastValueStatus(analogOutputTable[0] == 1);
            ret.setAnalogOutputFixedValue1((double)Util.makeWord(analogOutputTable[1], analogOutputTable[2]) / 100.0);
            ret.setAnalogOutputFixedValue2((double)Util.makeWord(analogOutputTable[3], analogOutputTable[4]) / 100.0);
        }
        return ret;
    }

    protected String uploadProgramName(DataTransfer dt) throws TransmissionFailedException {
        return "                ";
    }

    public int[] uploadAnalogOutputTable(DataTransfer dt) throws TransmissionFailedException {
        return null;
    }

    public boolean uploadStarScreen(DataTransfer dt) throws TransmissionFailedException {
        return false;
    }

    public int[] uploadSummerWintertime(DataTransfer dt) throws UnsupportedOperationException, TransmissionFailedException {
        throw new UnsupportedOperationException();
    }
}

