/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.model.AbstractInputSimulationParameter;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.util.DoubleValueProperties;
import java.io.IOException;
import java.io.ObjectInputStream;

public class InputSimulationParameter
extends AbstractInputSimulationParameter {
    static final long serialVersionUID = -3932360645002082173L;
    private int serializedDataVersion = 2;
    private static final int MIN_VALUE = 0;
    private static final int MAX_VALUE = 9999;
    private boolean fInputState;

    public InputSimulationParameter(Block block, int switchMode, int analogousValue) {
        super(block);
        this.fSwitchMode = switchMode;
        this.fAnalogousValue = analogousValue;
        this.setThresholdValue(9999.0);
    }

    protected double getAutoMaxValue() {
        return 9999.0;
    }

    protected double getAutoMinValue() {
        return 0.0;
    }

    public int[] getAvailableSwitchModes() {
        return new int[]{0, 1, 8, 2};
    }

    public DoubleValueProperties getMaxValueProperties() {
        return new DoubleValueProperties(0.0, 9999.0, 1.0, this.getMaxValue(), "-###0", "error.dialog.invalidValue", "Invalid Value");
    }

    public DoubleValueProperties getMinValueProperties() {
        return new DoubleValueProperties(0.0, 9999.0, 1.0, this.getMinValue(), "-###0", "error.dialog.invalidValue", "Invalid Value");
    }

    public int getSwitchMode() {
        return this.fSwitchMode;
    }

    public void inputPressed() {
        this.fInputState = true;
        if (this.fSwitchMode == 0) {
            this.fInputState = !this.fBinaryValue;
            this.setBinaryValue(!this.fBinaryValue);
        }
        if (this.fSwitchMode == 1) {
            this.setBinaryValue(true);
        }
        if (this.fSwitchMode == 8) {
            this.setBinaryValue(false);
        }
    }

    public void inputReleased() {
        if (this.fSwitchMode == 1) {
            this.fInputState = false;
            this.setBinaryValue(false);
        }
        if (this.fSwitchMode == 8) {
            this.fInputState = false;
            this.setBinaryValue(true);
        }
    }

    public boolean getInputState() {
        return this.fInputState;
    }

    public void setSwitchMode(int mode) {
        this.fBinaryValue = false;
        this.fInputState = false;
        super.setSwitchMode(mode);
        this.inputReleased();
    }

    public void setBinaryValue(boolean newValue) {
        this.fInputState = this.fSwitchMode == 8 ? !newValue : newValue;
        super.setBinaryValue(newValue);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.serializedDataVersion < 2) {
            this.serializedDataVersion = 2;
            if (this.fSwitchMode == 0) {
                this.fInputState = this.fBinaryValue;
            }
        }
    }
}

