/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnectorEnumeration;
import DE.siemens.ad.logo.model.Visitable;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.visitor.build.Visitor;
import DE.siemens.ad.logo.util.CodeBlock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public abstract class InBlockConnector
extends BlockConnector
implements Visitable {
    private static short DEFAULT_NOTCONNECTED_CODE = (short)255;
    private static short CHANGED_NOTCONNECTED_CODE = (short)252;
    private short fNotConnectedCode = DEFAULT_NOTCONNECTED_CODE;
    protected String fConnectorName = "";
    static final long serialVersionUID = 297451429369297172L;
    private int serializedDataVersion = 2;
    protected double fDefaultAnalogValue;
    protected OutBlockConnector fPreviousConnector = null;
    protected Vector fPreviousConnectors = null;
    protected boolean fMultiConnection = false;

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fConnectorName = dr.readString();
        this.fDefaultAnalogValue = dr.readDouble();
        this.fNotConnectedCode = (short)dr.readInt();
        System.out.println("read: " + this.fConnectorName + " " + this.fNotConnectedCode);
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeString(this.fConnectorName);
        dw.writeDouble(this.fDefaultAnalogValue);
        dw.writeInt(this.fNotConnectedCode);
    }

    public void setName(String name) {
        this.fConnectorName = name;
    }

    public String getLocalizedName(boolean longDescription) {
        if (longDescription) {
            return this.getOwner().getNumberString() + "/" + this.fConnectorName;
        }
        return this.fConnectorName;
    }

    public String getName() {
        return this.fConnectorName;
    }

    public InBlockConnector() {
    }

    public InBlockConnector(Block aggregat, String name) {
        this.fConnectorName = name;
        this.fOwner = aggregat;
    }

    public Object acceptVisitor(Visitor visitor) {
        CodeBlock c = new CodeBlock(visitor, "visit");
        c.addParameter(this);
        Object returnValue = null;
        try {
            returnValue = c.execMethod();
        }
        catch (NoSuchMethodException e) {
            System.out.println("Methode visit(" + this + ")in " + visitor + " nicht definiert");
        }
        return returnValue;
    }

    public void connect(OutBlockConnector previous) {
        if (!this.isConnected(previous)) {
            if (!this.fMultiConnection) {
                if (this.fPreviousConnector == null) {
                    this.fPreviousConnector = previous;
                } else {
                    this.getPreviousConnectorsVar().add(this.fPreviousConnector);
                    this.fPreviousConnectors.add(previous);
                    this.fMultiConnection = true;
                }
            } else {
                this.fPreviousConnectors.add(previous);
            }
            previous.connect(this);
            this.setWiringDiagramModified();
        }
    }

    public void disconnect(OutBlockConnector connector) {
        if (connector == null) {
            return;
        }
        connector.disconnect(this);
        if (!this.fMultiConnection) {
            if (this.fPreviousConnector == connector) {
                this.fPreviousConnector = null;
            }
        } else if (this.fPreviousConnectors != null) {
            this.fPreviousConnectors.remove(connector);
        }
        this.setWiringDiagramModified();
    }

    public void disconnectAll() {
        if (!this.fMultiConnection) {
            if (this.fPreviousConnector != null) {
                this.fPreviousConnector.disconnect(this);
            }
        } else {
            OutBlockConnectorEnumeration enumeration = this.getLinkedConnectors();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement().disconnect(this);
            }
        }
        this.fPreviousConnector = null;
        this.fPreviousConnectors = null;
    }

    public Block getLinkedBlock() {
        OutBlockConnector linkedConnector = this.getLinkedConnector();
        if (linkedConnector != null) {
            return linkedConnector.getOwner();
        }
        return null;
    }

    public OutBlockConnector getLinkedConnector() {
        if (this.fMultiConnection) {
            if (this.fPreviousConnectors == null || this.fPreviousConnectors.isEmpty()) {
                return null;
            }
            return (OutBlockConnector)this.fPreviousConnectors.get(0);
        }
        return this.fPreviousConnector;
    }

    public int getLinkedConnectorCount() {
        if (this.fMultiConnection) {
            return this.fPreviousConnectors.size();
        }
        if (this.fPreviousConnector == null) {
            return 0;
        }
        return 1;
    }

    public ArrayList getLinkedConnectorsList() {
        if (this.fMultiConnection) {
            return new ArrayList(this.getPreviousConnectorsVar());
        }
        ArrayList<OutBlockConnector> list = new ArrayList<OutBlockConnector>();
        if (this.fPreviousConnector != null) {
            list.add(this.fPreviousConnector);
        }
        return list;
    }

    public OutBlockConnectorEnumeration getLinkedConnectors() {
        this.getPreviousConnectorsVar();
        return new OutBlockConnectorEnumeration(){
            int count = 0;

            public boolean hasMoreElements() {
                if (!InBlockConnector.this.fMultiConnection) {
                    return this.count == 0 && InBlockConnector.this.fPreviousConnector != null;
                }
                return this.count < InBlockConnector.this.fPreviousConnectors.size();
            }

            public OutBlockConnector nextElement() {
                if (!InBlockConnector.this.fMultiConnection) {
                    if (this.count == 0) {
                        ++this.count;
                        return InBlockConnector.this.fPreviousConnector;
                    }
                    throw new NoSuchElementException("InBlockConnector Enumeration");
                }
                if (this.count < InBlockConnector.this.fPreviousConnectors.size()) {
                    return (OutBlockConnector)InBlockConnector.this.fPreviousConnectors.elementAt(this.count++);
                }
                throw new NoSuchElementException("InBlockConnector Enumeration");
            }
        };
    }

    public double calculateAnalogValue() {
        double result = this.fDefaultAnalogValue;
        OutBlockConnector connector = this.getLinkedConnector();
        if (connector != null) {
            result = connector.calculateAnalogValue();
        }
        return result;
    }

    public int getConnectorPosition(BlockConnector connector) {
        return this.getOwner().getInConnectorPosition((InBlockConnector)connector);
    }

    private Vector getPreviousConnectorsVar() {
        if (this.fPreviousConnectors == null) {
            this.fPreviousConnectors = new Vector(4, 2);
        }
        return this.fPreviousConnectors;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean isConnectable() {
        WiringDiagram wiringDiagram = this.getOwner().getWiringDiagram();
        if (wiringDiagram != null && wiringDiagram.getProgrammingLanguage().isInConnectorMultiConnectable()) {
            return true;
        }
        return this.fPreviousConnector == null;
    }

    public boolean isConnected() {
        if (this.fMultiConnection) {
            return this.getPreviousConnectorsVar().size() != 0;
        }
        return this.fPreviousConnector != null;
    }

    public boolean isConnected(OutBlockConnector connector) {
        if (this.fMultiConnection) {
            Enumeration enumeration = this.getPreviousConnectorsVar().elements();
            while (enumeration.hasMoreElements()) {
                OutBlockConnector oldConnector = (OutBlockConnector)enumeration.nextElement();
                if (oldConnector.getOwner() != connector.getOwner() || oldConnector.getOwner().getOutConnectorPosition(oldConnector) != connector.getOwner().getOutConnectorPosition(connector)) continue;
                return true;
            }
            return false;
        }
        if (this.fPreviousConnector == null) {
            return false;
        }
        return this.fPreviousConnector.getOwner() == connector.getOwner() && this.fPreviousConnector.getOwner().getOutConnectorPosition(this.fPreviousConnector) == connector.getOwner().getOutConnectorPosition(connector);
    }

    public void postReadObject() {
        if (this.serializedDataVersion < 2) {
            OutBlockConnectorEnumeration enumeration = this.getLinkedConnectors();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement().connect(this);
            }
            this.serializedDataVersion = 2;
        }
    }

    public int getInputOutputType() {
        return 0;
    }

    public void setNotConnectedCode(short notConnectedCode) {
        this.fNotConnectedCode = notConnectedCode;
    }

    public short getNotConnectedCode() {
        return this.fNotConnectedCode;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.fNotConnectedCode = this.isNegated() ? CHANGED_NOTCONNECTED_CODE : DEFAULT_NOTCONNECTED_CODE;
    }

    public void setNegated(boolean negate) throws UnsupportedOperationException {
        super.setNegated(negate);
        this.setNotConnectedCode(CHANGED_NOTCONNECTED_CODE);
    }
}

