/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.Logo;
import DE.siemens.ad.logo.model.WiringDiagram;

public class ConstantBlock
extends Block {
    static final long serialVersionUID = 6694787466984120702L;
    private int constantBlockSerializedDataVersion = 1;

    public ConstantBlock() {
    }

    public ConstantBlock(WiringDiagram wiringDiagram) {
        super(wiringDiagram);
    }

    protected int getDefaultOrder() {
        return 100;
    }

    public String getNumberString(int blockNumber) {
        String string = blockNumber > 0 ? this.getNumberPrefix() + Integer.toString(blockNumber) : this.getNumberPrefix();
        return string;
    }

    public int getOpcode() throws RuntimeException {
        int opcode = 0;
        try {
            opcode = ((Logo)this.getWiringDiagram().getHardware()).getOpcodeCO(this.getName(), this.getNumber());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(this.getClass() + ">>getOpcode() not implemented");
        }
        return opcode;
    }

    public int getOpcode(Hardware hw, int blockNr) throws IllegalArgumentException {
        return ((Logo)hw).getOpcodeCO(this.getName(), blockNr);
    }

    public String getType() {
        return "Constant";
    }

    public boolean isLeftTerminal() {
        return true;
    }
}

