/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.FrequencyParameter;
import DE.siemens.ad.logo.model.Interpreter;
import java.io.IOException;

public class ComparatorParameter
extends FrequencyParameter {
    static final long serialVersionUID = 0L;
    private int comparatorSerializedDataVersion = 1;
    protected int fCounterValue1;
    protected int fCounterValue2;
    protected int fCounterValueOld1;
    protected int fCounterValueOld2;
    protected boolean fFreOld1;
    protected boolean fFreOld2;

    public ComparatorParameter() {
    }

    public ComparatorParameter(Block block) {
        super(block);
        this.fParameter = 3;
        this.fData = 3;
        this.fAllocatedTimer = 1;
        this.fState = false;
        this.fCounterValueOld1 = 0;
        this.fCounterValueOld2 = 0;
        this.fCounterValue1 = 0;
        this.fCounterValue2 = 0;
    }

    protected boolean calculateValue(boolean fre1, boolean fre2) {
        if (!this.fFreOld1 && fre1 && this.fCounterValue1 < this.fMax) {
            ++this.fCounterValue1;
        }
        if (!this.fFreOld2 && fre2 && this.fCounterValue2 < this.fMax) {
            ++this.fCounterValue2;
        }
        if (this.fTimeInterval.isFinished()) {
            this.fCounterValueOld1 = this.fCounterValue1;
            this.fCounterValue1 = 0;
            this.fCounterValueOld2 = this.fCounterValue2;
            this.fCounterValue2 = 0;
            this.fTimeInterval.start();
        }
        if (Math.abs(this.fCounterValueOld1 - this.fCounterValueOld2) > this.fOnThreshold) {
            this.fState = true;
        }
        if (Math.abs(this.fCounterValueOld1 - this.fCounterValueOld2) <= this.fOffThreshold) {
            this.fState = false;
        }
        this.fFreOld1 = fre1;
        this.fFreOld2 = fre2;
        return this.fState;
    }

    public String calculateCurrentParameterText() {
        String cs1 = Integer.toString(this.fCounterValue1);
        String cs2 = Integer.toString(this.fCounterValue2);
        String n = "0000";
        return n.substring(1, 5 - cs1.length()) + cs1 + "  " + n.substring(1, 5 - cs2.length()) + cs2 + "      " + this.fTimeInterval.getPassedTime().getTimeAsString();
    }

    public String getParameterText() {
        return "ON =" + this.getOnThreshold().getCurrentValue() + this.getProtectionSign() + "\n" + "OFF =" + this.getOffThreshold().getCurrentValue() + "\n" + "G_T=" + this.getTimeInterval().getParamTime().getParameterText();
    }

    public boolean getValue(boolean fre1, boolean fre2) {
        boolean rw = this.calculateValue(fre1, fre2);
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        this.fireParameterUpdateEvent();
        return rw;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        this.fTimeInterval.init(interpreter);
        if (!this.getRemanenceAvailable() || !this.getRemanenceObject().getRemanence() || forceReset) {
            this.fState = false;
            this.fCounterValueOld1 = 0;
            this.fCounterValueOld2 = 0;
            this.fCounterValue1 = 0;
            this.fCounterValue2 = 0;
        }
        this.fTimeInterval.start();
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fCounterValue1 = dr.readInt();
        this.fCounterValueOld1 = dr.readInt();
        this.fCounterValue2 = dr.readInt();
        this.fCounterValueOld2 = dr.readInt();
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fCounterValue1);
        dw.writeInt(this.fCounterValueOld1);
        dw.writeInt(this.fCounterValue2);
        dw.writeInt(this.fCounterValueOld2);
    }
}

