/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.BinaryBlockConnector;
import DE.siemens.ad.logo.model.BinaryOutBlockConnector;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.ProgrammingLanguage;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import java.io.IOException;
import java.util.List;

public class BinaryInBlockConnector
extends InBlockConnector
implements BinaryBlockConnector {
    static final long serialVersionUID = 6071519477492410696L;
    private int serializedDataVersion = 1;
    protected boolean fDefaultValue = false;

    public BinaryInBlockConnector() {
    }

    public BinaryInBlockConnector(Block aggregat, boolean defaultValue) {
        this(aggregat, defaultValue, "");
    }

    public BinaryInBlockConnector(Block aggregat, boolean defaultValue, String name) {
        this.fOwner = aggregat;
        this.fDefaultValue = defaultValue;
        this.fConnectorName = name;
    }

    public boolean calculateBinaryValue() {
        boolean result = false;
        result = this.getLinkedConnectorCount() == 0 ? this.fDefaultValue : ((BinaryOutBlockConnector)this.getLinkedConnector()).calculateBinaryValue();
        return this.isNegated() ? !result : result;
    }

    public boolean getBinaryValue() {
        boolean result = false;
        result = this.getLinkedConnectorCount() == 0 ? this.fDefaultValue : ((BinaryOutBlockConnector)this.getLinkedConnector()).getBinaryValue();
        return this.isNegated() ? !result : result;
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fDefaultValue = dr.readBoolean();
    }

    public void setDefaultValue(boolean value) {
        this.fDefaultValue = value;
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeBoolean(this.fDefaultValue);
    }

    public boolean isNegatable() {
        if (this.getOwner() instanceof OutputBlock) {
            return false;
        }
        try {
            WiringDiagram wiringDiagram = this.getOwner().getWiringDiagram();
            ProgrammingLanguage programmingLanguage = wiringDiagram.getProgrammingLanguage();
            return programmingLanguage.isInConnectorNegatable() && wiringDiagram.getHardware().supports("negatableInputs");
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public int getSignalType() {
        return 0;
    }

    public boolean isAvailable(Hardware hardware, List errorList) {
        boolean availability = super.isAvailable(hardware, errorList);
        if (this.isNegated() && !hardware.supports("negatableInputs")) {
            availability = false;
            errorList.add(new ErrorInfo(this, "error.convert.binaryInBlockConnector.negationNotSupported", hardware));
        }
        return availability;
    }
}

