/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.Time2ProtectionParameter;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;

public class AsymPulseGeneratorParameter
extends Time2ProtectionParameter {
    static final long serialVersionUID = 0L;
    private int asymPulseGeneratorSerializedDataVersion = 2;
    private static final int READY = 0;
    private static final int ACTIVE_1 = 1;
    private static final int ACTIVE_2 = 2;
    private TimeUnit fImpulseLength;
    private TimeUnit fPauseLength;

    public AsymPulseGeneratorParameter() {
    }

    public AsymPulseGeneratorParameter(Block block) {
        super(block);
        this.fParameter = 3;
        this.fData = 1;
        this.fAllocatedTimer = 1;
        this.fState = 0;
        this.setParameterNameKeys();
    }

    public boolean calculateValue(boolean enable, boolean a) {
        boolean result = false;
        if (!enable) {
            this.fState = 0;
            this.getCurrentTimer().reset();
        } else {
            if (this.fState == 0) {
                this.setCurrentTimer(this.getHTimer());
                this.getCurrentTimer().start();
                this.fState = 1;
            }
            if (this.fState == 1) {
                if (this.getCurrentTimer().isFinished()) {
                    this.setCurrentTimer(this.getLTimer());
                    this.getCurrentTimer().start();
                    this.fState = 2;
                } else {
                    boolean bl = result = !a;
                }
            }
            if (this.fState == 2) {
                if (this.getCurrentTimer().isFinished()) {
                    this.setCurrentTimer(this.getHTimer());
                    this.getCurrentTimer().start();
                    this.fState = 1;
                    result = !a;
                } else {
                    result = a;
                }
            }
        }
        return result;
    }

    public final boolean isTimeUnitDifferent() {
        return this.getHTimer().getParamTime().getUnitAbbreviation() != this.getLTimer().getParamTime().getUnitAbbreviation();
    }

    public boolean isAvailable(Hardware hw, List errorList) {
        boolean result = super.isAvailable(hw, errorList);
        if (this.isTimeUnitDifferent() && !hw.supports("asymPulseWithDifferentTimeUnits")) {
            errorList.add(new ErrorInfo(this.getBlock(), "error.convert.differentTimeUnits", hw));
            result &= false;
        }
        return result;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.asymPulseGeneratorSerializedDataVersion == 1) {
            this.setParameterNameKeys();
            this.asymPulseGeneratorSerializedDataVersion = 2;
            this.fHTimer.setParamTime(this.fImpulseLength);
            this.fLTimer.setParamTime(this.fPauseLength);
        }
    }

    protected void setParameterNameKeys() {
        this.getHTimer().setNameKey("dialog.parameter.asymPulseGenerator.impulseLength");
        this.getLTimer().setNameKey("dialog.parameter.asymPulseGenerator.impulsePause");
    }

    public String calculateCurrentParameterText() {
        StringBuffer result = new StringBuffer(super.calculateCurrentParameterText());
        return result.toString();
    }
}

