/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Analog;
import DE.siemens.ad.logo.model.AnalogOrBlockReference;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.IntegerOrBlockReference;
import DE.siemens.ad.logo.util.AnalogValueProperties;
import DE.siemens.ad.logo.util.Util;
import java.io.IOException;

public class AnalogMuxParameter
extends Analog {
    static final long serialVersionUID = 0L;
    private int blockParameterSerializedDataVersion = 1;
    private static final int MIN_VALUE = Short.MIN_VALUE;
    private static final int MAX_VALUE = Short.MAX_VALUE;
    private AnalogOrBlockReference fP1;
    private AnalogOrBlockReference fP2;
    private AnalogOrBlockReference fP3;
    private AnalogOrBlockReference fP4;

    public AnalogMuxParameter() {
    }

    public AnalogMuxParameter(Block block) {
        super(block);
    }

    public double calculateAnalogValue(boolean en, boolean s1, boolean s2) {
        this.fAmplifiedX = en ? (!s1 && !s2 ? this.getP1Properties().getValue(Short.MIN_VALUE, Short.MAX_VALUE) : (!s1 && s2 ? this.getP2Properties().getValue(Short.MIN_VALUE, Short.MAX_VALUE) : (s1 && !s2 ? this.getP3Properties().getValue(Short.MIN_VALUE, Short.MAX_VALUE) : this.getP4Properties().getValue(Short.MIN_VALUE, Short.MAX_VALUE)))) : 0;
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        return this.fAmplifiedX;
    }

    public String getParameterText() {
        StringBuffer buffer = new StringBuffer(super.getParameterText());
        if (buffer.length() > 0) {
            buffer.append("\n");
        }
        buffer.append("V1  =").append(this.getP1Properties().getParameterText()).append(this.getProtectionSign()).append("\nV2=").append(this.getP2Properties().getParameterText()).append("\nV3=").append(this.getP3Properties().getParameterText()).append("\nV4=").append(this.getP4Properties().getParameterText()).append("\nPoint =").append(this.getDecimalPlace());
        return buffer.toString();
    }

    public String calculateCurrentParameterText() {
        String value = Double.toString(this.fAmplifiedX);
        value = Util.addTrailingSpaces(value, 8);
        this.fireParameterUpdateEvent();
        return value;
    }

    public AnalogOrBlockReference getP1Properties() {
        if (this.fP1 == null) {
            this.fP1 = new AnalogOrBlockReference(this);
            AnalogValueProperties analogValueProperties = new AnalogValueProperties(Short.MIN_VALUE, Short.MAX_VALUE, 1, 0, 0, "error.analogMux.p1", "Error input P1");
            analogValueProperties.setSuppressLeadingZeroes(true);
            this.fP1.setAnalogValueProperties(analogValueProperties);
        }
        this.fP1.setDecimalPlace(this.getDecimalPlace());
        return this.fP1;
    }

    public AnalogOrBlockReference getP2Properties() {
        if (this.fP2 == null) {
            this.fP2 = new AnalogOrBlockReference(this);
            AnalogValueProperties analogValueProperties = new AnalogValueProperties(Short.MIN_VALUE, Short.MAX_VALUE, 1, 0, 0, "error.analogMux.p2", "Error input P2");
            analogValueProperties.setSuppressLeadingZeroes(true);
            this.fP2.setAnalogValueProperties(analogValueProperties);
        }
        this.fP2.setDecimalPlace(this.getDecimalPlace());
        return this.fP2;
    }

    public AnalogOrBlockReference getP3Properties() {
        if (this.fP3 == null) {
            this.fP3 = new AnalogOrBlockReference(this);
            AnalogValueProperties analogValueProperties = new AnalogValueProperties(Short.MIN_VALUE, Short.MAX_VALUE, 1, 0, 0, "error.analogMux.p3", "Error input P3");
            analogValueProperties.setSuppressLeadingZeroes(true);
            this.fP3.setAnalogValueProperties(analogValueProperties);
        }
        this.fP3.setDecimalPlace(this.getDecimalPlace());
        return this.fP3;
    }

    public AnalogOrBlockReference getP4Properties() {
        if (this.fP4 == null) {
            this.fP4 = new AnalogOrBlockReference(this);
            AnalogValueProperties analogValueProperties = new AnalogValueProperties(Short.MIN_VALUE, Short.MAX_VALUE, 1, 0, 0, "error.analogMux.p4", "Error input P4");
            analogValueProperties.setSuppressLeadingZeroes(true);
            this.fP4.setAnalogValueProperties(analogValueProperties);
        }
        this.fP4.setDecimalPlace(this.getDecimalPlace());
        return this.fP4;
    }

    public void setP1Properties(AnalogOrBlockReference value) {
        this.fP1.setValue(value);
    }

    public void setP2Properties(AnalogOrBlockReference value) {
        this.fP2.setValue(value);
    }

    public void setP3Properties(AnalogOrBlockReference value) {
        this.fP3.setValue(value);
    }

    public void setP4Properties(AnalogOrBlockReference value) {
        this.fP4.setValue(value);
    }

    public void setP1Properties(IntegerOrBlockReference value) {
        this.fP1.setValue(value);
    }

    public void setP2Properties(IntegerOrBlockReference value) {
        this.fP2.setValue(value);
    }

    public void setP3Properties(IntegerOrBlockReference value) {
        this.fP3.setValue(value);
    }

    public void setP4Properties(IntegerOrBlockReference value) {
        this.fP4.setValue(value);
    }

    public int getAmplifiedAq() {
        return this.fAmplifiedX;
    }

    public void setAmplifiedAq(int analogValue) {
        this.fAmplifiedX = analogValue;
    }

    public AnalogValueProperties getAmplifiedXProperties() {
        if (this.fAmplifiedXProperties == null) {
            this.fAmplifiedXProperties = new AnalogValueProperties(MIN_TRIGGER, MAX_TRIGGER, 1, (int)this.fXInput, this.getDecimalPlace(), this.isAnalogValueDecimalPlacesAvailable(), "error.dialog.invalidValue", "Invalid Value");
        }
        this.fAmplifiedXProperties.setCurrentValue(this.fAmplifiedX);
        this.fAmplifiedXProperties.setDecimalPlace(this.getDecimalPlace());
        return this.fAmplifiedXProperties;
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.fP1);
        dw.writeStorable(this.fP2);
        dw.writeStorable(this.fP3);
        dw.writeStorable(this.fP4);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fP1 = (AnalogOrBlockReference)dr.readStorable();
        this.fP2 = (AnalogOrBlockReference)dr.readStorable();
        this.fP3 = (AnalogOrBlockReference)dr.readStorable();
        this.fP4 = (AnalogOrBlockReference)dr.readStorable();
    }
}

