/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.dialog.comp.Measurement;
import DE.siemens.ad.logo.model.AbstractInputSimulationParameter;
import DE.siemens.ad.logo.model.AnalogBlock;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.ParameterSetListener;
import DE.siemens.ad.logo.util.BlockEnumeration;
import DE.siemens.ad.logo.util.DoubleValueProperties;
import java.util.ArrayList;

public class AnalogInputSimulationParameter
extends AbstractInputSimulationParameter
implements ParameterSetListener {
    static final long serialVersionUID = 857941152416620470L;
    private int parameterSerializedDataVersion = 1;

    public AnalogInputSimulationParameter(Block block, double analogValue) {
        super(block);
        this.setExternAnalogValue(analogValue);
        this.setThresholdValue(10.0);
    }

    public void addAsParameterSetListener() {
        BlockEnumeration nextAnalogBlocks = this.getAnalogSuccessorBlocks();
        Object blockParameter = null;
        while (nextAnalogBlocks.hasMoreElements()) {
            AnalogBlock analogBlock = (AnalogBlock)((Object)nextAnalogBlocks.nextBlock());
            analogBlock.addMeasurementBoundsChangedListener(this);
        }
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        this.checkExternalRange();
        this.calculateSensorGainOffset();
    }

    protected double getAutoMaxValue() {
        Measurement.Sensor sensor = this.getSensor();
        if (sensor != null) {
            return sensor.getMaxExternalValue();
        }
        return 1000.0;
    }

    public Measurement.Sensor getSensor() {
        BlockEnumeration nextAnalogBlocks = this.getAnalogSuccessorBlocks();
        ArrayList sensors = new ArrayList();
        while (nextAnalogBlocks.hasMoreElements()) {
            AnalogBlock analogBlock = (AnalogBlock)((Object)nextAnalogBlocks.nextBlock());
            analogBlock.collectSensors(sensors);
        }
        if (sensors.size() >= 1) {
            Measurement.Sensor firstSensor = (Measurement.Sensor)sensors.get(0);
            for (int i = 1; i < sensors.size(); ++i) {
                if (((Measurement.Sensor)sensors.get(i)).equalTo(firstSensor)) continue;
                return null;
            }
            return firstSensor;
        }
        return null;
    }

    public double getInternAnalogValue() {
        if (this.fSensorGain < 0.0) {
            Measurement.Sensor sensor = this.getSensor();
            return (double)sensor.getMaxInternalValue() - this.fInternAnalogValue + (double)sensor.getMinInternalValue();
        }
        return this.fInternAnalogValue;
    }

    protected void calculateSensorGainOffset() {
        double maxExternal = this.getMaxValue();
        double minExternal = this.getMinValue();
        int minInternal = 0;
        int maxInternal = 1000;
        Measurement.Sensor sensor = this.getSensor();
        if (sensor != null) {
            minInternal = sensor.getMinInternalValue();
            maxInternal = sensor.getMaxInternalValue();
            minExternal = sensor.getMinExternalValue();
            if (minExternal > (maxExternal = (double)sensor.getMaxExternalValue())) {
                double help = minExternal;
                minExternal = maxExternal;
                maxExternal = help;
            }
        }
        this.fSensorGain = (double)(maxInternal - minInternal) / (maxExternal - minExternal);
        this.fSensorOffset = ((double)maxInternal * minExternal - (double)minInternal * maxExternal) / (minExternal - maxExternal);
        if (Double.isInfinite(this.fSensorGain)) {
            this.fSensorGain = 0.0;
            this.fSensorOffset = minInternal;
        }
        this.setExternAnalogValue(this.getExternAnalogValue());
    }

    private void checkExternalRange() {
        Measurement.Sensor sensor;
        if (!this.isAutoMeasurementRange() && (sensor = this.getSensor()) != null) {
            int sensorMaxValue = sensor.getMaxAmplifiedValue();
            int sensorMinValue = sensor.getMinAmplifiedValue();
            if (sensorMinValue > sensorMaxValue) {
                int temp = sensorMinValue;
                sensorMinValue = sensorMaxValue;
                sensorMaxValue = temp;
            }
            if (this.fMaxValue > (double)sensorMaxValue || this.fMaxValue < (double)sensorMinValue) {
                this.fMaxValue = sensorMaxValue;
                this.fireParameterSetEvent();
            }
            if (this.fMinValue < (double)sensorMinValue || this.fMinValue > (double)sensorMaxValue) {
                this.fMinValue = sensorMinValue;
                this.fireParameterSetEvent();
            }
        }
    }

    public BlockEnumeration getAnalogSuccessorBlocks() {
        BlockEnumeration nextBlocks = this.getBlock().getOutConnector(0).getLinkedBlocks();
        return nextBlocks;
    }

    public double getAutoMinValue() {
        Measurement.Sensor sensor = this.getSensor();
        if (sensor != null) {
            return sensor.getMinExternalValue();
        }
        return 0.0;
    }

    public int[] getAvailableSwitchModes() {
        return new int[]{4};
    }

    public boolean getBinaryValue() {
        return this.fAnalogousValue >= this.fThresholdValue;
    }

    public DoubleValueProperties getMaxValueProperties() {
        int min = -32767;
        int max = Short.MAX_VALUE;
        Measurement.Sensor sensor = this.getSensor();
        if (sensor != null && (min = sensor.getMinAmplifiedValue()) > (max = sensor.getMaxAmplifiedValue())) {
            int temp = min;
            min = max;
            max = temp;
        }
        return new DoubleValueProperties((double)min, (double)max, 1.0, this.getMaxValue(), "-####0", "error.dialog.invalidValue", "Invalid Value");
    }

    public DoubleValueProperties getMinValueProperties() {
        int min = -32767;
        int max = Short.MAX_VALUE;
        Measurement.Sensor sensor = this.getSensor();
        if (sensor != null && (min = sensor.getMinAmplifiedValue()) > (max = sensor.getMaxAmplifiedValue())) {
            int temp = min;
            min = max;
            max = temp;
        }
        return new DoubleValueProperties((double)min, (double)max, 1.0, this.getMinValue(), "-####0", "error.dialog.invalidValue", "Invalid Value");
    }

    public int getSwitchMode() {
        return 4;
    }

    public void parameterSet(Parameter parameter, String newParameterText) {
        this.checkExternalRange();
        this.calculateSensorGainOffset();
        this.fireParameterSetEvent();
    }

    public void setMaxValue(double newMaxValue) {
        super.setMaxValue(newMaxValue);
        this.checkExternalRange();
        this.calculateSensorGainOffset();
    }

    public void setMinValue(double newMinValue) {
        super.setMinValue(newMinValue);
        this.checkExternalRange();
        this.calculateSensorGainOffset();
    }

    public void removeAsParameterSetListener() {
        BlockEnumeration nextAnalogBlocks = this.getAnalogSuccessorBlocks();
        Object blockParameter = null;
        while (nextAnalogBlocks.hasMoreElements()) {
            AnalogBlock analogBlock = (AnalogBlock)((Object)nextAnalogBlocks.nextBlock());
            analogBlock.addMeasurementBoundsChangedListener(this);
        }
    }
}

