/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Hours;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.Minutes;
import DE.siemens.ad.logo.model.Seconds;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.util.IntValueProperties;
import DE.siemens.ad.logo.util.TimeValueProperties;
import java.io.IOException;
import java.io.Serializable;

public abstract class AbstractTimer
implements Serializable,
Storable {
    static final long serialVersionUID = 0L;
    private int abstractTimerSerializedDataVersion = 1;
    protected transient Interpreter fInterpreter;
    protected int fState;
    protected long fStartTime;
    public static final int WAITING = 0;
    public static final int RUNNING = 1;
    public static final int READY = 2;
    protected TimeUnit fParamTime = TimeUnit.getNewTimeObject("dialog.timeParameter.seconds");
    protected TimeUnit fPassedTime = TimeUnit.getNewTimeObject("dialog.timeParameter.seconds");
    private TimeUnit[] fAvailableTimeUnits;
    private String fTimerNameKey;

    public void finish() {
        this.fState = 2;
    }

    public TimeUnit[] getAvailableTimeUnitObjects() {
        if (this.fAvailableTimeUnits == null) {
            this.fAvailableTimeUnits = new TimeUnit[]{new Hours(), new Minutes(), new Seconds()};
        }
        return this.fAvailableTimeUnits;
    }

    public void setAvailableTimeUnits(TimeUnit[] availableTimeUnits) {
        this.fAvailableTimeUnits = availableTimeUnits;
    }

    protected boolean isTimeUnitSupported(TimeUnit timeUnit) {
        for (int i = 0; i < this.fAvailableTimeUnits.length; ++i) {
            if (this.fAvailableTimeUnits[i].getUnitKey() != timeUnit.getUnitKey()) continue;
            return true;
        }
        return false;
    }

    public IntValueProperties getHighInfo(String unitKey) {
        TimeUnit info = TimeUnit.getNewTimeObject(unitKey);
        return info.getHigh();
    }

    public String getName() {
        return this.fTimerNameKey;
    }

    public IntValueProperties getLowInfo(String unitKey) {
        TimeUnit info = TimeUnit.getNewTimeObject(unitKey);
        return info.getLow();
    }

    public TimeUnit getParamTime() {
        return this.fParamTime;
    }

    public abstract TimeUnit getPassedTime();

    public void read(StorableInput dr) throws IOException {
        this.fParamTime = (TimeUnit)dr.readStorable();
        this.fPassedTime = (TimeUnit)dr.readStorable();
        this.fTimerNameKey = dr.readString();
    }

    public void reset() {
        this.fState = 0;
    }

    public void setNameKey(String nameKey) {
        this.fTimerNameKey = nameKey;
    }

    public void setParamTime(int high, int low, String unitKey) {
        this.fParamTime = TimeUnit.getNewTimeObject(unitKey);
        this.fPassedTime = TimeUnit.getNewTimeObject(unitKey);
        this.fParamTime.setTime(high, low);
    }

    public void setParamTime(TimeUnit paramTime) {
        this.fParamTime = paramTime;
        this.fPassedTime = TimeUnit.getNewTimeObject(paramTime.getUnitKey());
    }

    public void start() {
        this.fStartTime = this.getCurrentTime();
        this.fState = 1;
    }

    public void setParamTimeToDefault() {
        TimeUnit[] availableTimeUnits = this.getAvailableTimeUnitObjects();
        this.setParamTime(TimeUnit.getNewTimeObject(availableTimeUnits[availableTimeUnits.length - 1].getUnitKey()));
    }

    public void write(StorableOutput dw) {
        dw.writeStorable(this.fParamTime);
        dw.writeStorable(this.fPassedTime);
        if (this.fTimerNameKey == null) {
            dw.writeString("");
        } else {
            dw.writeString(this.fTimerNameKey);
        }
    }

    public boolean isTimerConvertibleTo(TimeUnit[] availableTimeUnits) {
        boolean timerCompatible = false;
        for (int i = 0; i < availableTimeUnits.length && !timerCompatible; ++i) {
            if (!this.getParamTime().isNoLossConvertibleTo(availableTimeUnits[i])) continue;
            timerCompatible = true;
        }
        return timerCompatible;
    }

    public void convertTimerTo(TimeUnit[] availableTimeUnits) {
        this.fAvailableTimeUnits = availableTimeUnits;
        boolean converted = false;
        for (int i = 0; i < availableTimeUnits.length && !converted; ++i) {
            if (!this.getParamTime().isNoLossConvertibleTo(availableTimeUnits[i])) continue;
            this.setParamTime(this.getParamTime().convertTo(availableTimeUnits[i]));
            converted = true;
        }
    }

    public TimeValueProperties getParamTimeProperties() {
        TimeValueProperties timeValueProperties = new TimeValueProperties(this.getParamTime(), this.getAvailableTimeUnitObjects());
        return timeValueProperties;
    }

    public void setParamTimeProperties(TimeValueProperties timeValueProperties) {
        this.setParamTime(timeValueProperties.getCurrentValue());
    }

    protected long getCurrentTime() {
        try {
            return this.fInterpreter.getCurrentSimulationTimerTime();
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("Im Timer " + this.getName() + " wurde kein Interpreter f\u00fcr getCurrentTime() gesetzt");
        }
    }

    public void init(Interpreter interpreter) {
        this.fInterpreter = interpreter;
    }
}

