/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.wizard.update;

import DE.siemens.ad.logo.util.Version;
import java.text.ParseException;
import java.util.StringTokenizer;

public class ModuleInfo {
    protected String type;
    protected String name;
    protected String description;
    protected String filename;
    protected int size;
    protected Version validFromVersion;
    protected Version validToVersion;
    protected String destinationDirectory;
    protected String sourceDirectory;
    public String classpath;
    protected String updateID;
    public static final int UPDATE_ID_ALL = -9;

    public ModuleInfo() {
    }

    public ModuleInfo(String line) throws Exception {
        StringTokenizer lineTokenizer = new StringTokenizer(line, "|");
        try {
            this.type = lineTokenizer.nextToken();
            this.name = lineTokenizer.nextToken();
            this.description = lineTokenizer.nextToken();
            this.filename = lineTokenizer.nextToken();
            this.classpath = lineTokenizer.nextToken();
            this.destinationDirectory = lineTokenizer.nextToken();
            this.size = Integer.parseInt(lineTokenizer.nextToken());
            this.validFromVersion = new Version(lineTokenizer.nextToken());
            this.validToVersion = new Version(lineTokenizer.nextToken());
            this.updateID = lineTokenizer.nextToken();
        }
        catch (Exception e) {
            throw new ParseException("Error by parsing catalog.dat.", 0);
        }
    }

    public ModuleInfo(String type, String name, String description, String filename, String classpath, String destinationDirectory, String size, String versionFrom, String versionTo, String updateID) {
        this.type = type;
        this.name = name;
        this.description = description;
        this.filename = filename;
        this.destinationDirectory = destinationDirectory;
        try {
            this.size = Integer.parseInt(size);
        }
        catch (NumberFormatException nfe) {
            this.size = 0;
        }
        this.validFromVersion = new Version(versionFrom);
        this.validToVersion = new Version(versionTo);
        this.updateID = updateID;
    }

    public boolean applicableToVersion(Version version) {
        int id;
        try {
            id = Integer.parseInt(this.updateID.trim());
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (id == -9) {
            return true;
        }
        return id == -1;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ModuleInfo)) {
            return false;
        }
        ModuleInfo compareTo = (ModuleInfo)o;
        return this.type.equals(compareTo.getType()) && this.name.equals(compareTo.getName()) && this.description.equals(compareTo.getDescription()) && this.filename.equals(compareTo.getFilename()) && this.size == compareTo.getSize() && this.validFromVersion.equals(compareTo.getValidFromVersion()) && this.validToVersion.equals(compareTo.getValidToVersion()) && this.classpath.equals(compareTo.getClasspath()) && this.destinationDirectory.equals(compareTo.getDestinationDirectory());
    }

    public String getClasspath() {
        return this.classpath;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDestinationDirectory() {
        return this.destinationDirectory;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getLocalSourceDirectory() {
        return this.sourceDirectory;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    public String getType() {
        return this.type;
    }

    public String getUpdateID() {
        return this.updateID;
    }

    public Version getValidFromVersion() {
        return this.validFromVersion;
    }

    public Version getValidToVersion() {
        return this.validToVersion;
    }

    public void setClasspath(String newClasspath) {
        this.classpath = newClasspath;
    }

    public void setDescription(String newDescription) {
        this.description = newDescription;
    }

    public void setDestinationDirectory(String newDirectory) {
        this.destinationDirectory = newDirectory;
    }

    public void setFilename(String newFilename) {
        this.filename = newFilename;
    }

    public void setLocalSourceDirectory(String newSourceDirectory) {
        this.sourceDirectory = newSourceDirectory;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public void setSize(int newSize) {
        this.size = newSize;
    }

    public void setType(String newType) {
        this.type = newType;
    }

    public void setUpdateID(String newUpdateID) {
        this.updateID = newUpdateID;
    }

    public void setValidFromVersion(Version newValidFromVersion) {
        this.validFromVersion = newValidFromVersion;
    }

    public void setValidFromVersion(String version) {
        this.validFromVersion = new Version(version);
    }

    public void setValidToVersion(Version newValidToVersion) {
        this.validToVersion = newValidToVersion;
    }

    public void setValidToVersion(String newValidToVersion) {
        this.validToVersion = new Version(newValidToVersion);
    }

    public String toString() {
        return this.type + "; " + this.name + "; " + this.validFromVersion + "-" + this.validToVersion;
    }
}

