/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.wizard.update;

import DE.siemens.ad.logo.dialog.wizard.ProgressInfo;
import DE.siemens.ad.logo.dialog.wizard.WizardInputPanel;
import DE.siemens.ad.logo.dialog.wizard.WizardModel;
import DE.siemens.ad.logo.dialog.wizard.WizardPanelModel;
import DE.siemens.ad.logo.dialog.wizard.update.AbstractUpdateScript;
import DE.siemens.ad.logo.dialog.wizard.update.ExtractingFilesPanel;
import DE.siemens.ad.logo.dialog.wizard.update.ModuleInfo;
import DE.siemens.ad.logo.dialog.wizard.update.SelectLanguageModel;
import DE.siemens.ad.logo.dialog.wizard.update.UpdateFinishedModel;
import DE.siemens.ad.logo.dialog.wizard.update.UpdateWizardModel;
import DE.siemens.ad.logo.model.OptionProperties;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoIOException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ExtractingFilesModel
extends WizardPanelModel {
    protected ExtractingFilesPanel extractingFilesPanel = new ExtractingFilesPanel(this);
    protected ProgressInfo progressInfo;
    protected int uncompressedSize;
    public static final String PRE_UPDATE_VETO = "preUpdateVeto";
    public static final String POST_UPDATE_VETO = "postUpdateVeto";
    public static final String CLASSPATH_PROPERTY_NAME = "classpath";
    public static final String LAX_CLASSPATH_PROPERTY_NAME = "lax.class.path";
    public static final String UPDATE_CLASSPATH_ERROR = "Error while updating classpath in the startup ini-file";
    public static final String FILE_TO_MODIFY_NOT_FOUND = "file to modify not found";
    public static final String UPDATE_SCRIPT_CLASS = "UpdateScript";
    public UpdateFinishedModel fUpdateFinishedModel;
    protected SelectLanguageModel fSelectLanguageModel;
    protected static final String LANGUAGE = "language";

    public ExtractingFilesModel(WizardModel wizardModel) {
        super(wizardModel);
        this.nextPanelModel = new UpdateFinishedModel(wizardModel);
    }

    public void extractZipFile(String zipFileName, String destinationPath) throws IOException {
        ZipFile zipFile = new ZipFile(zipFileName);
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        AbstractUpdateScript updateScript = this.getUpdateScript(zipFileName);
        if (updateScript != null && !updateScript.preUpdate()) {
            throw new IOException(PRE_UPDATE_VETO);
        }
        while (e.hasMoreElements()) {
            int readBytes;
            ZipEntry zipEntry = e.nextElement();
            this.progressInfo.inc();
            this.progressInfo.setNote(Language.getString("wizard.update.extractingFilesPanel.extracting", "Extracting") + " " + zipEntry.getName());
            File destinationFile = new File(Global.PATHBASE + "/" + destinationPath + "/" + zipEntry.getName());
            if (zipEntry.getName().toLowerCase().endsWith("moduleinfo.dat") || zipEntry.getName().toLowerCase().endsWith(UPDATE_SCRIPT_CLASS.toLowerCase() + ".class")) continue;
            if (zipEntry.isDirectory()) {
                destinationFile.mkdirs();
                continue;
            }
            if (destinationFile.exists()) {
                System.out.println("ExtractingFilesModel: file " + destinationFile.getPath() + " already exists...");
                destinationFile = new File(destinationFile.getParentFile(), "update_" + destinationFile.getName());
                System.out.println("                      ...extracting to " + destinationFile + " instead. File will be reanamed before exit.");
            }
            BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            FileOutputStream fos = new FileOutputStream(destinationFile);
            byte[] buffer = new byte[8192];
            while ((readBytes = bis.read(buffer)) != -1) {
                fos.write(buffer, 0, readBytes);
            }
            fos.close();
            bis.close();
            destinationFile.setLastModified(zipEntry.getTime());
            ((UpdateWizardModel)this.getWizardModel()).addInstalledFile(destinationFile);
        }
        zipFile.close();
        if (updateScript != null && !updateScript.postUpdate()) {
            throw new IOException(POST_UPDATE_VETO);
        }
    }

    public WizardPanelModel getNextPanelModel() {
        if (this.updatesContainLanguages()) {
            if (this.fSelectLanguageModel == null) {
                this.fSelectLanguageModel = new SelectLanguageModel(this.getWizardModel());
            }
            return this.fSelectLanguageModel;
        }
        if (this.fUpdateFinishedModel == null) {
            this.fUpdateFinishedModel = new UpdateFinishedModel(this.getWizardModel());
        }
        return this.fUpdateFinishedModel;
    }

    public ProgressInfo getProgressInfo() {
        this.progressInfo = new ProgressInfo();
        Enumeration e = ((UpdateWizardModel)this.wizardModel).getSelectedModules().elements();
        this.uncompressedSize = 0;
        int fileCount = 0;
        while (e.hasMoreElements()) {
            ModuleInfo moduleInfo = (ModuleInfo)e.nextElement();
            try {
                ZipFile zipFile = new ZipFile(moduleInfo.getLocalSourceDirectory() + "/" + moduleInfo.getFilename());
                fileCount += zipFile.size();
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    this.uncompressedSize = (int)((long)this.uncompressedSize + entries.nextElement().getSize());
                }
            }
            catch (Exception ex) {
                System.out.println("ExtractingFilesModel.getProgressInfo(): " + ex);
            }
        }
        this.progressInfo.setMin(0);
        this.progressInfo.setMax(fileCount);
        this.progressInfo.setTitle(Language.getString("wizard.update.extractingFilesPanel.extractingFiles", "Extracting Files"));
        return this.progressInfo;
    }

    public AbstractUpdateScript getUpdateScript(String updateFile) {
        AbstractUpdateScript script = null;
        URLClassLoader ucl = null;
        try {
            ucl = new URLClassLoader(new URL[]{new File(updateFile).toURL()});
        }
        catch (MalformedURLException mul) {
            System.out.println("ExtractingFilesModel.getUpdateScript(): no script found.");
            System.out.println(mul);
            return null;
        }
        try {
            Class<?> c = ucl.loadClass(UPDATE_SCRIPT_CLASS);
            script = (AbstractUpdateScript)c.newInstance();
            script.setComponent(this.getWizardInputPanel());
        }
        catch (Exception e) {
            System.out.println("ExtractingFilesModel.getUpdateScript(): no script found.");
            System.out.println(e);
            return null;
        }
        return script;
    }

    public WizardInputPanel getWizardInputPanel() {
        return this.extractingFilesPanel;
    }

    public void modifyClasspath(String filename, String classPathPropertyName, ModuleInfo moduleInfo) throws Exception {
        File startIniFile = new File(Global.PATHBASE + "/" + filename);
        if (!startIniFile.exists()) {
            throw new LogoIOException(FILE_TO_MODIFY_NOT_FOUND, "File " + startIniFile.getPath() + " not found.");
        }
        File modifiedStartIniFile = new File(Global.PATHBASE + "/" + filename + ".upd");
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            br = new BufferedReader(new FileReader(startIniFile));
            bw = new BufferedWriter(new FileWriter(modifiedStartIniFile));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.toLowerCase().startsWith(classPathPropertyName + "=") && !moduleInfo.getClasspath().equals("-")) {
                    bw.write(line.substring(0, classPathPropertyName.length() + 1) + this.replacePathSeparators(moduleInfo.getClasspath()) + File.pathSeparator + line.substring(classPathPropertyName.length() + 1));
                } else {
                    bw.write(line);
                }
                bw.newLine();
            }
            br.close();
            bw.close();
            startIniFile.delete();
            modifiedStartIniFile.renameTo(startIniFile);
        }
        catch (Exception e) {
            throw new IOException(UPDATE_CLASSPATH_ERROR);
        }
        finally {
            br.close();
            bw.close();
        }
    }

    public Object process() throws Exception {
        if (this.updatesContainLanguages()) {
            OptionProperties op = new OptionProperties();
        }
        Vector selectedModules = ((UpdateWizardModel)this.wizardModel).getSelectedModules();
        this.testExtraction(selectedModules);
        boolean extractedFiles = false;
        Enumeration e = selectedModules.elements();
        while (e.hasMoreElements()) {
            ModuleInfo moduleInfo = (ModuleInfo)e.nextElement();
            String zipFile = moduleInfo.getLocalSourceDirectory() + "/" + moduleInfo.getFilename();
            try {
                String laxName;
                this.extractZipFile(zipFile, moduleInfo.getDestinationDirectory());
                if (moduleInfo.getClasspath() == null || moduleInfo.getClasspath().equals("") || moduleInfo.getClasspath().equals("-")) continue;
                File laxFile = new File("Start.lax");
                if (!laxFile.exists() && !(laxFile = new File(Global.LAX_FILE)).exists() && (laxName = this.findLaxFile()) != null) {
                    laxFile = new File(laxName);
                }
                this.modifyClasspath(laxFile.getName(), LAX_CLASSPATH_PROPERTY_NAME, moduleInfo);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return ex;
            }
        }
        if (!this.updatesContainLanguages()) {
            ((UpdateWizardModel)this.wizardModel).setFinishable(true);
        }
        return Boolean.TRUE;
    }

    private String findLaxFile() {
        File installationDirectory = new File(System.getProperty("user.dir"));
        String[] fileNames = installationDirectory.list();
        for (int i = 0; i < fileNames.length; ++i) {
            if (!fileNames[i].toLowerCase().endsWith(".lax")) continue;
            return fileNames[i];
        }
        return null;
    }

    private String replacePathSeparators(String path) {
        String toReplace = "";
        if (File.pathSeparator.equals(";")) {
            toReplace = ":";
        }
        if (File.pathSeparator.equals(":")) {
            toReplace = ";";
        }
        path = this.replaceString(path, toReplace, File.pathSeparator);
        if (File.separator.equals("/")) {
            toReplace = "\\";
        }
        if (File.separator.equals("\\")) {
            toReplace = "/";
        }
        path = this.replaceString(path, toReplace, File.separator);
        return path;
    }

    private String replaceString(String source, String toReplace, String replaceWith) {
        int index = -1;
        while ((index = source.indexOf(toReplace)) != -1) {
            StringBuffer sb = new StringBuffer(source);
            sb.replace(index, index + toReplace.length(), replaceWith);
            source = sb.toString();
        }
        return source;
    }

    public boolean testExtraction(Vector modules) throws Exception {
        Enumeration moduleEnumeration = modules.elements();
        ModuleInfo moduleInfo = null;
        while (moduleEnumeration.hasMoreElements()) {
            moduleInfo = (ModuleInfo)moduleEnumeration.nextElement();
            String zipFileName = moduleInfo.getLocalSourceDirectory() + "/" + moduleInfo.getFilename();
            File zippedFile = new File(zipFileName);
            ZipFile zipFile = new ZipFile(zippedFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            ZipEntry entry = null;
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                File destinationFile = new File(Global.PATHBASE + "/" + moduleInfo.getDestinationDirectory() + "/" + entry.getName());
                if (entry.getName().toLowerCase().endsWith("moduleinfo.dat") || entry.getName().toLowerCase().endsWith(UPDATE_SCRIPT_CLASS.toLowerCase() + ".class")) continue;
                if (entry.isDirectory() && !destinationFile.exists() && !destinationFile.mkdirs()) {
                    throw new LogoIOException("cant create directory", "An directory to extract the update files to couldn't be created.", destinationFile);
                }
                if (destinationFile.exists() && !destinationFile.canWrite()) {
                    throw new LogoIOException("cantWrite", "You don't have write permissions to one of the update directories.", destinationFile);
                }
                if (!destinationFile.getParentFile().exists()) {
                    destinationFile.getParentFile().mkdirs();
                }
                if (destinationFile.exists()) continue;
                System.out.print("ExtractingFilesModel.test: Trying to creat file " + destinationFile + "...");
                boolean success = destinationFile.createNewFile();
                System.out.println(success);
                if (!success) {
                    throw new LogoIOException("cantWrite", "You don't have write permissions to one of the update directories.", destinationFile);
                }
                System.out.print("                           Deleting file " + destinationFile + "...");
                success = destinationFile.delete();
                System.out.println(success);
            }
            zipFile.close();
        }
        return true;
    }

    public boolean updatesContainLanguages() {
        Enumeration installedUpdates = ((UpdateWizardModel)this.getWizardModel()).getSelectedModules().elements();
        while (installedUpdates.hasMoreElements()) {
            if (!((ModuleInfo)installedUpdates.nextElement()).getType().toLowerCase().equals(LANGUAGE)) continue;
            return true;
        }
        return false;
    }
}

