/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import DE.siemens.ad.logo.dialog.comp.display.AbstractDisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.BarDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DefaultDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RectangleElementsDisplayModel
extends AbstractDisplayModel {
    public boolean copyCells(List cells, Point destination) {
        throw new UnsupportedOperationException();
    }

    public RectangleElementsDisplayModel(Dimension displayDimension) {
        super(displayDimension);
    }

    public Rectangle getElementBounds(Point location) {
        DisplayElement element = this.fDisplayElements[location.x][location.y];
        if (element != null) {
            Rectangle bounds = new Rectangle(location, new Dimension(element.getWidth(), element.getHeight()));
            return bounds;
        }
        for (int x = 0; x < this.fDisplayDimension.width; ++x) {
            for (int y = 0; y < this.fDisplayDimension.height; ++y) {
                Rectangle bounds;
                element = this.fDisplayElements[x][y];
                if (element == null || !(bounds = new Rectangle(new Point(x, y), new Dimension(element.getWidth(), element.getHeight()))).contains(location)) continue;
                return bounds;
            }
        }
        return new Rectangle(location.x, location.y, 1, 1);
    }

    public boolean insertElement(DisplayElement element, Point position) {
        int elementWidth = 1;
        int elementHeight = 1;
        if (element != null) {
            elementWidth = element.getWidth();
            elementHeight = element.getHeight();
        }
        if (!this.canInsert(element, position)) {
            return false;
        }
        if (!this.canMoveCellRight(new Rectangle(position.x, position.y, elementWidth, elementHeight))) {
            return false;
        }
        int px = position.x;
        int py = position.y;
        for (int y = 0; y < element.getHeight(); ++y) {
            this.moveCellsRight(new Point(px, py), elementWidth);
            ++py;
        }
        this.fDisplayElements[position.x][position.y] = element;
        this.fireModelChangedEvent();
        return true;
    }

    public boolean deleteElement(Point location) {
        Rectangle deletedElementBounds = this.getElementBounds(location);
        int width = deletedElementBounds.width;
        int px = location.x;
        int py = location.y;
        for (int y = 0; y < deletedElementBounds.height; ++y) {
            this.moveCellsLeft(new Point(px, py), width);
            ++py;
        }
        this.fireModelChangedEvent();
        return true;
    }

    public boolean moveCells(List cells, Point destination) {
        ArrayList<DisplayElement> elements = new ArrayList<DisplayElement>(cells.size());
        ArrayList cellsCopy = new ArrayList(cells);
        Iterator cellsIterator = cellsCopy.iterator();
        Point upperLeftCorner = new Point(this.fDisplayDimension.width, this.fDisplayDimension.height);
        while (cellsIterator.hasNext()) {
            Point cell = (Point)cellsIterator.next();
            if (!this.getElementBounds(cell).getLocation().equals(cell)) {
                cells.remove(cell);
                continue;
            }
            elements.add(this.getElementAt(cell));
            if (cell.y > upperLeftCorner.y || cell.x >= upperLeftCorner.x) continue;
            upperLeftCorner = cell;
        }
        Dimension translationVector = new Dimension(destination.x - upperLeftCorner.x, destination.y - upperLeftCorner.y);
        Rectangle displayRectangle = new Rectangle(0, 0, this.fDisplayDimension.width, this.fDisplayDimension.height);
        for (Point cell : cells) {
            Rectangle elementBounds = this.getElementBounds(cell);
            elementBounds.translate(translationVector.width, translationVector.height);
            if (displayRectangle.contains(elementBounds)) continue;
            return false;
        }
        Rectangle former = this.getSelectedRectangle(cells);
        if (!this.canMoveCellLeft(former)) {
            return false;
        }
        this.deleteCells(cells);
        Rectangle current = new Rectangle(former.getLocation().x + translationVector.width, former.getLocation().y + translationVector.height, former.width, former.height);
        if (!this.canMoveCellRight(current)) {
            for (int height = former.height - 1; height >= 0; --height) {
                this.moveCellsRight(new Point(former.getLocation().x, former.getLocation().y + height), former.width);
            }
            cellsIterator = cells.iterator();
            Iterator elementsIterator = elements.iterator();
            while (cellsIterator.hasNext()) {
                this.setElementAt((DisplayElement)elementsIterator.next(), (Point)cellsIterator.next());
            }
            return false;
        }
        for (int height = current.height - 1; height >= 0; --height) {
            this.moveCellsRight(new Point(current.getLocation().x, current.getLocation().y + height), current.width);
        }
        cellsIterator = cells.iterator();
        Iterator elementsIterator = elements.iterator();
        while (cellsIterator.hasNext()) {
            Point cell = (Point)cellsIterator.next();
            DisplayElement element = (DisplayElement)elementsIterator.next();
            Point destinationPoint = new Point(cell);
            destinationPoint.translate(translationVector.width, translationVector.height);
            this.setElementAt(element, destinationPoint);
        }
        return true;
    }

    protected boolean canMoveCellLeft(Rectangle selectArea) {
        Rectangle dimension = new Rectangle(selectArea.getLocation().x, selectArea.getLocation().y, this.fDisplayDimension.width - selectArea.getLocation().x, selectArea.height);
        for (int height = selectArea.height - 1; height >= 0; --height) {
            for (int location = selectArea.getLocation().x; location < this.fDisplayDimension.width - 1; ++location) {
                if (null == this.getElementAt(new Point(location, selectArea.getLocation().y + height)) || dimension.contains(this.getElementBounds(new Point(location, selectArea.getLocation().y + height)))) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean canMoveCellRight(Rectangle selectArea) {
        Rectangle dimension = new Rectangle(selectArea.getLocation().x, selectArea.getLocation().y, this.fDisplayDimension.width - selectArea.getLocation().x, selectArea.height);
        for (int height = selectArea.height - 1; height >= 0; --height) {
            for (int location = selectArea.getLocation().x; location < this.fDisplayDimension.width - selectArea.width; ++location) {
                if (null == this.getElementAt(new Point(location, selectArea.getLocation().y + height)) || dimension.contains(this.getElementBounds(new Point(location, selectArea.getLocation().y + height)))) continue;
                return false;
            }
            for (int width = selectArea.width - 1; width >= 0; --width) {
                DisplayElement element = this.getElementAt(new Point(this.fDisplayDimension.width - 1 - width, selectArea.getLocation().y + height));
                if (null == element || element.toString().trim().equals("")) continue;
                return false;
            }
        }
        return true;
    }

    protected Rectangle getMaxRectangle(Rectangle currentRectangle) {
        Point location = currentRectangle.getLocation();
        int xMin = location.x;
        int yMin = location.y;
        int xMax = location.x + currentRectangle.width - 1;
        int yMax = location.y + currentRectangle.height - 1;
        for (int height = currentRectangle.height - 1; height >= 0; --height) {
            for (int width = currentRectangle.width - 1; width >= 0; --width) {
                Point currentPoint = new Point(location.x + width, location.y + height);
                if (null == currentPoint) continue;
                Rectangle cellBounds = this.getElementBounds(currentPoint);
                if (cellBounds.x + cellBounds.width > xMax) {
                    xMax = cellBounds.x + cellBounds.width - 1;
                }
                if (cellBounds.x < xMin) {
                    xMin = cellBounds.x;
                }
                if (cellBounds.y + cellBounds.height > yMax) {
                    yMax = cellBounds.y + cellBounds.height - 1;
                }
                if (cellBounds.y >= yMin) continue;
                yMin = cellBounds.y;
            }
        }
        if (currentRectangle.equals(new Rectangle(xMin, yMin, xMax - xMin + 1, yMax - yMin + 1))) {
            return currentRectangle;
        }
        return this.getMaxRectangle(new Rectangle(xMin, yMin, xMax - xMin + 1, yMax - yMin + 1));
    }

    public Rectangle getSelectedRectangle(List selectedCells) {
        Iterator cells = selectedCells.iterator();
        int xMin = this.fDisplayDimension.width;
        int yMin = this.fDisplayDimension.width;
        int xMax = 0;
        int yMax = 0;
        while (cells.hasNext()) {
            Point currentPoint = (Point)cells.next();
            if (null == currentPoint) continue;
            Rectangle cellBounds = this.getElementBounds(currentPoint);
            if (cellBounds.x + cellBounds.width > xMax) {
                xMax = cellBounds.x + cellBounds.width - 1;
            }
            if (cellBounds.x < xMin) {
                xMin = cellBounds.x;
            }
            if (cellBounds.y + cellBounds.height > yMax) {
                yMax = cellBounds.y + cellBounds.height - 1;
            }
            if (cellBounds.y >= yMin) continue;
            yMin = cellBounds.y;
        }
        return this.getMaxRectangle(new Rectangle(xMin, yMin, xMax - xMin + 1, yMax - yMin + 1));
    }

    public boolean canChangeProperty(Point focusPosition, DisplayElement former, DisplayElement current) {
        BarDisplayElement formerElement = (BarDisplayElement)former;
        BarDisplayElement currentElement = (BarDisplayElement)current;
        int deltaHeight = currentElement.getHeight() - formerElement.getHeight();
        int deltaWidth = currentElement.getWidth() - formerElement.getWidth();
        if (null == formerElement.getParameterItem()) {
            if (!this.canMoveCellRight(new Rectangle(focusPosition.x, focusPosition.y, currentElement.getWidth(), currentElement.getHeight()))) {
                return false;
            }
        } else {
            if (deltaHeight > 0 && !this.canMoveCellRight(new Rectangle(focusPosition.x, focusPosition.y + formerElement.getHeight(), currentElement.getWidth(), deltaHeight))) {
                return false;
            }
            if (deltaHeight < 0 && !this.canMoveCellLeft(new Rectangle(focusPosition.x + formerElement.getWidth(), focusPosition.y + currentElement.getHeight(), formerElement.getWidth(), Math.abs(deltaHeight)))) {
                return false;
            }
            if (deltaWidth < 0 && !this.canMoveCellLeft(new Rectangle(focusPosition.x + formerElement.getWidth(), focusPosition.y, Math.abs(deltaWidth), formerElement.getHeight()))) {
                return false;
            }
            if (deltaWidth > 0 && !this.canMoveCellRight(new Rectangle(focusPosition.x + formerElement.getWidth(), focusPosition.y, deltaWidth, currentElement.getHeight()))) {
                return false;
            }
        }
        return true;
    }

    public boolean deleteCells(List cells) {
        if (!this.canMoveCellLeft(this.getSelectedRectangle(cells))) {
            return false;
        }
        DefaultDisplayElement deletedMarker = new DefaultDisplayElement("deleted", 1, 1);
        for (Point cell : cells) {
            Rectangle cellBounds = this.getElementBounds(cell);
            for (int x = 0; x < cellBounds.width; ++x) {
                for (int y = 0; y < cellBounds.height; ++y) {
                    this.setElementAt(deletedMarker, new Point(cell.x + x, cell.y + y));
                }
            }
        }
        for (int y = 0; y < this.fDisplayDimension.height; ++y) {
            for (int x = 0; x < this.fDisplayDimension.width; ++x) {
                Point cell = new Point(x, y);
                if (this.getElementAt(cell) != deletedMarker) continue;
                this.deleteElement(cell);
                --x;
            }
        }
        return true;
    }

    public boolean canInsert(DisplayElement displayElement, Point destination) {
        if (displayElement == null || destination == null) {
            return false;
        }
        if (!new Rectangle(new Point(0, 0), this.fDisplayDimension).contains(destination)) {
            return false;
        }
        return destination.x + displayElement.getWidth() <= this.fDisplayDimension.width;
    }
}

