/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import DE.siemens.ad.logo.dialog.comp.display.DefaultDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayCellEditor;
import DE.siemens.ad.logo.dialog.comp.display.LogoDisplay;
import DE.siemens.ad.logo.util.MessageGlobalInfo;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;

public class OneCharacterCellEditor
extends AbstractCellEditor
implements DisplayCellEditor {
    private Object fValue;
    private JLabel fLabel = new JLabel();
    protected LogoDisplay fLogoDisplay;
    protected int fCharSet = 1;

    public OneCharacterCellEditor() {
        this.fLabel.setFocusable(false);
        this.fLabel.addKeyListener(new KeyHandler());
    }

    public Component getDisplayCellEditorComponent(LogoDisplay logoDisplay, Object value, boolean isSelected, int row, int column) {
        this.fLogoDisplay = logoDisplay;
        this.fValue = value;
        return this.fLabel;
    }

    public Object getCellEditorValue() {
        if (this.fValue == null) {
            return null;
        }
        if (this.fValue.toString().length() == 0) {
            this.fValue = " ";
            System.out.println("getCellEditorValue: string len = 0");
        } else {
            this.checkSJISSupports();
        }
        return new DefaultDisplayElement(this.fValue, this.getCellWidth(this.fValue.toString().charAt(0)), 1);
    }

    protected void checkSJISSupports() {
        int startCode = 33438;
        int endCode = 33686;
        if (MessageGlobalInfo.getCharSetName(this.fCharSet).equals("SJIS")) {
            try {
                byte[] bytes = this.fValue.toString().getBytes(MessageGlobalInfo.getCharSetName(this.fCharSet));
                int charCode = bytes[0] > 0 ? bytes[0] : bytes[0] + 256;
                charCode <<= 8;
                if ((charCode += bytes[1] > 0 ? bytes[1] : bytes[1] + 256) < 33438 || charCode > 33686) {
                    this.fValue = "?";
                }
            }
            catch (Exception e) {
                this.fValue = "?";
            }
        }
    }

    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    public void setCharSet(int charSet) {
        this.fCharSet = charSet;
    }

    protected int getCellWidth(char ch) {
        if (MessageGlobalInfo.isBiWidthCharSet(this.fCharSet) && ch > '\u007f') {
            return 2;
        }
        return 1;
    }

    protected class KeyHandler
    extends KeyAdapter {
        protected KeyHandler() {
        }

        public void keyTyped(KeyEvent e) {
            super.keyTyped(e);
            char c = e.getKeyChar();
            if (c < ' ') {
                return;
            }
            OneCharacterCellEditor.this.fValue = Character.toString(e.getKeyChar());
            OneCharacterCellEditor.this.stopCellEditing();
            OneCharacterCellEditor.this.fLogoDisplay.moveFocus(1, 0, false, false);
        }
    }
}

