/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import DE.siemens.ad.logo.dialog.comp.display.AbstractDisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.DefaultDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MultiLinesDisplayModel
extends AbstractDisplayModel {
    public MultiLinesDisplayModel(Dimension displayDimension) {
        super(displayDimension);
    }

    public boolean deleteElement(Point location) {
        Point deletedElementLocation = new Point(location.x, location.y);
        Rectangle deletedElementBounds = this.getElementBounds(deletedElementLocation);
        this.moveCellsLeft(deletedElementBounds.getLocation(), deletedElementBounds.width);
        this.fireModelChangedEvent();
        return true;
    }

    public Rectangle getElementBounds(Point location) {
        DisplayElement element = this.fDisplayElements[location.x][location.y];
        if (element != null) {
            if (element.getHeight() != 1) {
                System.err.println("bad element, height != 1.");
            }
            Rectangle bounds = new Rectangle(location, new Dimension(element.getWidth(), 1));
            return bounds;
        }
        for (int x = location.x - 1; x >= 0; --x) {
            element = this.fDisplayElements[x][location.y];
            if (element == null) continue;
            Rectangle bounds = new Rectangle(new Point(x, location.y), new Dimension(element.getWidth(), 1));
            if (!bounds.contains(location)) break;
            return bounds;
        }
        return new Rectangle(location.x, location.y, 1, 1);
    }

    public boolean insertElement(DisplayElement element, Point position) {
        if (!this.canInsert(element, position)) {
            return false;
        }
        Point insertStart = this.getElementBounds(position).getLocation();
        int elementWidth = 1;
        if (element != null) {
            elementWidth = element.getWidth();
        }
        this.moveCellsRight(insertStart, elementWidth);
        this.fDisplayElements[position.x][position.y] = element;
        this.fireModelChangedEvent();
        return true;
    }

    public boolean setElementAt(DisplayElement element, Point position) {
        if (element != null && element.getHeight() != 1) {
            return false;
        }
        return super.setElementAt(element, position);
    }

    protected List getCellsElements(List cells) {
        ArrayList<DisplayElement> elements = new ArrayList<DisplayElement>(cells.size());
        for (Point cell : cells) {
            elements.add(this.getElementAt(cell));
        }
        return elements;
    }

    protected boolean isValidArea(List cells, int xOffset, int yOffset) {
        Rectangle displayRectangle = new Rectangle(0, 0, this.fDisplayDimension.width, this.fDisplayDimension.height);
        for (Point cell : cells) {
            Rectangle elementBounds = this.getElementBounds(cell);
            elementBounds.translate(xOffset, yOffset);
            if (displayRectangle.contains(elementBounds)) continue;
            return false;
        }
        return true;
    }

    protected boolean insertCopiedElements(List elements, List cells, Dimension translationVector) {
        Iterator cellsIterator = cells.iterator();
        Iterator elementsIterator = elements.iterator();
        while (cellsIterator.hasNext()) {
            Point cell = (Point)cellsIterator.next();
            DisplayElement element = (DisplayElement)elementsIterator.next();
            Point destinationPoint = new Point(cell);
            destinationPoint.translate(translationVector.width, translationVector.height);
            this.insertElement(element, destinationPoint);
        }
        return true;
    }

    public boolean copyCells(List cells, Point destination) {
        Point upperLeftCorner = this.getUpperLeftCorner(cells);
        Dimension translationVector = new Dimension(destination.x - upperLeftCorner.x, destination.y - upperLeftCorner.y);
        if (!this.isValidArea(cells, translationVector.width, translationVector.height)) {
            return false;
        }
        List elements = this.getCellsElements(cells);
        return this.insertCopiedElements(elements, cells, translationVector);
    }

    public boolean moveCells(List cells, Point destination) {
        Point upperLeftCorner = this.getUpperLeftCorner(cells);
        Dimension translationVector = new Dimension(destination.x - upperLeftCorner.x, destination.y - upperLeftCorner.y);
        if (!this.isValidArea(cells, translationVector.width, translationVector.height)) {
            return false;
        }
        List elements = this.getCellsElements(cells);
        this.deleteCells(cells);
        return this.insertCopiedElements(elements, cells, translationVector);
    }

    public boolean deleteCells(List cells) {
        DefaultDisplayElement deletedMarker = new DefaultDisplayElement("deleted", 1, 1);
        for (Point cell : cells) {
            Rectangle cellBounds = this.getElementBounds(cell);
            for (int x = 0; x < cellBounds.width; ++x) {
                for (int y = 0; y < cellBounds.height; ++y) {
                    this.setElementAt(deletedMarker, new Point(cell.x + x, cell.y + y));
                }
            }
        }
        for (int y = 0; y < this.fDisplayDimension.height; ++y) {
            for (int x = 0; x < this.fDisplayDimension.width; ++x) {
                Point cell = new Point(x, y);
                if (this.getElementAt(cell) != deletedMarker) continue;
                this.deleteElement(cell);
                --x;
            }
        }
        return true;
    }

    public boolean canInsert(DisplayElement displayElement, Point destination) {
        if (displayElement == null || destination == null) {
            return false;
        }
        if (displayElement.getHeight() != 1) {
            return false;
        }
        if (!new Rectangle(new Point(0, 0), this.fDisplayDimension).contains(destination)) {
            return false;
        }
        return destination.x + displayElement.getWidth() <= this.fDisplayDimension.width;
    }
}

