/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import DE.siemens.ad.logo.dialog.comp.display.LogoDisplay;
import DE.siemens.ad.logo.dialog.comp.display.ParameterItemDisplayCellEditor;
import DE.siemens.ad.logo.model.Mode;
import DE.siemens.ad.logo.model.ModeFriday;
import DE.siemens.ad.logo.model.ModeMonday;
import DE.siemens.ad.logo.model.ModeSaturday;
import DE.siemens.ad.logo.model.ModeSunday;
import DE.siemens.ad.logo.model.ModeThursday;
import DE.siemens.ad.logo.model.ModeTuesday;
import DE.siemens.ad.logo.model.ModeUniversal;
import DE.siemens.ad.logo.model.ModeWednesday;
import DE.siemens.ad.logo.model.ParameterItem;
import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class ModeCellEditor
extends ParameterItemDisplayCellEditor {
    protected static final Mode[] fDayModes = new Mode[]{new ModeMonday(), new ModeTuesday(), new ModeWednesday(), new ModeThursday(), new ModeFriday(), new ModeSaturday(), new ModeSunday()};
    protected JCheckBox[] fCheckBoxes;
    protected JPanel fEditorComponent = new JPanel();
    private Mode fMode;

    public ModeCellEditor() {
        this.fEditorComponent.setLayout(new BoxLayout(this.fEditorComponent, 0));
        this.fEditorComponent.setFocusCycleRoot(true);
        this.fCheckBoxes = new JCheckBox[fDayModes.length];
        for (int i = 0; i < fDayModes.length; ++i) {
            this.fCheckBoxes[i] = new JCheckBox(fDayModes[i].getAbbreviation().substring(0, 1));
            this.fCheckBoxes[i].setVerticalTextPosition(1);
            this.fCheckBoxes[i].setHorizontalTextPosition(0);
            this.fCheckBoxes[i].setIconTextGap(0);
            this.fCheckBoxes[i].setToolTipText(fDayModes[i].toString());
            this.fEditorComponent.add(this.fCheckBoxes[i]);
        }
    }

    public Component getDisplayCellEditorComponent(LogoDisplay logoDisplay, Object displayElement, boolean isSelected, int row, int column) {
        Object parameterItemValue;
        super.getDisplayCellEditorComponent(logoDisplay, logoDisplay, isSelected, row, column);
        if (this.fParameterItem != null && (parameterItemValue = ((ParameterItem)displayElement).getValue()) instanceof Mode) {
            this.fMode = (Mode)parameterItemValue;
            int logoMode = this.fMode.getLogoMode();
            for (int i = 0; i < 7; ++i) {
                if (!this.fMode.contains(fDayModes[i].getDays()[0])) continue;
                this.fCheckBoxes[i].setSelected(true);
            }
        }
        return this.fEditorComponent;
    }

    public Object getCellEditorValue() {
        int logoMode = 0;
        for (int i = 0; i < fDayModes.length; ++i) {
            if (!this.fCheckBoxes[i].isSelected()) continue;
            logoMode |= fDayModes[i].getLogoMode();
        }
        ModeUniversal modeUniversal = new ModeUniversal();
        modeUniversal.setLogoMode(logoMode);
        this.fParameterItem.setValue(modeUniversal);
        this.fParameterItem.getParameter().fireParameterSetEvent();
        return this.fParameterItem;
    }
}

