/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.dialog.comp.display.AIDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.AbstractDisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.BarDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DefaultDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.IONameDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.MessageDisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.MessageDisplayModelHandle;
import DE.siemens.ad.logo.dialog.comp.display.MutiCharSetDisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.RectangleElementsDisplayModel;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.MessageParameter;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.panel.MessageEditorPanel;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.MessageGlobalInfo;
import DE.siemens.ad.logo.util.MessageLineRTF;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Hashtable;

public class MessageParameterDisplayModelRTF
extends RectangleElementsDisplayModel
implements MutiCharSetDisplayModel,
MessageDisplayModel {
    protected int fCharSetID;
    protected MessageDisplayModelHandleRTF fMessageHandle;
    protected MessageParameter fMessageParameter;
    private static final String UNKNOWN_ELEMENT = "UnknownDisplayElementType";
    private transient String errInsertString;

    public MessageParameterDisplayModelRTF(MessageParameter messageParameter, int charSetID) {
        super(new Dimension(0, 0));
        this.fMessageParameter = messageParameter;
        this.fCharSetID = charSetID;
        this.fMessageHandle = new MessageDisplayModelHandleRTF(this);
        this.fMessageHandle.setMessageParameter(messageParameter);
    }

    public MessageParameterDisplayModelRTF(MessageParameter messageParameter, int charSetID, int nullObject) {
        super(new Dimension(0, 0));
        this.fMessageParameter = messageParameter;
        this.fCharSetID = charSetID;
        this.fMessageHandle = new MessageDisplayModelHandleRTF(this);
        this.fMessageHandle.setDisplayDimension(messageParameter);
    }

    public boolean canInsert(DisplayElement displayElement, Point destination) {
        if (this.fMessageParameter != null && displayElement != null && !(displayElement instanceof DefaultDisplayElement) && this.getParameterItemCount(displayElement) >= this.getMaxItemCount(displayElement)) {
            this.errInsertString = "ExccedMaxCountError." + this.getDisplayElementTypeString(displayElement);
            return false;
        }
        this.errInsertString = null;
        return super.canInsert(displayElement, destination);
    }

    public String getErrorInsertString() {
        if (this.errInsertString != null) {
            String elementType = this.errInsertString.substring(this.errInsertString.indexOf(46));
            if (elementType.endsWith("RTFMaxMessageParameterItem")) {
                return "dialog.parameter.message.countInTextErrParam";
            }
            if (elementType.endsWith("RTFMaxDataTimeItem")) {
                return "dialog.parameter.message.countInTextErrDateTime";
            }
            if (elementType.endsWith("RTFMaxBarGraphItem")) {
                return "dialog.parameter.message.countInTextErrBar";
            }
            if (elementType.endsWith("RTFMaxAIFilterItem")) {
                return "dialog.parameter.message.countInTextErrAI";
            }
            if (elementType.endsWith("RTFMaxIOStatusItem")) {
                return "dialog.parameter.message.countInTextErrIO";
            }
            return "Unkown reason";
        }
        return null;
    }

    private int getMaxItemCount(DisplayElement displayElement) {
        int ret = 0;
        Hardware hardware = this.fMessageParameter.getBlock().getHardware();
        if (hardware != null) {
            String elementType = this.getDisplayElementTypeString(displayElement);
            ret = elementType.equals(UNKNOWN_ELEMENT) ? 0 : hardware.getIntProperty(elementType);
        }
        return ret;
    }

    private String getDisplayElementTypeString(DisplayElement displayElement) {
        String ret = null;
        ret = displayElement instanceof ParameterItem ? (this.isBlockParameter(displayElement) ? "RTFMaxMessageParameterItem" : "RTFMaxDataTimeItem") : (displayElement instanceof BarDisplayElement ? "RTFMaxBarGraphItem" : (displayElement instanceof AIDisplayElement ? "RTFMaxAIFilterItem" : (displayElement instanceof IONameDisplayElement ? "RTFMaxIOStatusItem" : UNKNOWN_ELEMENT)));
        return ret;
    }

    private int getParameterItemCount(DisplayElement newDisplayElement) {
        int ret = 0;
        DisplayElement disp = null;
        for (int y = 0; y < this.fDisplayDimension.height; ++y) {
            for (int x = 0; x < this.fDisplayDimension.width; ++x) {
                disp = this.fDisplayElements[x][y];
                if (!this.getDisplayElementTypeString(disp).equals(this.getDisplayElementTypeString(newDisplayElement))) continue;
                ++ret;
            }
        }
        return ret;
    }

    private boolean isBlockParameter(DisplayElement element) {
        return element instanceof ParameterItem && !(((ParameterItem)element).getParameter() instanceof MessageParameter);
    }

    public MessageParameter getMessageParameter() {
        return this.fMessageParameter;
    }

    private void verifyVerticalBars() {
        DisplayElement displayElement = null;
        for (int y = 0; y < this.fDisplayDimension.height; ++y) {
            for (int x = 0; x < this.fDisplayDimension.width; ++x) {
                displayElement = this.fDisplayElements[x][y];
                if (!(displayElement instanceof BarDisplayElement) || ((BarDisplayElement)displayElement).getDirection() != 1) continue;
                this.verifyVerticalBar(x, y, (BarDisplayElement)displayElement);
            }
        }
    }

    private void verifyVerticalBar(int xPos, int yPos, BarDisplayElement bar) {
        for (int x = 0; x < 2; ++x) {
            for (int y = 1; y < bar.getLength(); ++y) {
                if (this.fDisplayElements[xPos + x][yPos + y] == null) continue;
                this.fDisplayElements[xPos + x][yPos + y] = null;
            }
        }
    }

    public int getCharSetID() {
        return this.fCharSetID;
    }

    public int getCharSet() {
        MessageGlobalInfo msgGlobalInfo = this.fMessageParameter.getBlock().getWiringDiagram().getMessageGlobalInfo();
        return msgGlobalInfo.getSelectedCharSet(this.fCharSetID);
    }

    public boolean isBiWidthCharacterset() {
        return MessageGlobalInfo.isBiWidthCharSet(this.getCharSet());
    }

    public void setCharSet(int charSet) {
        throw new UnsupportedOperationException();
    }

    public void setDisplayElemets(DisplayElement[][] displayElements) {
        for (int i = 0; i < this.fDisplayDimension.width; ++i) {
            for (int j = 0; j < this.fDisplayDimension.height; ++j) {
                this.fDisplayElements[i][j] = displayElements[i][j];
            }
        }
    }

    public boolean canDelete(Rectangle selectedRectangle) {
        if (!this.canMoveCellLeft(selectedRectangle)) {
            this.showManualEditPanel();
            return false;
        }
        return true;
    }

    public boolean canInsert(Rectangle insertingRectangle) {
        if (!this.canMoveCellRight(insertingRectangle)) {
            this.showManualEditPanel();
            return false;
        }
        return true;
    }

    private void showManualEditPanel() {
        LogoError dialog = new LogoError(null, "dialog.logdisplay.conflictOccure", "Conflict detected.\nDo you want to enter the manual editing model?", 1, 1);
        if (dialog.display() == 0) {
            MessageEditorPanel editorPanel = new MessageEditorPanel(this);
            SplittedDlg panel = SplittedDlg.create(Application.getInstance().getActiveApplicationSurface().getWindow(), editorPanel, 3);
            panel.show();
            if (panel.getControlPanel().getResult() == 1) {
                this.fireModelChangedEvent();
            }
        }
    }

    public void addAsParameterUpdateListener() {
        this.fMessageHandle.addAsParameterUpdateListener();
    }

    public void removeAsParameterUpdateListener() {
        this.fMessageHandle.removeAsParameterUpdateListener();
    }

    public void addAsParameterSetListener(MessageParameter msgParam) {
        this.fMessageHandle.addAsParameterSetListener(msgParam);
    }

    public void removeAsParameterSetListener(MessageParameter msgParam) {
        this.fMessageHandle.removeAsParameterSetListener(msgParam);
    }

    public Hashtable getSpecialCharactersTable() {
        return this.fMessageHandle.getSpecialCharactersTable();
    }

    private void fillModelWithDefaultDispElement(int charSetID) {
    }

    public static class MessageDisplayModelHandleRTF
    extends MessageDisplayModelHandle {
        public MessageDisplayModelHandleRTF(AbstractDisplayModel model) {
            super(model);
        }

        private MessageParameterDisplayModelRTF getDisplayModelRTF() {
            if (this.fDisplayModel instanceof MessageParameterDisplayModelRTF) {
                return (MessageParameterDisplayModelRTF)this.fDisplayModel;
            }
            return null;
        }

        public void setMessageParameter(MessageParameter messageParameter) {
            this.setDisplayDimension(messageParameter);
            if (messageParameter.getMessageRTF(this.getDisplayModelRTF().fCharSetID) != null) {
                MessageLineRTF[] messageLines = messageParameter.getMessageRTF(this.getDisplayModelRTF().fCharSetID).getMessageLineRTF();
                DisplayElement displayElement = null;
                for (int y = 0; y < messageLines.length; ++y) {
                    int x = 0;
                    while (x < this.getDisplayModelRTF().fDisplayDimension.width) {
                        displayElement = messageLines[y].getDisplayElement(x);
                        this.getDisplayModelRTF().setElementAt(displayElement, new Point(x, y));
                        if (displayElement != null) {
                            x += displayElement.getWidth();
                            continue;
                        }
                        ++x;
                    }
                }
                this.getDisplayModelRTF().verifyVerticalBars();
            }
        }

        private void setDisplayDimension(MessageParameter messageParameter) {
            Hardware hardware = messageParameter.getBlock().getWiringDiagram().getHardware();
            int columns = 0;
            columns = ((MessageParameterDisplayModelRTF)this.fDisplayModel).isBiWidthCharacterset() ? hardware.getIntProperty("displayWidthForAsiaCharacter") : hardware.getIntProperty("displayWidthForAscii");
            this.fDisplayModel.setDisplayDimension(new Dimension(columns, 4));
        }
    }
}

