/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import DE.siemens.ad.logo.dialog.comp.display.AbstractDisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.DefaultDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.MessageDisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.MessageDisplayModelHandle;
import DE.siemens.ad.logo.dialog.comp.display.MultiLinesDisplayModel;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.MessageParameter;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ParameterItemTableLogo3;
import DE.siemens.ad.logo.util.MessageLine;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Hashtable;

public class MessageParameterDisplayModelPlain
extends MultiLinesDisplayModel
implements MessageDisplayModel {
    protected boolean fTextParameterMixAllowed;
    protected MessageDisplayModelHandlePlain fMessageHandle = new MessageDisplayModelHandlePlain(this);

    public MessageParameterDisplayModelPlain(MessageParameter messageParameter) {
        super(new Dimension(0, 0));
        this.fMessageHandle.setMessageParameter(messageParameter);
        this.fTextParameterMixAllowed = messageParameter.getBlock().getWiringDiagram().getHardware().supports("mixedMessageTextAndParameter");
    }

    public boolean insertElement(DisplayElement element, Point position) {
        if (element != null && position.x + element.getWidth() > this.fDisplayDimension.width) {
            return false;
        }
        if (!(element instanceof ParameterItem) && this.getElementAt(new Point(this.fDisplayDimension.width - 1, position.y)) instanceof ParameterItem) {
            return false;
        }
        if (element instanceof ParameterItem) {
            if (this.isLineContainsParameterItem(position.y)) {
                return false;
            }
            if (!this.fTextParameterMixAllowed) {
                position.x = 0;
                for (int i = 1; i < this.fDisplayDimension.width; ++i) {
                    this.fDisplayElements[i][position.y] = null;
                }
            }
        }
        return super.insertElement(element, position);
    }

    public boolean canInsert(DisplayElement element, Point position) {
        if (!super.canInsert(element, position)) {
            return false;
        }
        boolean parameterItemContained = this.isLineContainsParameterItem(position.y);
        if (!this.fTextParameterMixAllowed && parameterItemContained) {
            return false;
        }
        return !parameterItemContained || !(element instanceof ParameterItem);
    }

    private boolean isLineContainsParameterItem(int lineNr) {
        boolean parameterItemContained = false;
        for (int spalte = 0; spalte < this.fDisplayDimension.width && !parameterItemContained; ++spalte) {
            if (!(this.fDisplayElements[spalte][lineNr] instanceof ParameterItem)) continue;
            parameterItemContained = true;
        }
        return parameterItemContained;
    }

    public void addAsParameterUpdateListener() {
        this.fMessageHandle.addAsParameterUpdateListener();
    }

    public void removeAsParameterUpdateListener() {
        this.fMessageHandle.removeAsParameterUpdateListener();
    }

    public void addAsParameterSetListener(MessageParameter msgParam) {
        this.fMessageHandle.addAsParameterSetListener(msgParam);
    }

    public void removeAsParameterSetListener(MessageParameter msgParam) {
        this.fMessageHandle.removeAsParameterSetListener(msgParam);
    }

    public Hashtable getSpecialCharactersTable() {
        return this.fMessageHandle.getSpecialCharactersTable();
    }

    public String getErrorInsertString() {
        return null;
    }

    private static class MessageDisplayModelHandlePlain
    extends MessageDisplayModelHandle {
        public MessageDisplayModelHandlePlain(AbstractDisplayModel model) {
            super(model);
        }

        public void setMessageParameter(MessageParameter messageParameter) {
            int columns = messageParameter.getBlock().getWiringDiagram().getHardware().getIntProperty("displayWidth");
            this.fDisplayModel.setDisplayDimension(new Dimension(columns, 4));
            ParameterItemTableLogo3 exportedParameters = null;
            try {
                exportedParameters = new ParameterItemTableLogo3();
            }
            catch (Exception e) {
                System.out.println(e);
                return;
            }
            MessageLine[] messageLines = messageParameter.getMessage();
            for (int y = 0; y < messageLines.length; ++y) {
                String text = messageLines[y].getText();
                BlockParameter blockParameter = messageLines[y].getBlockParameter();
                String parameterIdentifier = blockParameter != null ? messageLines[y].getParameterItemIdentifier() : null;
                int parameterPosition = blockParameter != null ? messageLines[y].getParameterPosition() : -1;
                int textIndex = 0;
                DisplayElement displayElement = null;
                for (int x = 0; x < this.getDisplayDimension().width; x += displayElement.getWidth()) {
                    if (x == parameterPosition) {
                        ParameterItem parameterItem = blockParameter.getParameterItem(parameterIdentifier);
                        displayElement = parameterItem.getInstanceForParameter(blockParameter);
                    } else if (x != parameterPosition && textIndex < text.length()) {
                        char currentCharacter = text.charAt(textIndex);
                        displayElement = currentCharacter >= ' ' && currentCharacter <= '\u007f' ? new DefaultDisplayElement(Character.toString(currentCharacter), 1, 1) : MessageLine.getSpecialCharacterDisplayElement(currentCharacter);
                        ++textIndex;
                    } else {
                        displayElement = new DefaultDisplayElement(" ", 1, 1);
                    }
                    this.fDisplayModel.setElementAt(displayElement, new Point(x, y));
                }
            }
        }
    }
}

