/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import DE.siemens.ad.logo.dialog.comp.display.AIDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.AbstractDisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.BarDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayModelEvent;
import DE.siemens.ad.logo.dialog.comp.display.IONameDisplayElement;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.MessageParameter;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ParameterSetListener;
import DE.siemens.ad.logo.model.ParameterUpdateEvent;
import DE.siemens.ad.logo.model.ParameterUpdateListener;
import DE.siemens.ad.logo.model.block.InputBlock;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Hashtable;

public abstract class MessageDisplayModelHandle
implements ParameterSetListener,
ParameterUpdateListener {
    protected AbstractDisplayModel fDisplayModel;

    public MessageDisplayModelHandle(AbstractDisplayModel model) {
        this.fDisplayModel = model;
    }

    public Hashtable getSpecialCharactersTable() {
        return MessageParameter.getSpecialCharactersTable();
    }

    protected Dimension getDisplayDimension() {
        return this.fDisplayModel.getDisplayDimension();
    }

    public abstract void setMessageParameter(MessageParameter var1);

    public void parameterUpdated(ParameterUpdateEvent pue) {
        Point position = null;
        ParameterItem parameterItem = null;
        DisplayElement disp = null;
        for (int x = 0; x < this.getDisplayDimension().width; ++x) {
            for (int y = 0; y < this.getDisplayDimension().height; ++y) {
                DisplayModelEvent displayModelEvent;
                disp = this.fDisplayModel.getElementAt(new Point(x, y));
                if (disp instanceof ParameterItem && ((ParameterItem)disp).getParameter() == pue.getSource()) {
                    position = new Point(x, y);
                    parameterItem = (ParameterItem)disp;
                    displayModelEvent = null;
                    displayModelEvent = parameterItem != null ? new DisplayModelEvent(this, new Rectangle(position, new Dimension(parameterItem.getWidth(), parameterItem.getHeight())), 0) : new DisplayModelEvent(this);
                    this.fDisplayModel.fireModelChangedEvent(displayModelEvent);
                    continue;
                }
                if (!(disp instanceof BarDisplayElement) || ((BarDisplayElement)disp).getParameterItem().getParameter() != pue.getSource()) continue;
                displayModelEvent = new DisplayModelEvent(this);
                this.fDisplayModel.fireModelChangedEvent(displayModelEvent);
            }
        }
    }

    public void parameterSet(Parameter parameter, String newParameterText) {
        if (parameter instanceof MessageParameter) {
            this.setMessageParameter((MessageParameter)parameter);
        }
        this.fDisplayModel.fireModelChangedEvent();
    }

    public void addAsParameterUpdateListener() {
        DisplayElement disp = null;
        for (int x = 0; x < this.getDisplayDimension().width; ++x) {
            for (int y = 0; y < this.getDisplayDimension().height; ++y) {
                Parameter paramSim;
                disp = this.fDisplayModel.getElementAt(new Point(x, y));
                BlockParameter param = this.getBlockParameter(disp);
                if (param != null) {
                    param.addParameterUpdateListener(this);
                }
                if ((paramSim = this.getIOSimulationParameter(disp)) == null) continue;
                paramSim.addParameterSetListener(this);
            }
        }
    }

    public void removeAsParameterUpdateListener() {
        DisplayElement disp = null;
        for (int x = 0; x < this.getDisplayDimension().width; ++x) {
            for (int y = 0; y < this.getDisplayDimension().height; ++y) {
                Parameter paramSim;
                disp = this.fDisplayModel.getElementAt(new Point(x, y));
                BlockParameter param = this.getBlockParameter(disp);
                if (param != null) {
                    param.removeParameterUpdateListener(this);
                }
                if ((paramSim = this.getIOSimulationParameter(disp)) == null) continue;
                paramSim.removeParameterSetListener(this);
            }
        }
    }

    public void addAsParameterSetListener(MessageParameter msgParam) {
        msgParam.addParameterSetListener(this);
    }

    public void removeAsParameterSetListener(MessageParameter msgParam) {
        msgParam.removeParameterSetListener(this);
    }

    private BlockParameter getBlockParameter(DisplayElement disp) {
        if (disp instanceof ParameterItem) {
            return ((ParameterItem)disp).getParameter();
        }
        if (disp instanceof BarDisplayElement) {
            return ((BarDisplayElement)disp).getParameterItem().getParameter();
        }
        return null;
    }

    private Parameter getIOSimulationParameter(DisplayElement disp) {
        if (disp instanceof IONameDisplayElement) {
            if (((IONameDisplayElement)disp).getBlock() instanceof InputBlock) {
                return ((IONameDisplayElement)disp).getBlock().getSimulationParameter();
            }
            return ((IONameDisplayElement)disp).getBlock().getParameter();
        }
        if (disp instanceof AIDisplayElement) {
            return ((AIDisplayElement)disp).getBlock().getSimulationParameter();
        }
        return null;
    }
}

