/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.dialog.comp.display.BarDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.BarDisplaySettingPanel;
import DE.siemens.ad.logo.dialog.comp.display.DefaultDisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.DefaultDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DefaultDisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.DisplayCellEditor;
import DE.siemens.ad.logo.dialog.comp.display.DisplayCellEditorAllocator;
import DE.siemens.ad.logo.dialog.comp.display.DisplayCellEditorListener;
import DE.siemens.ad.logo.dialog.comp.display.DisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayFocusEvent;
import DE.siemens.ad.logo.dialog.comp.display.DisplayFocusListener;
import DE.siemens.ad.logo.dialog.comp.display.DisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.DisplayModelEvent;
import DE.siemens.ad.logo.dialog.comp.display.DisplayModelListener;
import DE.siemens.ad.logo.dialog.comp.display.DisplaySelectionEvent;
import DE.siemens.ad.logo.dialog.comp.display.DisplaySelectionListener;
import DE.siemens.ad.logo.dialog.comp.display.DisplayToolTipProvider;
import DE.siemens.ad.logo.dialog.comp.display.ExtenalMoveModel;
import DE.siemens.ad.logo.dialog.comp.display.IONameDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.IONameSettingPanel;
import DE.siemens.ad.logo.dialog.comp.display.MessageParameterDisplayModelRTF;
import DE.siemens.ad.logo.dialog.comp.display.MutiCharSetDisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.OneCharacterCellEditor;
import DE.siemens.ad.logo.dialog.comp.display.SpecialCharacterDisplayElement;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.panel.MessageEditorPanel;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.LogoError;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;

public class LogoDisplay
extends JComponent
implements CellEditorListener,
DisplayModelListener {
    protected DisplayCellEditor fCurrentCellEditor;
    protected Component fCurrentEditorComp;
    protected CellEditorRemover fEditorRemover;
    protected Point fEditingPosition;
    private Point fStartSelection = null;
    private Point fEndSelection = null;
    protected DisplayCellEditorAllocator fDisplayCellEditorAllocator;
    protected boolean fDynamicCellDimensionEnabled = true;
    protected Point fFocusPosition = new Point(0, 0);
    protected Dimension fCellDimension = new Dimension(0, 0);
    public static final String CELLS_MIME_TYPE = "application/x-java-logo-display-cells";
    protected DisplayElement fDefaultInsertElement = new DefaultDisplayElement("", 1, 1);
    protected Dimension fDisplayDimension = new Dimension(1, 1);
    protected Dimension fInterCellSpacing = new Dimension(1, 1);
    protected DisplayCellRenderer fCellRenderer = new DefaultDisplayCellRenderer();
    public Rectangle fDropRectangle = null;
    protected Map fRendererMap;
    protected boolean fInsertMode = false;
    protected DisplayCellEditor fDefaultCellEditor = null;
    protected CellRendererPane fCellRendererPane;
    protected DisplayModel fModel;
    protected boolean fDragEnabled;
    protected DisplayToolTipProvider fToolTipProvider;
    private EventListenerList fEventListeners = new EventListenerList();
    private Color fSimulationColor = Global.LOGO_DISPLAY_COLOR;
    boolean fSimulationMode = false;

    private boolean isBiWidthCharacterset() {
        if (this.fModel instanceof MutiCharSetDisplayModel) {
            return ((MutiCharSetDisplayModel)((Object)this.fModel)).isBiWidthCharacterset();
        }
        return false;
    }

    public void moveFocusTo(Point cell, boolean extendSelection) {
        this.setFocusPosition(new Point(cell));
        if (extendSelection) {
            this.setEndSelection(new Point(cell));
        } else if (!this.fInsertMode) {
            this.setStartSelection(new Point(this.fFocusPosition));
            this.setEndSelection(new Point(this.fFocusPosition));
        } else {
            this.setStartSelection(new Point(this.fFocusPosition));
            this.setEndSelection(null);
        }
        this.repaint();
    }

    public LogoDisplay() {
        this.fModel = new DefaultDisplayModel(new Dimension(14, 6));
        this.setLayout(null);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setRequestFocusEnabled(true);
        this.setFocusable(true);
        this.setBackground(Color.black);
        this.setSize(this.getPreferredSize());
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        DefaultDisplayCellRenderer cellRenderer = new DefaultDisplayCellRenderer();
        cellRenderer.setDefaultBackground(Color.red);
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        KeyHandler keyHandler = new KeyHandler();
        this.addKeyListener(keyHandler);
        FocusHandler focusHandler = new FocusHandler();
        this.addFocusListener(focusHandler);
        this.createActionMap();
    }

    public LogoDisplay(DisplayModel displayModel) {
        this();
        this.fModel = displayModel;
    }

    protected void createActionMap() {
        this.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "cancelEdit");
        this.getActionMap().put("cancelEdito", new CancelEditAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(37, 0), "cursorLeft");
        this.getActionMap().put("cursorLeft", new NavigationalAction(-1, 0, false, false));
        this.getInputMap().put(KeyStroke.getKeyStroke(39, 0), "cursorRight");
        this.getActionMap().put("cursorRight", new NavigationalAction(1, 0, false, false));
        this.getInputMap().put(KeyStroke.getKeyStroke(38, 0), "cursorUp");
        this.getActionMap().put("cursorUp", new NavigationalAction(0, -1, false, false));
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "cursorDown");
        this.getActionMap().put("cursorDown", new NavigationalAction(0, 1, false, false));
        this.getInputMap().put(KeyStroke.getKeyStroke(37, 64), "cursorLeftSelect");
        this.getActionMap().put("cursorLeftSelect", new NavigationalAction(-1, 0, true, false));
        this.getInputMap().put(KeyStroke.getKeyStroke(39, 64), "cursorRightSelect");
        this.getActionMap().put("cursorRightSelect", new NavigationalAction(1, 0, true, false));
        this.getInputMap().put(KeyStroke.getKeyStroke(38, 64), "cursorUpSelect");
        this.getActionMap().put("cursorUpSelect", new NavigationalAction(0, -1, true, false));
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 64), "cursorDownSelect");
        this.getActionMap().put("cursorDownSelect", new NavigationalAction(0, 1, true, false));
        this.getInputMap().put(KeyStroke.getKeyStroke(9, 1), "tabLeft");
        this.getActionMap().put("tabLeft", new NavigationalAction(-1, 0, false, false));
        this.getInputMap().put(KeyStroke.getKeyStroke(9, 0), "tabRight");
        this.getActionMap().put("tabRight", new NavigationalAction(1, 0, false, false));
        this.getInputMap().put(KeyStroke.getKeyStroke(8, 0), "backspace");
        this.getActionMap().put("backspace", new NavigationalAction(-1, 0, false, true));
        this.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.getActionMap().put("delete", new NavigationalAction(0, 0, false, true));
        this.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "escape");
        this.getActionMap().put("escape", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (LogoDisplay.this.isEditing()) {
                    LogoDisplay.this.fCurrentCellEditor.cancelCellEditing();
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(65, 2), "selectAll");
        this.getActionMap().put("selectAll", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (LogoDisplay.this.isEditing()) {
                    LogoDisplay.this.fCurrentCellEditor.cancelCellEditing();
                }
                LogoDisplay.this.selectAll();
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(155, 0), "insert");
        this.getActionMap().put("insert", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Point selectedCell;
                LogoDisplay.this.setInsertMode(!LogoDisplay.this.isInsertMode());
                Point point = selectedCell = LogoDisplay.this.fInsertMode ? new Point(LogoDisplay.this.fFocusPosition) : null;
                if (LogoDisplay.this.getStartSelection() == null || LogoDisplay.this.getStartSelection() != null && LogoDisplay.this.getStartSelection().equals(LogoDisplay.this.getEndSelection())) {
                    LogoDisplay.this.setStartSelection(selectedCell);
                    LogoDisplay.this.setEndSelection(selectedCell);
                }
                LogoDisplay.this.repaint();
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(36, 0), "home");
        this.getActionMap().put("home", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Point homePosition = new Point(0, LogoDisplay.this.getFocusPosition().y);
                LogoDisplay.this.moveFocusTo(homePosition, false);
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(35, 0), "end");
        this.getActionMap().put("end", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Point homePosition = new Point(LogoDisplay.this.getDisplayDimension().width - 1, LogoDisplay.this.getFocusPosition().y);
                LogoDisplay.this.moveFocusTo(homePosition, false);
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "enter");
        this.getActionMap().put("enter", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Point enterPosition = new Point(0, Math.min(LogoDisplay.this.getDisplayDimension().height - 1, LogoDisplay.this.getFocusPosition().y + 1));
                LogoDisplay.this.moveFocusTo(enterPosition, false);
            }
        });
    }

    public Dimension getCellDimension() {
        if (this.fDynamicCellDimensionEnabled) {
            Dimension size = new Dimension(this.getSize());
            size.width /= this.getModel().getDisplayDimension().width;
            size.height /= this.getModel().getDisplayDimension().height;
            size.width -= this.fInterCellSpacing.width;
            size.height -= this.fInterCellSpacing.height;
            return size;
        }
        return this.getDefaultCellDimesion();
    }

    protected Dimension getDefaultCellDimesion() {
        if (this.fSimulationMode) {
            return this.getSimulationCellDimension();
        }
        return this.getEditCellDimension();
    }

    protected Dimension getEditCellDimension() {
        int cell_height = 32;
        this.fCellDimension.width = this.fModel instanceof MutiCharSetDisplayModel && this.isBiWidthCharacterset() ? 11 : 15;
        this.fCellDimension.height = 31;
        return this.fCellDimension;
    }

    protected Dimension getSimulationCellDimension() {
        int cell_height = 40;
        this.fCellDimension.width = this.fModel instanceof MutiCharSetDisplayModel && this.isBiWidthCharacterset() ? 14 : 19;
        this.fCellDimension.height = 39;
        return this.fCellDimension;
    }

    protected Rectangle getCellBounds(Point location) {
        Rectangle columnRowBounds = this.fModel.getElementBounds(location);
        if (columnRowBounds == null) {
            return this.getDefaultCellBounds(location, 0, 0);
        }
        Rectangle ret = new Rectangle(columnRowBounds.x * (this.getCellDimension().width + this.fInterCellSpacing.width), columnRowBounds.y * (this.getCellDimension().height + this.fInterCellSpacing.height), columnRowBounds.width * this.getCellDimension().width + (columnRowBounds.width - 1) * this.fInterCellSpacing.width, columnRowBounds.height * this.getCellDimension().height + (columnRowBounds.height - 1) * this.fInterCellSpacing.height);
        return ret;
    }

    private Rectangle getDefaultCellBounds(Point location, int width, int height) {
        return new Rectangle(location.x * (this.getCellDimension().width + this.fInterCellSpacing.width), location.y * (this.getCellDimension().height + this.fInterCellSpacing.height), width * this.getCellDimension().width, height * this.getCellDimension().height);
    }

    private void setCellDimension(Dimension cellDimension) {
        this.fCellDimension = cellDimension;
        this.repaint();
    }

    public DisplayCellRenderer getDisplayCellRenderer(Point location) {
        DisplayElement displayElement = this.fModel.getElementAt(location);
        DisplayCellRenderer renderer = null;
        if (this.fRendererMap != null && displayElement != null) {
            renderer = (DisplayCellRenderer)this.fRendererMap.get(displayElement.getClass());
        }
        if (renderer == null) {
            renderer = this.fCellRenderer;
        }
        return renderer;
    }

    public DisplayCellEditor getDisplayCellEditor(Point location) {
        DisplayElement displayElement = this.fModel.getElementAt(location);
        DisplayCellEditor editor = null;
        if (this.getDisplayCellEditorAllocator() != null && displayElement != null) {
            editor = this.getDisplayCellEditorAllocator().getDisplayCellEditor(displayElement);
        }
        if (editor == null && !(displayElement instanceof SpecialCharacterDisplayElement) && (displayElement == null || displayElement instanceof DefaultDisplayElement) && (editor = this.fDefaultCellEditor) instanceof OneCharacterCellEditor && this.fModel instanceof MutiCharSetDisplayModel) {
            ((OneCharacterCellEditor)editor).setCharSet(((MutiCharSetDisplayModel)((Object)this.fModel)).getCharSet());
        }
        return editor;
    }

    public void setDefaultCellEditor(DisplayCellEditor displayCellEditor) {
        this.fDefaultCellEditor = displayCellEditor;
    }

    public void setCellRenderer(DisplayCellRenderer displayCellRenderer) {
        this.fCellRenderer = displayCellRenderer;
    }

    public void setCellRenderer(Class elementClass, DisplayCellRenderer displayCellRenderer) {
        this.getRendererMap().put(elementClass, displayCellRenderer);
    }

    protected Map getRendererMap() {
        if (this.fRendererMap == null) {
            this.fRendererMap = new Hashtable(5);
        }
        return this.fRendererMap;
    }

    public Dimension getPreferredSize() {
        Dimension ret = new Dimension((this.getDefaultCellDimesion().width + this.fInterCellSpacing.width) * this.fDisplayDimension.width, (this.getDefaultCellDimesion().height + this.fInterCellSpacing.height) * this.fDisplayDimension.height);
        if (this.fSimulationMode) {
            // empty if block
        }
        return ret;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Component prepareEditor(DisplayCellEditor editor, int row, int column) {
        boolean isSelected;
        DisplayElement value = this.fModel.getElementAt(new Point(column, row));
        Component comp = editor.getDisplayCellEditorComponent(this, value, isSelected = false, row, column);
        if (comp instanceof JComponent) {
            JComponent jComp = (JComponent)comp;
            if (jComp.getNextFocusableComponent() == null) {
                jComp.setNextFocusableComponent(this);
            }
            jComp.registerKeyboardAction(new CancelEditAction(), KeyStroke.getKeyStroke(27, 0), 1);
            jComp.registerKeyboardAction(new StopEditAction(), KeyStroke.getKeyStroke(10, 0), 1);
        }
        return comp;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintBarOrNot(g, false);
        this.paintBarOrNot(g, true);
    }

    public boolean setSimulationColor(Color newColor) {
        if (newColor != null && this.fSimulationColor != newColor) {
            this.fSimulationColor = newColor;
            return true;
        }
        return false;
    }

    public Color getSimulationColor() {
        return this.fSimulationColor;
    }

    private void paintBarOrNot(Graphics g, boolean paintBar) {
        Rectangle visibleRect = g.getClipBounds();
        Point upperLeftCell = this.convertPointToCell(visibleRect.getLocation());
        Point lowerRightCell = this.convertPointToCell(new Point(visibleRect.x + visibleRect.width, visibleRect.y + visibleRect.height));
        lowerRightCell.x = Math.min(lowerRightCell.x, this.fModel.getDisplayDimension().width - 1);
        lowerRightCell.y = Math.min(lowerRightCell.y, this.fModel.getDisplayDimension().height - 1);
        for (int y = upperLeftCell.y; y <= lowerRightCell.y; ++y) {
            int x = upperLeftCell.x;
            while (x < this.fModel.getDisplayDimension().width) {
                Point currentCell = new Point(x, y);
                Rectangle cellBounds = this.fModel.getElementBounds(currentCell);
                if (cellBounds.contains(currentCell)) {
                    Rectangle cellArea = this.fModel.getElementBounds(currentCell);
                    boolean hasFocus = cellArea.contains(this.fFocusPosition);
                    DisplayElement value = this.fModel.getElementAt(currentCell);
                    if (paintBar) {
                        if (!(value instanceof BarDisplayElement) || cellBounds.y != currentCell.y) {
                            ++x;
                            continue;
                        }
                    } else if (value instanceof BarDisplayElement && cellBounds.y == currentCell.y) {
                        ++x;
                        continue;
                    }
                    DisplayCellRenderer cellRender = null;
                    Rectangle cellDisplayBounds = null;
                    if (cellBounds.y != currentCell.y) {
                        value = null;
                        cellRender = this.fCellRenderer;
                        cellDisplayBounds = this.getDefaultCellBounds(currentCell, 1, 1);
                    } else {
                        cellRender = this.getDisplayCellRenderer(currentCell);
                        cellDisplayBounds = this.getCellBounds(currentCell);
                    }
                    if (this.fSimulationMode && cellRender instanceof DefaultDisplayCellRenderer) {
                        ((DefaultDisplayCellRenderer)cellRender).setDefaultBackground(this.fSimulationColor);
                    }
                    Component cellRendererComponent = cellRender.getDisplayCellRendererComponent(this, value, this.isCellSelected(currentCell), hasFocus, cellBounds.y, cellBounds.x);
                    this.getCellRendererPane().paintComponent(g, cellRendererComponent, this, cellDisplayBounds.x, cellDisplayBounds.y, cellDisplayBounds.width, cellDisplayBounds.height, true);
                }
                if (cellBounds.width > 0 && cellBounds.y == currentCell.y) {
                    x = cellBounds.x + cellBounds.width;
                    continue;
                }
                ++x;
            }
        }
        if (this.fDropRectangle != null) {
            g.setColor(Color.black);
            Rectangle r = new Rectangle(this.convertCellToPoint(this.fDropRectangle.getLocation()), this.convertCellDimensionToDisplayDimension(this.fDropRectangle.getSize()));
            g.drawRect(r.x, r.y, r.width - this.fInterCellSpacing.width - 1, r.height - this.fInterCellSpacing.height - 1);
            g.drawRect(r.x + 1, r.y + 1, r.width - this.fInterCellSpacing.width - 3, r.height - this.fInterCellSpacing.height - 3);
        }
    }

    private CellRendererPane getCellRendererPane() {
        if (this.fCellRendererPane == null) {
            this.fCellRendererPane = new CellRendererPane();
            this.add(this.fCellRendererPane);
        }
        return this.fCellRendererPane;
    }

    public boolean isEditing() {
        return this.fCurrentCellEditor != null;
    }

    public DisplayElement getFocusedElement() {
        if (this.fFocusPosition != null) {
            return this.fModel.getElementAt(this.fFocusPosition);
        }
        return null;
    }

    public void deleteCells(List cells) {
        this.getModel().deleteCells(cells);
        this.clearSelection();
    }

    public boolean isCellSelected(Point location) {
        if (this.getStartSelection() == null || this.getEndSelection() == null) {
            return false;
        }
        Rectangle selectedArea = new Rectangle(Math.min(this.getStartSelection().x, this.getEndSelection().x), Math.min(this.getStartSelection().y, this.getEndSelection().y), Math.abs(this.getEndSelection().x - this.getStartSelection().x) + 1, Math.abs(this.getEndSelection().y - this.getStartSelection().y) + 1);
        Rectangle elementArea = this.fModel.getElementBounds(location);
        boolean selected = selectedArea.intersects(elementArea);
        return selected;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean editCellAt(int row, int column, EventObject e) {
        DisplayCellEditor editor;
        if (this.isEditing() && !this.fCurrentCellEditor.stopCellEditing()) {
            return false;
        }
        Point editedCellLocation = new Point(column, row);
        DisplayElement disp = this.fModel.getElementAt(editedCellLocation);
        Rectangle editorBount = this.getCellBounds(editedCellLocation);
        if (disp instanceof ParameterItem && this.fSimulationMode) {
            if (column + disp.getWidth() <= 0 || row >= this.fDisplayDimension.width) return false;
            if (this.isBiWidthCharacterset()) {
                editorBount.width = editorBount.width * 4 / 3;
            }
            int minWidth = 122;
            if (editorBount.width < 122) {
                editorBount.width = 122;
            }
            if (editorBount.x < 0) {
                editorBount.x = 0;
            } else if (editorBount.x + editorBount.width > this.getSize().width) {
                editorBount.x = this.getSize().width - editorBount.width - 1;
            }
        } else if (row < 0 || row >= this.fDisplayDimension.height || column < 0 || column >= this.fDisplayDimension.width) {
            return false;
        }
        if (!this.fModel.isCellEditable(editedCellLocation)) {
            return false;
        }
        if (this.fEditorRemover == null) {
            KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.fEditorRemover = new CellEditorRemover(fm);
            fm.addPropertyChangeListener("permanentFocusOwner", this.fEditorRemover);
        }
        if ((editor = this.getDisplayCellEditor(editedCellLocation)) == null || !editor.isCellEditable(e)) return false;
        this.fCurrentEditorComp = this.prepareEditor(editor, row, column);
        if (this.fCurrentEditorComp == null) {
            this.removeEditor();
            return false;
        }
        this.fCurrentEditorComp.setBounds(editorBount);
        this.add(this.fCurrentEditorComp);
        this.fCurrentEditorComp.setVisible(true);
        this.fCurrentEditorComp.requestFocus();
        this.fCurrentEditorComp.validate();
        this.fCurrentEditorComp.repaint();
        this.fCurrentCellEditor = editor;
        this.fEditingPosition = new Point(column, row);
        editor.addCellEditorListener(this);
        this.fireCellEditingStartedEvent();
        return true;
    }

    private Rectangle getEnclosingRectangle(List cells) {
        if (cells == null || cells.isEmpty()) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle enclosingRectangle = null;
        for (Point cell : cells) {
            Rectangle cellBounds = this.fModel.getElementBounds(cell);
            if (enclosingRectangle == null) {
                enclosingRectangle = cellBounds;
                continue;
            }
            enclosingRectangle = enclosingRectangle.union(cellBounds);
        }
        return enclosingRectangle;
    }

    public void removeEditor() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.fEditorRemover);
        this.fEditorRemover = null;
        if (this.fCurrentCellEditor != null) {
            this.fCurrentCellEditor.removeCellEditorListener(this);
            if (this.fCurrentEditorComp != null) {
                this.fCurrentEditorComp.setVisible(false);
                this.requestFocus();
            }
            Rectangle cellRect = this.getCellBounds(this.fEditingPosition);
            this.fCurrentCellEditor = null;
            this.fEditingPosition = null;
            this.fCurrentEditorComp = null;
            this.repaint(cellRect);
            this.validate();
        }
    }

    public void editingCanceled(ChangeEvent e) {
        this.removeEditor();
        this.fireCellEditingCanclledEvent();
    }

    public void editingStopped(ChangeEvent e) {
        DisplayCellEditor editor = this.fCurrentCellEditor;
        if (editor != null) {
            DisplayElement value = (DisplayElement)editor.getCellEditorValue();
            this.fModel.setElementAt(value, this.fEditingPosition);
            this.removeEditor();
        }
        this.fireCellEditingStoppedEvent();
    }

    public Point convertPointToCell(Point pixelLocation) {
        Dimension cellDimension = this.getCellDimension();
        return new Point(pixelLocation.x / (cellDimension.width + this.fInterCellSpacing.width), pixelLocation.y / (cellDimension.height + this.fInterCellSpacing.height));
    }

    protected Point convertCellToPoint(Point cellLocation) {
        Dimension cellDimension = this.getCellDimension();
        return new Point(cellLocation.x * (cellDimension.width + this.fInterCellSpacing.width), cellLocation.y * (cellDimension.height + this.fInterCellSpacing.height));
    }

    public void addDisplaySelectionListener(DisplaySelectionListener displaySelectionListener) {
        this.fEventListeners.add(DisplaySelectionListener.class, displaySelectionListener);
    }

    private EventListener[] getDisplaySelectionListeners() {
        return this.fEventListeners.getListeners(DisplaySelectionListener.class);
    }

    public void removeDisplaySelectionListener(DisplaySelectionListener displaySelectionListener) {
        this.fEventListeners.remove(DisplaySelectionListener.class, displaySelectionListener);
    }

    protected Dimension convertCellDimensionToDisplayDimension(Dimension modelCellDimension) {
        Dimension cellDimension = this.getCellDimension();
        return new Dimension(modelCellDimension.width * (cellDimension.width + this.fInterCellSpacing.width), modelCellDimension.height * (cellDimension.height + this.fInterCellSpacing.height));
    }

    public void moveFocus(int dx, int dy, boolean extendSelection, boolean deleteElement) {
        Point oldFocusPosition = new Point(this.fFocusPosition);
        if (this.fCurrentCellEditor != null && !this.fCurrentCellEditor.stopCellEditing()) {
            this.fCurrentCellEditor.cancelCellEditing();
        }
        Rectangle cellBounds = this.fModel.getElementBounds(this.fFocusPosition);
        if (dy == -1) {
            this.fFocusPosition.y = Math.max(cellBounds.y - 1, 0);
        }
        if (dy == 1) {
            this.fFocusPosition.y = Math.min(cellBounds.y + cellBounds.height, this.fDisplayDimension.height - 1);
        }
        if (dx == 1) {
            this.fFocusPosition.x = Math.min(cellBounds.x + cellBounds.width, this.fDisplayDimension.width - 1);
        }
        if (dx == -1) {
            this.fFocusPosition.x = Math.max(cellBounds.x - 1, 0);
        }
        if (deleteElement) {
            this.setFocusPosition(this.fModel.getElementBounds(this.fFocusPosition).getLocation());
            this.fModel.deleteElement(this.fFocusPosition);
        }
        if (extendSelection) {
            this.setEndSelection(new Point(this.fFocusPosition));
        } else if (!this.fInsertMode) {
            this.setStartSelection(new Point(this.fFocusPosition));
            this.setEndSelection(new Point(this.fFocusPosition));
        } else {
            this.setStartSelection(new Point(this.fFocusPosition));
            this.setEndSelection(null);
        }
        if (!this.fFocusPosition.equals(oldFocusPosition)) {
            this.fireFocusPositionChangedEvent(oldFocusPosition, this.fFocusPosition);
        }
        this.repaint();
    }

    public Dimension getInterCellSpacing() {
        return this.fInterCellSpacing;
    }

    public void setInterCellSpacing(Dimension interCellSpacing) {
        this.fInterCellSpacing = interCellSpacing;
    }

    public void insertElement(DisplayElement displayElement, Point position) {
        DisplayModel displayModel = this.getModel();
        if (this.isInsertMode()) {
            displayModel.insertElement(displayElement, position);
        } else {
            displayModel.setElementAt(displayElement, position);
        }
        this.repaint();
    }

    public Point getFocusPosition() {
        return this.fFocusPosition;
    }

    public void setFocusPosition(Point focusPosition) {
        Point oldFocusPosition = this.fFocusPosition;
        this.fFocusPosition = focusPosition;
        if (this.fFocusPosition.x < 0) {
            this.fFocusPosition.x = 0;
        }
        if (oldFocusPosition != null && !oldFocusPosition.equals(focusPosition)) {
            this.fireFocusPositionChangedEvent(oldFocusPosition, focusPosition);
        }
    }

    private void fireFocusPositionChangedEvent(Point oldFocusPosition, Point newFocusPosition) {
        DisplayFocusEvent displayFocusEvent = new DisplayFocusEvent(this, oldFocusPosition, newFocusPosition);
        Object[] listeners = this.fEventListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DisplayFocusListener.class) continue;
            ((DisplayFocusListener)listeners[i + 1]).displayFocusPositionChanged(displayFocusEvent);
        }
    }

    private void fireCellEditingStartedEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] listeners = this.fEventListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DisplayCellEditorListener.class) continue;
            ((DisplayCellEditorListener)listeners[i + 1]).editingStarted(changeEvent);
        }
    }

    private void fireCellEditingStoppedEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] listeners = this.fEventListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DisplayCellEditorListener.class) continue;
            ((DisplayCellEditorListener)listeners[i + 1]).editingStopped(changeEvent);
        }
    }

    private void fireCellEditingCanclledEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] listeners = this.fEventListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DisplayCellEditorListener.class) continue;
            ((DisplayCellEditorListener)listeners[i + 1]).editingCanceled(changeEvent);
        }
    }

    private EventListener[] getFocusPositionChangedListeners() {
        return this.fEventListeners.getListeners(DisplayFocusListener.class);
    }

    public Dimension getDisplayDimension() {
        return this.fDisplayDimension;
    }

    private void setDisplayDimension(Dimension displayDimension) {
        this.fDisplayDimension = displayDimension;
    }

    public void clearSelection() {
        this.setStartSelection(this.fFocusPosition);
        this.setEndSelection(null);
        this.repaint();
    }

    public DisplayElement getDefaultInsertElement() {
        return this.fDefaultInsertElement;
    }

    public void setDefaultInsertElement(DisplayElement defaultInsertElement) {
        this.fDefaultInsertElement = defaultInsertElement;
    }

    public DisplayModel getModel() {
        return this.fModel;
    }

    public void setModel(DisplayModel model) {
        this.clearSelection();
        this.setFocusPosition(new Point(0, 0));
        if (this.fModel != null) {
            this.fModel.removeDisplayModelListener(this);
        }
        this.fModel = model;
        if (this.fModel != null) {
            this.fDisplayDimension = this.fModel.getDisplayDimension();
            this.fModel.addDisplayModelListener(this);
        }
        this.setSize(this.getPreferredSize());
        this.repaint();
    }

    public void displayModelChanged(final DisplayModelEvent displayModelEvent) {
        if (displayModelEvent.getType() == 1) {
            this.setModel(this.getModel());
        } else {
            Runnable r = new Runnable(){

                public void run() {
                    Rectangle modelArea = displayModelEvent.getArea();
                    if (modelArea != null) {
                        Rectangle displayArea = new Rectangle(LogoDisplay.this.convertCellToPoint(modelArea.getLocation()), LogoDisplay.this.convertCellDimensionToDisplayDimension(modelArea.getSize()));
                        LogoDisplay.this.repaint(displayArea);
                    } else {
                        LogoDisplay.this.repaint();
                    }
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    public boolean isDragEnabled() {
        return this.fDragEnabled;
    }

    public Border getFocusBorder() {
        if (this.hasFocus()) {
            return BorderFactory.createLineBorder(Color.YELLOW);
        }
        return BorderFactory.createLineBorder(Color.yellow.darker());
    }

    public void setDragEnabled(boolean dragEnabled) {
        this.fDragEnabled = dragEnabled;
        this.setTransferHandler(new DisplayElementTransferHandler());
    }

    public void setDropEnabled(boolean dropEnabled) {
        if (dropEnabled) {
            new DropTarget(this, (DropTargetListener)new DisplayDropTarget(this)){};
        }
    }

    public List getSelectedCells() {
        ArrayList<Point> selectedCells = new ArrayList<Point>();
        boolean[][] checked = new boolean[this.fDisplayDimension.width][this.fDisplayDimension.height];
        for (int y = 0; y < this.fDisplayDimension.height; ++y) {
            int x = 0;
            while (x < this.fDisplayDimension.width) {
                if (checked[x][y]) {
                    ++x;
                    continue;
                }
                Point currentCell = new Point(x, y);
                Rectangle cellBounds = this.fModel.getElementBounds(currentCell);
                if (cellBounds.contains(currentCell)) {
                    for (int i = cellBounds.x; i < cellBounds.x + cellBounds.width && i < this.fDisplayDimension.width; ++i) {
                        for (int j = cellBounds.y; j < cellBounds.y + cellBounds.height && j < this.fDisplayDimension.height; ++j) {
                            checked[i][j] = true;
                        }
                    }
                    if (this.isCellSelected(currentCell)) {
                        selectedCells.add(new Point(currentCell));
                    }
                }
                if (cellBounds.width > 0) {
                    x = cellBounds.x + cellBounds.width;
                    continue;
                }
                ++x;
            }
        }
        return selectedCells;
    }

    public String getToolTipText(MouseEvent event) {
        Point cell = this.convertPointToCell(event.getPoint());
        if (!new Rectangle(new Point(0, 0), this.fDisplayDimension).contains(cell)) {
            return null;
        }
        DisplayElement displayElement = this.getModel().getElementAt(cell);
        if (displayElement != null && this.fToolTipProvider != null) {
            return this.fToolTipProvider.getToolTipText(this, displayElement);
        }
        return super.getToolTipText(event);
    }

    public boolean isInsertMode() {
        return this.fInsertMode;
    }

    public void setInsertMode(boolean insertMode) {
        boolean fOldMode = this.fInsertMode;
        this.fInsertMode = insertMode;
        this.firePropertyChange("insertMode", fOldMode, this.fInsertMode);
    }

    protected Point getSelectionStart() {
        if (this.getStartSelection() == null || this.getEndSelection() == null) {
            return null;
        }
        Point selectionStart = new Point(Math.min(this.getStartSelection().x, this.getEndSelection().x), Math.min(this.getStartSelection().y, this.getEndSelection().y));
        return selectionStart;
    }

    public DisplayCellEditorAllocator getDisplayCellEditorAllocator() {
        return this.fDisplayCellEditorAllocator;
    }

    public void setDisplayCellEditorAllocator(DisplayCellEditorAllocator displayCellEditorAllocator) {
        this.fDisplayCellEditorAllocator = displayCellEditorAllocator;
    }

    public void selectAll() {
        this.setStartSelection(new Point(0, 0));
        this.setEndSelection(new Point(this.fDisplayDimension.width - 1, this.fDisplayDimension.height - 1));
        this.repaint();
    }

    public DisplayToolTipProvider getToolTipProvider() {
        return this.fToolTipProvider;
    }

    public void setToolTipProvider(DisplayToolTipProvider toolTipSupplier) {
        this.setToolTipText("");
        this.fToolTipProvider = toolTipSupplier;
    }

    protected void setEndSelection(Point endSelection) {
        Point oldEndSelection = this.fEndSelection;
        this.fEndSelection = endSelection;
        if (oldEndSelection == null && endSelection != null || oldEndSelection != null && !oldEndSelection.equals(endSelection)) {
            this.fireDisplaySelectionChangedEvent();
        }
    }

    protected Point getEndSelection() {
        return this.fEndSelection;
    }

    protected void setStartSelection(Point startSelection) {
        Point oldStartSelection = this.fStartSelection;
        this.fStartSelection = startSelection;
        if (oldStartSelection == null && startSelection != null || oldStartSelection != null && !oldStartSelection.equals(startSelection)) {
            this.fireDisplaySelectionChangedEvent();
        }
    }

    private void fireDisplaySelectionChangedEvent() {
        DisplaySelectionEvent displaySelectionEvent = new DisplaySelectionEvent(this, this.fStartSelection, this.fEndSelection);
        Object[] listeners = this.fEventListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DisplaySelectionListener.class) continue;
            ((DisplaySelectionListener)listeners[i + 1]).displaySelectionChanged(displaySelectionEvent);
        }
    }

    protected Point getStartSelection() {
        return this.fStartSelection;
    }

    public void addDisplayFocusListener(DisplayFocusListener displayFocusListener) {
        this.fEventListeners.add(DisplayFocusListener.class, displayFocusListener);
    }

    public void addDisplayCellEditorListener(DisplayCellEditorListener displayCellEditorListener) {
        this.fEventListeners.add(DisplayCellEditorListener.class, displayCellEditorListener);
    }

    public void removeDisplayCellEditorListener(DisplayCellEditorListener displayCellEditorListener) {
        this.fEventListeners.remove(DisplayCellEditorListener.class, displayCellEditorListener);
    }

    public void removeDisplayFocusListener(DisplayFocusListener displayFocusListener) {
        this.fEventListeners.remove(DisplayFocusListener.class, displayFocusListener);
    }

    public DisplayCellEditor getCurrentCellEditor() {
        return this.fCurrentCellEditor;
    }

    public boolean isDynamicCellDimensionEnabled() {
        return this.fDynamicCellDimensionEnabled;
    }

    public void setDynamicCellDimensionEnabled(boolean dynamicCellDimensionEnabled) {
        this.fDynamicCellDimensionEnabled = dynamicCellDimensionEnabled;
    }

    public void setSimulationMode(boolean mode) {
        this.fSimulationMode = mode;
    }

    public boolean isNextScreen(int column) {
        if (this.fSimulationMode || !(this.fModel instanceof MessageParameterDisplayModelRTF)) {
            return false;
        }
        return column >= this.getDisplayDimension().width / 2;
    }

    private void barGraphEditor(BarDisplayElement element, Point clickedCell) {
        BarDisplaySettingPanel bdsPanel = new BarDisplaySettingPanel(this, element, this.getWiringDiagram());
        SplittedDlg dialog = SplittedDlg.create(null, bdsPanel, 3);
        bdsPanel.setDialog(dialog);
        dialog.show();
        if (dialog.getControlPanel().getResult() != 1) {
            return;
        }
        DisplayElement displayElement = this.fModel.getElementAt(clickedCell);
        if (!(displayElement instanceof BarDisplayElement)) {
            this.getModel().insertElement(element, this.getFocusPosition());
        } else {
            BarDisplayElement barDisplayElement = (BarDisplayElement)displayElement;
            if (barDisplayElement.fBarID != element.fBarID || barDisplayElement.fDirection != element.fDirection || barDisplayElement.fLength != element.fLength || barDisplayElement.fMax != element.fMax || barDisplayElement.fMin != element.fMin || barDisplayElement.fParameterItem != element.fParameterItem) {
                if (barDisplayElement.getHeight() == element.getHeight() && barDisplayElement.getWidth() == element.getWidth()) {
                    return;
                }
                this.getModel().insertElement(element, this.getFocusPosition());
            }
        }
    }

    private void ioNameEditor(IONameDisplayElement element) {
        IONameSettingPanel panel = new IONameSettingPanel(this, element, this.getWiringDiagram());
        SplittedDlg dialog = SplittedDlg.create(Application.getInstance().getActiveApplicationSurface().getWindow(), panel, 11);
        dialog.show();
    }

    private WiringDiagram getWiringDiagram() {
        return ((MessageParameterDisplayModelRTF)this.getModel()).fMessageParameter.getBlock().getWiringDiagram();
    }

    public void showManualEditPanel(SplittedDlg sDialog, DisplayElement insertingElemenmt, DisplayElement editingElement) {
        LogoError dialog = new LogoError(null, "dialog.logdisplay.conflictOccure", "Position conflict with another message text element.\n Edit manually?", 1, 1);
        if (dialog.display() == 0) {
            if (null != sDialog) {
                sDialog.close();
            }
            MessageEditorPanel editorPanel = new MessageEditorPanel((MessageParameterDisplayModelRTF)this.getModel());
            if (null == editingElement) {
                editorPanel.setElementToCycleBin(insertingElemenmt);
            } else {
                editorPanel.setCellToBeMoved(this.getFocusPosition());
            }
            SplittedDlg panel = SplittedDlg.create(Application.getInstance().getActiveApplicationSurface().getWindow(), editorPanel, 3);
            panel.show();
            if (panel.getControlPanel().getResult() == 1) {
                this.repaint();
            }
        }
    }

    protected static class DisplayDropTarget
    implements DropTargetListener {
        private DataFlavor fDisplayItemFlavor;
        private DataFlavor fCellsFlavor;
        private LogoDisplay fLogoDisplay;

        public DisplayDropTarget(LogoDisplay logoDisplay) {
            try {
                this.fDisplayItemFlavor = new DataFlavor("application/x-java-jvm-local-objectref");
                this.fCellsFlavor = new DataFlavor(LogoDisplay.CELLS_MIME_TYPE);
                this.fLogoDisplay = logoDisplay;
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (!dropTargetDragEvent.isDataFlavorSupported(this.fDisplayItemFlavor) && !dropTargetDragEvent.isDataFlavorSupported(this.fCellsFlavor)) {
                dropTargetDragEvent.rejectDrag();
                return;
            }
            dropTargetDragEvent.acceptDrag(3);
        }

        public void dragExit(DropTargetEvent dte) {
            this.fLogoDisplay.fDropRectangle = null;
            this.fLogoDisplay.repaint();
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (!dropTargetDragEvent.isDataFlavorSupported(this.fDisplayItemFlavor) && !dropTargetDragEvent.isDataFlavorSupported(this.fCellsFlavor)) {
                dropTargetDragEvent.rejectDrag();
                return;
            }
            Point location = this.fLogoDisplay.convertPointToCell(dropTargetDragEvent.getLocation());
            DropTargetDropEvent dropTargetEvent = new DropTargetDropEvent(dropTargetDragEvent.getDropTargetContext(), dropTargetDragEvent.getLocation(), 0, 0);
            Transferable transferable = dropTargetEvent.getTransferable();
            Rectangle newDropRectangle = null;
            if (transferable.isDataFlavorSupported(this.fCellsFlavor)) {
                List cellList = null;
                LogoDisplay srcDisplay = null;
                try {
                    CellsTransferable t = (CellsTransferable)transferable.getTransferData(this.fCellsFlavor);
                    cellList = t.getCells();
                    srcDisplay = t.getLogoDisplay();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
                Rectangle enclosingRectangle = srcDisplay.getEnclosingRectangle(cellList);
                newDropRectangle = new Rectangle(location, enclosingRectangle.getSize());
            }
            if (transferable.isDataFlavorSupported(this.fDisplayItemFlavor)) {
                DisplayElement displayElement = null;
                try {
                    displayElement = (DisplayElement)transferable.getTransferData(this.fDisplayItemFlavor);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
                newDropRectangle = new Rectangle(location, new Dimension(displayElement.getWidth(), displayElement.getHeight()));
            }
            newDropRectangle.setBounds(Math.min(newDropRectangle.x, this.fLogoDisplay.fDisplayDimension.width - newDropRectangle.width), Math.min(newDropRectangle.y, this.fLogoDisplay.fDisplayDimension.height - newDropRectangle.height), newDropRectangle.width, newDropRectangle.height);
            if (!newDropRectangle.equals(this.fLogoDisplay.fDropRectangle)) {
                this.fLogoDisplay.fDropRectangle = newDropRectangle;
                this.fLogoDisplay.repaint();
            }
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (transferable.isDataFlavorSupported(this.fDisplayItemFlavor)) {
                this.dropDisplayElement(transferable, dropTargetDropEvent);
            } else if (transferable.isDataFlavorSupported(this.fCellsFlavor)) {
                this.dropCellsTransferable(transferable, dropTargetDropEvent);
            }
            this.fLogoDisplay.fDropRectangle = null;
            this.fLogoDisplay.repaint();
        }

        protected void dropDisplayElement(Transferable transferable, DropTargetDropEvent dropTargetDropEvent) {
            Object transferData = null;
            try {
                transferData = transferable.getTransferData(this.fDisplayItemFlavor);
            }
            catch (Exception e) {
                dropTargetDropEvent.rejectDrop();
                return;
            }
            if (transferData instanceof DisplayElement) {
                DisplayElement displayElement = (DisplayElement)transferData;
                Point insertionCell = this.fLogoDisplay.fDropRectangle.getLocation();
                boolean inserted = this.fLogoDisplay.getModel().insertElement(displayElement, insertionCell);
                if (!inserted) {
                    dropTargetDropEvent.rejectDrop();
                    LogoError message = new LogoError(this.fLogoDisplay, "dialog.parameter.message.insertionNotAllowed", "Insertion is not allowed on the current position.", 2);
                    message.display();
                } else {
                    this.fLogoDisplay.moveFocusTo(insertionCell, false);
                    dropTargetDropEvent.dropComplete(true);
                    this.fLogoDisplay.setFocusPosition(insertionCell);
                    this.fLogoDisplay.clearSelection();
                    this.fLogoDisplay.repaint();
                }
            }
        }

        protected void dropCellsTransferable(Transferable transferable, DropTargetDropEvent dropTargetDropEvent) {
            Object transferData = null;
            try {
                transferData = transferable.getTransferData(this.fCellsFlavor);
            }
            catch (Exception e) {
                dropTargetDropEvent.rejectDrop();
                return;
            }
            Point destinationCell = null;
            if (this.fLogoDisplay.fDropRectangle == null) {
                System.out.println("Drop error");
                return;
            }
            destinationCell = this.fLogoDisplay.fDropRectangle.getLocation();
            if (transferData instanceof CellsTransferable) {
                CellsTransferable t = (CellsTransferable)transferData;
                boolean inserted = false;
                if (dropTargetDropEvent.getDropAction() == 2) {
                    if (t.getLogoDisplay() == this.fLogoDisplay) {
                        inserted = this.fLogoDisplay.getModel().moveCells(t.getCells(), destinationCell);
                    } else if (this.fLogoDisplay.getModel() instanceof ExtenalMoveModel && t.getLogoDisplay().getModel() instanceof ExtenalMoveModel && (inserted = ((ExtenalMoveModel)this.fLogoDisplay.getModel()).moveCellsFrom((ExtenalMoveModel)t.getLogoDisplay().getModel(), t.getCells(), destinationCell))) {
                        t.getLogoDisplay().clearSelection();
                        t.getLogoDisplay().repaint();
                    }
                }
                if (dropTargetDropEvent.getDropAction() == 1 && t.getLogoDisplay() == this.fLogoDisplay) {
                    inserted = this.fLogoDisplay.getModel().copyCells((List)transferData, destinationCell);
                }
                if (!inserted) {
                    dropTargetDropEvent.rejectDrop();
                    if (this.fLogoDisplay.getModel() instanceof MessageParameterDisplayModelRTF) {
                        LogoError dialog = new LogoError(null, "Conflict detected.\nDo you want to enter the manual editing model?", "Conflict detected.\nDo you want to enter the manual editing model?", 1, 1);
                        if (dialog.display() == 0) {
                            MessageEditorPanel editorPanel = new MessageEditorPanel((MessageParameterDisplayModelRTF)this.fLogoDisplay.getModel());
                            SplittedDlg panel = SplittedDlg.create(Application.getInstance().getActiveApplicationSurface().getWindow(), editorPanel, 3);
                            panel.show();
                            if (panel.getControlPanel().getResult() == 1) {
                                this.fLogoDisplay.repaint();
                            }
                        }
                    } else {
                        JOptionPane.showMessageDialog(this.fLogoDisplay, "Insertion not allowed on current position.", "Insertion not allowed on current position.", 1);
                    }
                } else {
                    dropTargetDropEvent.dropComplete(true);
                    this.fLogoDisplay.setFocusPosition(destinationCell);
                    this.fLogoDisplay.clearSelection();
                }
            }
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
            dtde.acceptDrag(3);
        }
    }

    protected class CellEditorRemover
    implements PropertyChangeListener {
        KeyboardFocusManager focusManager;

        public CellEditorRemover(KeyboardFocusManager fm) {
            this.focusManager = fm;
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if (!LogoDisplay.this.isEditing() || LogoDisplay.this.getClientProperty("terminateEditOnFocusLost") != Boolean.TRUE) {
                return;
            }
            for (Component c = this.focusManager.getPermanentFocusOwner(); c != null; c = c.getParent()) {
                if (c == LogoDisplay.this) {
                    return;
                }
                if (!(c instanceof Window)) continue;
                if (c != SwingUtilities.getRoot(LogoDisplay.this) || LogoDisplay.this.fCurrentCellEditor.stopCellEditing()) break;
                LogoDisplay.this.fCurrentCellEditor.cancelCellEditing();
                break;
            }
        }
    }

    protected class DisplayElementTransferHandler
    extends TransferHandler {
        protected DisplayElementTransferHandler() {
        }

        protected Transferable createTransferable(JComponent c) {
            if (c instanceof LogoDisplay) {
                return this.createTransferableFromLogoDisplay((LogoDisplay)c);
            }
            return null;
        }

        private Transferable createTransferableFromLogoDisplay(LogoDisplay logoDisplay) {
            List selectedCells = LogoDisplay.this.getSelectedCells();
            if (selectedCells.isEmpty()) {
                selectedCells.add(logoDisplay.getFocusPosition());
            }
            return new CellsTransferable(selectedCells, LogoDisplay.this);
        }

        public int getSourceActions(JComponent c) {
            return 3;
        }
    }

    protected class StopEditAction
    extends AbstractAction {
        protected StopEditAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            if (LogoDisplay.this.fCurrentCellEditor != null) {
                LogoDisplay.this.fCurrentCellEditor.stopCellEditing();
            }
        }
    }

    protected class CancelEditAction
    extends AbstractAction {
        protected CancelEditAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            if (LogoDisplay.this.fCurrentCellEditor != null) {
                LogoDisplay.this.fCurrentCellEditor.cancelCellEditing();
            }
        }
    }

    private static class NavigationalAction
    extends AbstractAction {
        protected int dx;
        protected int dy;
        protected boolean extend;
        protected boolean delete;

        protected NavigationalAction(int dx, int dy, boolean extend, boolean delete) {
            this.dx = dx;
            this.dy = dy;
            this.extend = extend;
            this.delete = delete;
        }

        public void actionPerformed(ActionEvent e) {
            MessageParameterDisplayModelRTF displayModel = null;
            LogoDisplay logoDisplay = (LogoDisplay)e.getSource();
            if (logoDisplay.isEditing() && !logoDisplay.fCurrentCellEditor.stopCellEditing()) {
                return;
            }
            List selectedCells = logoDisplay.getSelectedCells();
            if (selectedCells.size() > 1 && this.delete) {
                if (logoDisplay.getModel() instanceof MessageParameterDisplayModelRTF && !(displayModel = (MessageParameterDisplayModelRTF)logoDisplay.getModel()).canDelete(displayModel.getSelectedRectangle(selectedCells))) {
                    return;
                }
                logoDisplay.getModel().deleteCells(selectedCells);
                logoDisplay.clearSelection();
                return;
            }
            int elementWidth = 1;
            int elementHeight = 1;
            if (null != logoDisplay.getFocusedElement()) {
                elementWidth = logoDisplay.getFocusedElement().getWidth();
                elementHeight = logoDisplay.getFocusedElement().getHeight();
            }
            if (logoDisplay.getModel() instanceof MessageParameterDisplayModelRTF && !(displayModel = (MessageParameterDisplayModelRTF)logoDisplay.getModel()).canDelete(new Rectangle(logoDisplay.getFocusPosition().x, logoDisplay.getFocusPosition().y, elementWidth, elementHeight))) {
                return;
            }
            logoDisplay.moveFocus(this.dx, this.dy, this.extend, this.delete);
        }
    }

    protected class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private boolean fDragNDropMode;

        protected MouseHandler() {
        }

        public void mouseDragged(MouseEvent e) {
            Point cellLoaction;
            if (this.fDragNDropMode) {
                TransferHandler th = LogoDisplay.this.getTransferHandler();
                if (LogoDisplay.this.isEditing() && !LogoDisplay.this.fCurrentCellEditor.stopCellEditing()) {
                    LogoDisplay.this.fCurrentCellEditor.cancelCellEditing();
                }
                if (th != null && LogoDisplay.this.isDragEnabled()) {
                    th.exportAsDrag(LogoDisplay.this, e, 2);
                    return;
                }
            }
            if (!new Rectangle(new Point(0, 0), LogoDisplay.this.fDisplayDimension).contains(cellLoaction = LogoDisplay.this.convertPointToCell(e.getPoint()))) {
                return;
            }
            Point currentCell = LogoDisplay.this.fModel.getElementBounds(cellLoaction).getLocation();
            LogoDisplay.this.setEndSelection(currentCell);
            if (!currentCell.equals(LogoDisplay.this.fFocusPosition)) {
                LogoDisplay.this.setStartSelection(new Point(LogoDisplay.this.fFocusPosition));
            }
            if (LogoDisplay.this.fModel instanceof MessageParameterDisplayModelRTF) {
                ArrayList<Point> startEndPoints = new ArrayList<Point>();
                startEndPoints.add(LogoDisplay.this.getStartSelection());
                startEndPoints.add(LogoDisplay.this.getEndSelection());
                Rectangle selectedRectangle = ((MessageParameterDisplayModelRTF)LogoDisplay.this.fModel).getSelectedRectangle(startEndPoints);
                Point currentPosition = selectedRectangle.getLocation();
                LogoDisplay.this.setStartSelection(currentPosition);
                LogoDisplay.this.setEndSelection(new Point(currentPosition.x + selectedRectangle.width - 1, currentPosition.y + selectedRectangle.height - 1));
            }
            LogoDisplay.this.repaint();
        }

        public void mousePressed(MouseEvent e) {
            Point clickedCell;
            if (!LogoDisplay.this.hasFocus()) {
                LogoDisplay.this.requestFocus();
            }
            if (!new Rectangle(new Point(0, 0), LogoDisplay.this.fDisplayDimension).contains(clickedCell = LogoDisplay.this.convertPointToCell(e.getPoint()))) {
                return;
            }
            if (e.getClickCount() < 2 && (LogoDisplay.this.fFocusPosition != null && LogoDisplay.this.fModel.getElementBounds(LogoDisplay.this.fFocusPosition).contains(clickedCell) || LogoDisplay.this.isCellSelected(clickedCell))) {
                TransferHandler th = LogoDisplay.this.getTransferHandler();
                if (th != null && LogoDisplay.this.isDragEnabled()) {
                    this.fDragNDropMode = true;
                }
                return;
            }
            this.fDragNDropMode = false;
            if (e.isShiftDown()) {
                if (LogoDisplay.this.getStartSelection() == null) {
                    LogoDisplay.this.setStartSelection(LogoDisplay.this.fFocusPosition.getLocation());
                }
                LogoDisplay.this.setEndSelection(clickedCell);
                LogoDisplay.this.setFocusPosition(LogoDisplay.this.fModel.getElementBounds(clickedCell).getLocation());
                LogoDisplay.this.repaint();
                return;
            }
            LogoDisplay.this.setStartSelection(null);
            LogoDisplay.this.setFocusPosition(LogoDisplay.this.fModel.getElementBounds(clickedCell).getLocation());
            if (LogoDisplay.this.isEditing() && !LogoDisplay.this.fCurrentCellEditor.stopCellEditing()) {
                LogoDisplay.this.fCurrentCellEditor.cancelCellEditing();
            }
            LogoDisplay.this.repaint();
            if (e.getClickCount() == 2 && LogoDisplay.this.getDisplayCellEditor(LogoDisplay.this.fFocusPosition) != null && LogoDisplay.this.getDisplayCellEditor(LogoDisplay.this.fFocusPosition) != LogoDisplay.this.fDefaultCellEditor) {
                LogoDisplay.this.editCellAt(LogoDisplay.this.fFocusPosition.y, LogoDisplay.this.fFocusPosition.x, e);
            }
        }

        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            if (2 == e.getClickCount()) {
                Point clickedCell = LogoDisplay.this.convertPointToCell(e.getPoint());
                DisplayElement element = LogoDisplay.this.fModel.getElementAt(clickedCell);
                if (!LogoDisplay.this.fSimulationMode) {
                    if (element instanceof BarDisplayElement) {
                        LogoDisplay.this.barGraphEditor((BarDisplayElement)element, clickedCell);
                    }
                    if (element instanceof IONameDisplayElement) {
                        LogoDisplay.this.ioNameEditor((IONameDisplayElement)element);
                    }
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.fDragNDropMode = false;
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    protected class KeyHandler
    extends KeyAdapter {
        protected KeyHandler() {
        }

        public void keyTyped(KeyEvent e) {
            if (e.getModifiersEx() != 0 && e.getModifiersEx() != 64) {
                return;
            }
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
            InputMap map = LogoDisplay.this.getInputMap(0);
            if (keyStroke.getKeyChar() == '\u007f') {
                return;
            }
            if (map != null && map.get(keyStroke) != null) {
                System.out.println(e.getKeyChar() + ": " + map.get(keyStroke) + " (" + LogoDisplay.this.getActionMap().get(map.get(keyStroke)).getClass() + ")");
                return;
            }
            map = LogoDisplay.this.getInputMap(1);
            if (map != null && map.get(keyStroke) != null) {
                System.out.println(map.get(keyStroke) + " (" + LogoDisplay.this.getActionMap().get(map.get(keyStroke)).getClass() + ")");
                return;
            }
            if (e.getKeyChar() == '\r') {
                return;
            }
            List selectedCells = LogoDisplay.this.getSelectedCells();
            if (selectedCells.size() > 1) {
                LogoDisplay.this.setFocusPosition(LogoDisplay.this.fModel.getElementBounds(LogoDisplay.this.getSelectionStart()).getLocation());
                LogoDisplay.this.fModel.deleteCells(selectedCells);
                LogoDisplay.this.clearSelection();
            }
            Point editedCellLocation = LogoDisplay.this.fModel.getElementBounds(LogoDisplay.this.fFocusPosition).getLocation();
            if (LogoDisplay.this.fInsertMode && !LogoDisplay.this.fModel.insertElement(LogoDisplay.this.getDefaultInsertElement(), editedCellLocation)) {
                return;
            }
            if (editedCellLocation.x != -1 && editedCellLocation.y != -1 && !LogoDisplay.this.isEditing() && !LogoDisplay.this.editCellAt(editedCellLocation.y, editedCellLocation.x, e)) {
                return;
            }
            Component editorComp = LogoDisplay.this.fCurrentEditorComp;
            if (LogoDisplay.this.isEditing() && editorComp != null && editorComp instanceof JComponent) {
                Object binding;
                JComponent component = (JComponent)editorComp;
                map = component.getInputMap(0);
                Object object = binding = map != null ? map.get(keyStroke) : null;
                if (binding == null) {
                    map = component.getInputMap(1);
                    Object object2 = binding = map != null ? map.get(keyStroke) : null;
                }
                if (binding != null) {
                    Action action;
                    ActionMap am = component.getActionMap();
                    Action action2 = action = am != null ? am.get(binding) : null;
                    if (action != null && SwingUtilities.notifyAction(action, keyStroke, e, component, e.getModifiers())) {
                        e.consume();
                    }
                } else {
                    component.dispatchEvent(e);
                }
            }
        }
    }

    protected class FocusHandler
    extends FocusAdapter {
        protected FocusHandler() {
        }

        public void focusGained(FocusEvent e) {
            LogoDisplay.this.repaint();
        }

        public void focusLost(FocusEvent e) {
            LogoDisplay.this.repaint();
        }
    }

    public static class DisplayElementTransferable
    implements Transferable {
        private LogoDisplay fLogoDisplay;
        private DisplayElement fDisplayElement;
        private DataFlavor fDisplayElementDataFlavor;

        public DisplayElementTransferable(DisplayElement displayElement) {
            try {
                this.fDisplayElementDataFlavor = new DataFlavor("application/x-java-jvm-local-objectref");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            this.fDisplayElement = displayElement;
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!flavor.equals(this.fDisplayElementDataFlavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.fDisplayElement;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{this.fDisplayElementDataFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(this.fDisplayElementDataFlavor);
        }
    }

    public static class CellsTransferable
    implements Transferable {
        private List fCells;
        private DataFlavor fCellListDataFlavor;
        private LogoDisplay fLogoDisplay;

        public CellsTransferable(List cells, LogoDisplay logoDisplay) {
            try {
                this.fCellListDataFlavor = new DataFlavor(LogoDisplay.CELLS_MIME_TYPE);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            this.fCells = cells;
            this.fLogoDisplay = logoDisplay;
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!flavor.equals(this.fCellListDataFlavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this;
        }

        public List getCells() {
            return this.fCells;
        }

        public LogoDisplay getLogoDisplay() {
            return this.fLogoDisplay;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{this.fCellListDataFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(this.fCellListDataFlavor);
        }
    }
}

