/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import DE.siemens.ad.logo.dialog.comp.display.DisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.LogoDisplay;
import DE.siemens.ad.logo.model.AnalogOrBlockReference;
import DE.siemens.ad.logo.model.IntegerOrBlockReference;
import DE.siemens.ad.logo.model.Mode;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ParameterItemValueFormatter;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.util.AnalogValueProperties;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.IntValueProperties;
import DE.siemens.ad.logo.util.TimeValueProperties;
import DE.siemens.ad.logo.util.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.sql.Time;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class DetailsParameterDisplayCellRenderer
extends JPanel
implements DisplayCellRenderer {
    private boolean fExceptionAlreadyShown;
    protected Map fIcons;
    protected JLabel fIconLabel;
    protected JLabel fBlockNumberLabel;
    protected JLabel fParameterItemNameLabel;
    protected JLabel fParameterValueLabel;
    protected Border fNoFocusBorder = new EmptyBorder(1, 1, 1, 1);

    public DetailsParameterDisplayCellRenderer() {
        this.InitComponent();
    }

    protected void InitComponent() {
        this.setLayout(new BorderLayout());
        this.fIconLabel = new JLabel();
        this.add((Component)this.fIconLabel, "West");
        Box centerPanel = new Box(1);
        this.add((Component)centerPanel, "Center");
        this.fBlockNumberLabel = new JLabel();
        Font font = this.fBlockNumberLabel.getFont();
        this.fBlockNumberLabel.setFont(new Font(font.getName(), font.getStyle(), 9));
        centerPanel.add(this.fBlockNumberLabel);
        this.fParameterItemNameLabel = new JLabel();
        font = this.fParameterItemNameLabel.getFont();
        this.fParameterItemNameLabel.setFont(new Font(font.getName(), font.getStyle(), 9));
        this.fParameterValueLabel = new JLabel();
        font = this.fParameterValueLabel.getFont();
        this.fParameterValueLabel.setFont(new Font(font.getName(), 1, font.getSize()));
        centerPanel.add(this.fParameterValueLabel);
        this.fIcons = new Hashtable(10);
    }

    public Component getDisplayCellRendererComponent(LogoDisplay display, Object element, boolean isSelected, boolean hasFocus, int row, int column) {
        if (element instanceof ParameterItem) {
            ParameterItem pr = (ParameterItem)element;
            Icon icon = (Icon)this.fIcons.get(pr);
            if (icon == null) {
                icon = Global.getIcon(pr.getParameter().getBlock().getIconName());
                this.fIcons.put(pr, icon);
            }
            this.fIconLabel.setIcon(icon);
            Object value = null;
            String valueText = "";
            try {
                value = pr.getValue();
                if (value == null) {
                    throw new NullPointerException();
                }
            }
            catch (Exception e) {
                if (!this.fExceptionAlreadyShown) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(display, "Exception while fetching value of parameterItem. Maybe get-method not defined?\nBlockParameter: " + pr.getParameter() + "\n" + "ParameterItem name: " + pr.getLocalisedName() + "\n" + "ParameterItem identifier: " + pr.getIdentifier());
                    this.fExceptionAlreadyShown = true;
                }
                value = "no get-method?";
                valueText = "no get-method?";
            }
            if (value instanceof TimeValueProperties) {
                valueText = ((TimeValueProperties)value).getCurrentValue().getTimeAsStringLong();
            }
            if (value instanceof TimeUnit) {
                valueText = ((TimeUnit)value).getTimeAsStringLong();
            }
            if (value.getClass() == IntValueProperties.class) {
                valueText = value.toString();
            }
            if (value.getClass() == AnalogValueProperties.class) {
                valueText = ParameterItemValueFormatter.getInstance().formatLogo(pr, value);
            }
            if (value.getClass().equals(Time.class)) {
                Time time = (Time)value;
                valueText = time.getTime() == 0L ? "---" : DateFormat.getTimeInstance(1).format(time);
            }
            if (value.getClass().equals(Date.class)) {
                Date date = (Date)value;
                valueText = date.getTime() == 0L ? "---" : DateFormat.getDateInstance(1).format(date);
            }
            if (value instanceof Mode) {
                valueText = ((Mode)value).getAbbreviation();
            }
            if (value instanceof IntegerOrBlockReference) {
                valueText = value instanceof AnalogOrBlockReference ? ParameterItemValueFormatter.getInstance().formatLogo(pr, ((AnalogOrBlockReference)value).getAnalogValueProperties()) : Integer.toString(((IntegerOrBlockReference)value).getValue());
            }
            if (value instanceof Integer) {
                valueText = Util.addLeadingSpaces(((Integer)value).toString(), pr.getMinWidth());
            }
            String blockNumberText = pr.getParameter().getBlock().getNumberString();
            this.fBlockNumberLabel.setText(blockNumberText + " - " + pr.getLocalisedName());
            this.fParameterValueLabel.setText(valueText);
            this.setBackground(Color.gray);
            if (isSelected) {
                this.setBackground(UIManager.getColor("Tree.selectionBackground"));
            }
            if (hasFocus) {
                this.setBorder(display.getFocusBorder());
            } else {
                this.setBorder(this.fNoFocusBorder);
            }
            this.setOpaque(true);
            this.invalidate();
        }
        return this;
    }
}

