/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import DE.siemens.ad.logo.dialog.comp.display.DefaultDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.DisplayModelEvent;
import DE.siemens.ad.logo.dialog.comp.display.DisplayModelListener;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DefaultDisplayModel
implements DisplayModel {
    protected Dimension fDisplayDimension = new Dimension(12, 4);
    protected boolean fModifying;
    protected DisplayElement[][] fDisplayElements;
    private List fDisplayModelListeners;

    public DefaultDisplayModel(Dimension displayDimension) {
        this.fDisplayDimension = displayDimension;
        this.fDisplayElements = new DisplayElement[this.fDisplayDimension.width][this.fDisplayDimension.height];
    }

    public void addDisplayModelListener(DisplayModelListener displayModelListener) {
        if (!this.getDisplayModelListeners().contains(displayModelListener)) {
            this.getDisplayModelListeners().add(displayModelListener);
        }
    }

    protected void fireModelChangedEvent() {
        this.fireModelChangedEvent(new DisplayModelEvent(this));
    }

    protected void fireModelChangedEvent(DisplayModelEvent displayModelEvent) {
        if (this.fModifying) {
            return;
        }
        if (this.getDisplayModelListeners().isEmpty()) {
            return;
        }
        ArrayList clone = new ArrayList(this.fDisplayModelListeners);
        for (DisplayModelListener listener : clone) {
            listener.displayModelChanged(displayModelEvent);
        }
    }

    public boolean deleteElement(Point location) {
        Point deletedElementLocation = new Point(location.x, location.y);
        Rectangle deletedElementBounds = this.getElementBounds(deletedElementLocation);
        this.moveCellsLeft(deletedElementBounds.getLocation(), deletedElementBounds.width);
        this.fireModelChangedEvent();
        return true;
    }

    public Dimension getDisplayDimension() {
        return new Dimension(this.fDisplayDimension);
    }

    public List getDisplayModelListeners() {
        if (this.fDisplayModelListeners == null) {
            this.fDisplayModelListeners = new ArrayList(5);
        }
        return this.fDisplayModelListeners;
    }

    public DisplayElement getElementAt(Point location) {
        Point elementLocation = this.getElementBounds(location).getLocation();
        return this.fDisplayElements[elementLocation.x][elementLocation.y];
    }

    public Rectangle getElementBounds(Point location) {
        DisplayElement element = this.fDisplayElements[location.x][location.y];
        if (element != null) {
            Rectangle bounds = new Rectangle(location, new Dimension(element.getWidth(), element.getHeight()));
            return bounds;
        }
        for (int x = 0; x < this.fDisplayDimension.width; ++x) {
            for (int y = 0; y < this.fDisplayDimension.height; ++y) {
                Rectangle bounds;
                element = this.fDisplayElements[x][y];
                if (element == null || !(bounds = new Rectangle(new Point(x, y), new Dimension(element.getWidth(), element.getHeight()))).contains(location)) continue;
                return bounds;
            }
        }
        return new Rectangle(location.x, location.y, 1, 1);
    }

    public boolean insertElement(DisplayElement element, Point position) {
        if (!this.canInsert(element, position)) {
            return false;
        }
        if (position.x >= this.fDisplayDimension.width || position.y >= this.fDisplayDimension.height) {
            return false;
        }
        position = this.getElementBounds(position).getLocation();
        int elementWidth = 1;
        if (element != null) {
            elementWidth = element.getWidth();
        }
        this.moveCellsRight(element, position, elementWidth);
        this.fDisplayElements[position.x][position.y] = element;
        this.fireModelChangedEvent();
        return true;
    }

    public boolean isCellEditable(Point location) {
        return false;
    }

    public void removeDisplayModelListener(DisplayModelListener displayModelListener) {
        this.getDisplayModelListeners().remove(displayModelListener);
    }

    public void setDisplayDimension(Dimension displayDimension) {
        if (this.fDisplayDimension.equals(displayDimension)) {
            return;
        }
        this.setModifying(true);
        DisplayElement[][] newElements = new DisplayElement[displayDimension.width][displayDimension.height];
        for (int x = 0; x < Math.min(this.fDisplayDimension.width, displayDimension.width); ++x) {
            for (int y = 0; y < Math.min(this.fDisplayDimension.height, displayDimension.height); ++y) {
                newElements[x][y] = this.fDisplayElements[x][y];
            }
        }
        this.fDisplayElements = newElements;
        this.fDisplayDimension = displayDimension;
        this.setModifying(false);
        this.fireModelChangedEvent(new DisplayModelEvent(this, 1));
    }

    protected boolean moveCellsRight(Point start, int delta) {
        int spalte;
        this.setModifying(true);
        for (spalte = this.fDisplayDimension.width - 1; spalte >= start.x + delta; --spalte) {
            this.fDisplayElements[spalte][start.y] = this.fDisplayElements[spalte - delta][start.y];
        }
        for (spalte = start.x; spalte < Math.min(start.x + delta, this.fDisplayDimension.width); ++spalte) {
            this.fDisplayElements[spalte][start.y] = null;
        }
        this.setModifying(false);
        return true;
    }

    protected boolean moveCellsRight(DisplayElement displayElement, Point start, int delta) {
        return this.moveCellsRight(start, delta);
    }

    protected boolean moveCellsLeft(Point start, int delta) {
        int spalte;
        this.setModifying(true);
        for (spalte = start.x; spalte < this.fDisplayDimension.width - delta; ++spalte) {
            this.fDisplayElements[spalte][start.y] = this.fDisplayElements[spalte + delta][start.y];
        }
        for (spalte = this.fDisplayDimension.width - delta; spalte < this.fDisplayDimension.width; ++spalte) {
            this.fDisplayElements[spalte][start.y] = null;
        }
        this.setModifying(false);
        return true;
    }

    public boolean setElementAt(DisplayElement element, Point position) {
        this.fDisplayElements[position.x][position.y] = element;
        int width = 1;
        int height = 1;
        if (element != null) {
            width = element.getWidth();
            height = element.getHeight();
        }
        for (int spalte = position.x + 1; spalte < Math.min(this.fDisplayDimension.width, position.x + width); ++spalte) {
            this.fDisplayElements[spalte][position.y] = null;
        }
        return true;
    }

    public boolean isModifying() {
        return this.fModifying;
    }

    public void setModifying(boolean modifying) {
        this.fModifying = modifying;
    }

    public boolean copyCells(List cells, Point destination) {
        ArrayList<DisplayElement> elements = new ArrayList<DisplayElement>(cells.size());
        Iterator cellsIterator = cells.iterator();
        Point upperLeftCorner = new Point(this.fDisplayDimension.width, this.fDisplayDimension.height);
        while (cellsIterator.hasNext()) {
            Point cell = (Point)cellsIterator.next();
            elements.add(this.getElementAt(cell));
            if (cell.y > upperLeftCorner.y || cell.x >= upperLeftCorner.x) continue;
            upperLeftCorner = cell;
        }
        Dimension translationVector = new Dimension(destination.x - upperLeftCorner.x, destination.y - upperLeftCorner.y);
        Rectangle displayRectangle = new Rectangle(0, 0, this.fDisplayDimension.width, this.fDisplayDimension.height);
        for (Point cell : cells) {
            Rectangle elementBounds = this.getElementBounds(cell);
            elementBounds.translate(translationVector.width, translationVector.height);
            if (displayRectangle.contains(elementBounds)) continue;
            return false;
        }
        cellsIterator = cells.iterator();
        Iterator elementsIterator = elements.iterator();
        while (cellsIterator.hasNext()) {
            Point cell = (Point)cellsIterator.next();
            DisplayElement element = (DisplayElement)elementsIterator.next();
            Point destinationPoint = new Point(cell);
            destinationPoint.translate(translationVector.width, translationVector.height);
            this.insertElement(element, destinationPoint);
        }
        return true;
    }

    public boolean moveCells(List cells, Point destination) {
        ArrayList<DisplayElement> elements = new ArrayList<DisplayElement>(cells.size());
        Iterator cellsIterator = cells.iterator();
        Point upperLeftCorner = new Point(this.fDisplayDimension.width, this.fDisplayDimension.height);
        while (cellsIterator.hasNext()) {
            Point cell = (Point)cellsIterator.next();
            elements.add(this.getElementAt(cell));
            if (cell.y > upperLeftCorner.y || cell.x >= upperLeftCorner.x) continue;
            upperLeftCorner = cell;
        }
        Dimension translationVector = new Dimension(destination.x - upperLeftCorner.x, destination.y - upperLeftCorner.y);
        Rectangle displayRectangle = new Rectangle(0, 0, this.fDisplayDimension.width, this.fDisplayDimension.height);
        for (Point cell : cells) {
            Rectangle elementBounds = this.getElementBounds(cell);
            elementBounds.translate(translationVector.width, translationVector.height);
            if (displayRectangle.contains(elementBounds)) continue;
            return false;
        }
        this.deleteCells(cells);
        cellsIterator = cells.iterator();
        Iterator elementsIterator = elements.iterator();
        while (cellsIterator.hasNext()) {
            Point cell = (Point)cellsIterator.next();
            DisplayElement element = (DisplayElement)elementsIterator.next();
            Point destinationPoint = new Point(cell);
            destinationPoint.translate(translationVector.width, translationVector.height);
            this.insertElement(element, destinationPoint);
        }
        return true;
    }

    public boolean deleteCells(List cells) {
        DefaultDisplayElement deletedMarker = new DefaultDisplayElement("deleted", 1, 1);
        for (Point cell : cells) {
            Rectangle cellBounds = this.getElementBounds(cell);
            for (int x = 0; x < cellBounds.width; ++x) {
                for (int y = 0; y < cellBounds.height; ++y) {
                    this.setElementAt(deletedMarker, new Point(cell.x + x, cell.y + y));
                }
            }
        }
        for (int y = 0; y < this.fDisplayDimension.height; ++y) {
            for (int x = 0; x < this.fDisplayDimension.width; ++x) {
                Point cell = new Point(x, y);
                if (this.getElementAt(cell) != deletedMarker) continue;
                this.deleteElement(cell);
                --x;
            }
        }
        return true;
    }

    public boolean canInsert(DisplayElement displayElement, Point destination) {
        if (displayElement == null || destination == null) {
            return false;
        }
        if (!new Rectangle(new Point(0, 0), this.fDisplayDimension).contains(destination)) {
            return false;
        }
        return destination.x + displayElement.getWidth() <= this.fDisplayDimension.width && destination.y + displayElement.getHeight() <= this.fDisplayDimension.height;
    }
}

