/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import DE.siemens.ad.logo.dialog.comp.display.BarDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.LogoDisplay;
import DE.siemens.ad.logo.util.Global;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class BarDisplayCellRenderer
extends JPanel
implements DisplayCellRenderer {
    private static final long serialVersionUID = 1L;
    protected Border fNoFocusBorder = new EmptyBorder(1, 1, 1, 1);
    protected BarDisplayElement fBarDispElement;
    protected LogoDisplay fLogoDisplay;
    private transient Image fBarImg = null;

    public BarDisplayCellRenderer() {
        this.setLayout(new BorderLayout());
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.fBarDispElement == null) {
            return;
        }
        if (this.fBarDispElement.getDirection() == 1) {
            g.drawImage(this.getImage(), this.calculateXOffsetVerBar(), this.getFullLength() - this.calculateCurrentLength(), this.getWidthInDirection(), this.calculateCurrentLength(), this);
        } else {
            g.drawImage(this.getImage(), 0, this.calculateYOffsetHorBar(), this.calculateCurrentLength(), this.getWidthInDirection(), this);
        }
    }

    private Image getImage() {
        if (this.fBarImg == null) {
            this.fBarImg = this.fBarDispElement.getDirection() == 1 ? Global.getIcon("bar_v.gif").getImage() : Global.getIcon("bar_h.gif").getImage();
        }
        return this.fBarImg;
    }

    public Component getDisplayCellRendererComponent(LogoDisplay display, Object element, boolean isSelected, boolean hasFocus, int row, int column) {
        if (element instanceof BarDisplayElement) {
            this.fBarDispElement = (BarDisplayElement)element;
            this.fLogoDisplay = display;
            this.setBackground(this.fLogoDisplay.getSimulationColor());
        }
        return this;
    }

    protected int getCurrentValue() {
        return Integer.parseInt(this.fBarDispElement.getParameterItem().getValue().toString());
    }

    private int calculateCurrentLength() {
        if (this.fBarDispElement.getMaxValue() == this.fBarDispElement.getMinValue()) {
            return 0;
        }
        return (this.getCurrentValue() - this.fBarDispElement.getMinValue()) * this.getFullLength() / (this.fBarDispElement.getMaxValue() - this.fBarDispElement.getMinValue());
    }

    private int getFullLength() {
        if (this.fBarDispElement.getDirection() == 1) {
            return this.fBarDispElement.getLength() * this.getCellHeightInPixel();
        }
        return this.fBarDispElement.getLength() * this.getCellWidthInPixel();
    }

    private int getWidthInDirection() {
        return Math.min(28, this.getCellWidthInPixel() * 2);
    }

    private int getCellWidthInPixel() {
        return this.fLogoDisplay.getCellDimension().width + 1;
    }

    private int getCellHeightInPixel() {
        return this.fLogoDisplay.getCellDimension().height + 1;
    }

    private int calculateXOffsetVerBar() {
        return (this.getCellWidthInPixel() * 2 - this.getWidthInDirection()) / 2;
    }

    private int calculateYOffsetHorBar() {
        return (this.getCellHeightInPixel() - this.getWidthInDirection()) / 2;
    }
}

