/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.DisplayModelEvent;
import DE.siemens.ad.logo.dialog.comp.display.DisplayModelListener;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractDisplayModel
implements DisplayModel {
    protected Dimension fDisplayDimension = new Dimension(1, 1);
    protected DisplayElement[][] fDisplayElements;
    private List fDisplayModelListeners;
    protected boolean fModifying;

    public AbstractDisplayModel(Dimension displayDimension) {
        this.fDisplayDimension = displayDimension;
        this.fDisplayElements = new DisplayElement[this.fDisplayDimension.width][this.fDisplayDimension.height];
    }

    public DisplayElement[][] getDisplayElementsClone() {
        DisplayElement[][] ret = new DisplayElement[this.fDisplayDimension.width][this.fDisplayDimension.height];
        for (int i = 0; i < this.fDisplayDimension.width; ++i) {
            for (int j = 0; j < this.fDisplayDimension.height; ++j) {
                ret[i][j] = this.fDisplayElements[i][j];
            }
        }
        return ret;
    }

    public Dimension getDisplayDimension() {
        return new Dimension(this.fDisplayDimension);
    }

    public void addDisplayModelListener(DisplayModelListener displayModelListener) {
        if (!this.getDisplayModelListeners().contains(displayModelListener)) {
            this.getDisplayModelListeners().add(displayModelListener);
        }
    }

    public void removeDisplayModelListener(DisplayModelListener displayModelListener) {
        this.getDisplayModelListeners().remove(displayModelListener);
    }

    public List getDisplayModelListeners() {
        if (this.fDisplayModelListeners == null) {
            this.fDisplayModelListeners = new ArrayList(5);
        }
        return this.fDisplayModelListeners;
    }

    protected void fireModelChangedEvent() {
        this.fireModelChangedEvent(new DisplayModelEvent(this));
    }

    protected void fireModelChangedEvent(DisplayModelEvent displayModelEvent) {
        if (this.fModifying) {
            return;
        }
        if (this.getDisplayModelListeners().isEmpty()) {
            return;
        }
        ArrayList clone = new ArrayList(this.fDisplayModelListeners);
        for (DisplayModelListener listener : clone) {
            listener.displayModelChanged(displayModelEvent);
        }
    }

    public boolean isModifying() {
        return this.fModifying;
    }

    public void setModifying(boolean modifying) {
        this.fModifying = modifying;
    }

    protected boolean moveCellsLeft(Point start, int delta) {
        int x;
        this.setModifying(true);
        for (x = start.x; x < this.fDisplayDimension.width - delta; ++x) {
            this.fDisplayElements[x][start.y] = this.fDisplayElements[x + delta][start.y];
        }
        for (x = this.fDisplayDimension.width - delta; x < this.fDisplayDimension.width; ++x) {
            this.fDisplayElements[x][start.y] = null;
        }
        this.setModifying(false);
        return true;
    }

    protected boolean moveCellsRight(Point start, int delta) {
        int x;
        this.setModifying(true);
        for (x = this.fDisplayDimension.width - 1; x >= start.x + delta; --x) {
            this.fDisplayElements[x][start.y] = this.fDisplayElements[x - delta][start.y];
        }
        for (x = start.x; x < Math.min(start.x + delta, this.fDisplayDimension.width); ++x) {
            this.fDisplayElements[x][start.y] = null;
        }
        this.setModifying(false);
        return true;
    }

    protected Point getUpperLeftCorner(List cells) {
        Iterator cellsIterator = cells.iterator();
        Point upperLeftCorner = new Point(this.getDisplayDimension().width, this.getDisplayDimension().height);
        while (cellsIterator.hasNext()) {
            Point cell = (Point)cellsIterator.next();
            if (cell.x < upperLeftCorner.x) {
                upperLeftCorner.x = cell.x;
            }
            if (cell.y >= upperLeftCorner.y) continue;
            upperLeftCorner.y = cell.y;
        }
        return upperLeftCorner;
    }

    public boolean isCellEditable(Point location) {
        DisplayElement displayElement = this.getElementAt(location);
        if (displayElement == null) {
            return true;
        }
        return displayElement.isEditable();
    }

    public void setDisplayDimension(Dimension displayDimension) {
        if (this.fDisplayDimension.equals(displayDimension)) {
            return;
        }
        this.setModifying(true);
        DisplayElement[][] newElements = new DisplayElement[displayDimension.width][displayDimension.height];
        for (int x = 0; x < Math.min(this.fDisplayDimension.width, displayDimension.width); ++x) {
            for (int y = 0; y < Math.min(this.fDisplayDimension.height, displayDimension.height); ++y) {
                newElements[x][y] = this.fDisplayElements[x][y] == null ? null : (x + this.fDisplayElements[x][y].getWidth() <= displayDimension.width && y + this.fDisplayElements[x][y].getHeight() <= displayDimension.height ? this.fDisplayElements[x][y] : null);
            }
        }
        this.fDisplayElements = newElements;
        this.fDisplayDimension = displayDimension;
        this.setModifying(false);
        this.fireModelChangedEvent(new DisplayModelEvent(this, 1));
    }

    public DisplayElement getElementAt(Point location) {
        Point elementLocation = this.getElementBounds(location).getLocation();
        return this.fDisplayElements[elementLocation.x][elementLocation.y];
    }

    public boolean setElementAt(DisplayElement element, Point position) {
        int width = 1;
        int height = 1;
        if (element != null) {
            width = element.getWidth();
            height = element.getHeight();
        }
        if (position.x + width > this.fDisplayDimension.width || position.y + height > this.fDisplayDimension.height) {
            return false;
        }
        this.fDisplayElements[position.x][position.y] = element;
        for (int x = position.x + 1; x < position.x + width; ++x) {
            for (int y = position.y + 1; y < position.y + height; ++y) {
                this.fDisplayElements[x][position.y] = null;
            }
        }
        return true;
    }
}

