/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.AnalogInputBlock;

public class AIDisplayElement
implements DisplayElement {
    private static final long serialVersionUID = -8060964366241272004L;
    protected int fNumber;
    protected boolean fEditable;
    protected WiringDiagram fWD;
    protected String fFilterValue = "unkn";

    public AIDisplayElement(WiringDiagram wd, int AINumber) {
        this.fWD = wd;
        this.fNumber = AINumber;
        this.fEditable = true;
    }

    public int getHeight() {
        return 1;
    }

    public int getWidth() {
        return 4;
    }

    public boolean isEditable() {
        return this.fEditable;
    }

    public void setEditable(boolean editable) {
        this.fEditable = editable;
    }

    public void setAINumber(int newOpcode) {
        this.fNumber = newOpcode;
    }

    public int getAINumber() {
        return this.fNumber;
    }

    public AnalogInputBlock getBlock() {
        try {
            return (AnalogInputBlock)this.fWD.getBlockByNumberExt(11, this.fNumber);
        }
        catch (Exception e) {
            System.out.print("error occur in AI display element, block missing");
            return null;
        }
    }

    public void updateFilter() {
        AnalogInputBlock block = this.getBlock();
        if (block instanceof AnalogInputBlock) {
            int value = (int)block.calculateAnalogValue();
            String tmp = String.valueOf(value);
            this.fFilterValue = "    ".substring(tmp.length()) + tmp;
        }
    }

    public String getStringValue() {
        return this.fFilterValue;
    }
}

