/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.NumericSpinnerListener;
import DE.siemens.ad.logo.dialog.comp.SpinnerChangedEvent;
import DE.siemens.ad.logo.dialog.comp.TimeInputPanel;
import DE.siemens.ad.logo.dialog.comp.TimeUnitListCellRenderer;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.Timer;
import DE.siemens.ad.logo.util.Language;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class TimeParameterJPanel
extends BorderJPanel {
    protected String fTitleKey = "dialog.timeParameter.title";
    protected String fDefaultTitle = "Time parameter";
    protected Timer fTimer = null;
    protected SymItem lSymItem;
    boolean isAdded = false;
    private TimeInputPanel timeInputPanel;
    private JComboBox cobUnit;
    public static String TIME_UNIT_CHANGE_EVENT_NAME = TimeInputPanel.TIME_UNIT_CHANGE_EVENT_NAME;

    public TimeParameterJPanel() {
        this.setLayout(new FlowLayout(0));
        this.timeInputPanel = new TimeInputPanel();
        this.timeInputPanel.addValueChangedListener(new TimeInputListener());
        this.add(this.timeInputPanel);
        this.cobUnit = new JComboBox();
        this.cobUnit.setRequestFocusEnabled(false);
        this.cobUnit.setRenderer(new TimeUnitListCellRenderer());
        this.add(this.cobUnit);
    }

    public TimeParameterJPanel(Timer tp) {
        this();
        this.setTimer(tp);
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.lSymItem == null) {
            this.lSymItem = new SymItem();
            this.cobUnit.addItemListener(this.lSymItem);
        }
        this.isAdded = true;
    }

    public boolean checkChanged() {
        if (!this.fTimer.getParamTime().getUnitKey().equals(((TimeUnit)this.cobUnit.getSelectedItem()).getUnitKey())) {
            return true;
        }
        return this.timeInputPanel.checkChanged(this.fTimer.getParamTime());
    }

    public boolean checkFieldContents() {
        return this.timeInputPanel.checkFieldContents();
    }

    protected void cobUnit_ItemStateChanged(ItemEvent event) {
        JComboBox c = (JComboBox)event.getSource();
        TimeUnit selectedItem = (TimeUnit)c.getSelectedItem();
        String newValue = selectedItem.getUnitKey();
        this.timeInputPanel.changeTimeUnit(newValue);
        selectedItem.setTime(this.timeInputPanel.getHighValue(), this.timeInputPanel.getLowValue());
        this.firePropertyChange(TIME_UNIT_CHANGE_EVENT_NAME, null, selectedItem);
    }

    public void setValue(int highValue, int lowValue, String unitKey) {
        this.timeInputPanel.highValueSpinner.setValue(highValue);
        this.timeInputPanel.lowValueSpinner.setValue(lowValue);
        if (unitKey != null) {
            this.timeInputPanel.changeTimeUnit(unitKey);
        }
    }

    public final Timer getTimer() {
        return this.fTimer;
    }

    public final String getTimeUnitKey() {
        return ((TimeUnit)this.cobUnit.getSelectedItem()).getUnitKey();
    }

    public void loadFieldContents() {
        this.timeInputPanel.loadFieldContents(this.fTimer.getParamTime());
        TimeUnit[] timeUnits = this.fTimer.getAvailableTimeUnitObjects();
        for (int i = 0; i < timeUnits.length; ++i) {
            if (!timeUnits[i].getUnitKey().equals(this.fTimer.getParamTime().getUnitKey())) continue;
            this.cobUnit.setSelectedIndex(i);
        }
    }

    public void loadFieldContents(TimeUnit timeObject) {
        this.timeInputPanel.loadFieldContents(timeObject);
        TimeUnit[] timeUnits = this.fTimer.getAvailableTimeUnitObjects();
        for (int i = 0; i < timeUnits.length; ++i) {
            if (!timeUnits[i].getUnitKey().equals(timeObject.getUnitKey())) continue;
            this.cobUnit.setSelectedIndex(i);
        }
    }

    public synchronized void removeNotify() {
        if (this.lSymItem != null) {
            this.cobUnit.removeItemListener(this.lSymItem);
            this.lSymItem = null;
        }
        super.removeNotify();
        this.isAdded = false;
    }

    public void setLabels() {
    }

    public final void setTimer(Timer timer) {
        this.fTimer = timer;
        String timerName = this.fTimer.getName();
        if (timerName != null && timerName.length() > 0) {
            this.setTitle(Language.getString(timerName, timerName));
        }
        DefaultComboBoxModel<TimeUnit> comboBoxModel = new DefaultComboBoxModel<TimeUnit>(this.fTimer.getAvailableTimeUnitObjects());
        this.cobUnit.setModel(comboBoxModel);
    }

    public void setTitle(String titleKey, String defaultTitle) {
        this.fTitleKey = titleKey;
        this.fDefaultTitle = defaultTitle;
        this.setTitle(Language.getString(titleKey, defaultTitle));
    }

    public void storeFieldContents() {
        if (this.fTimer != null) {
            this.fTimer.setParamTime(0, 0, ((TimeUnit)this.cobUnit.getSelectedItem()).getUnitKey());
            this.timeInputPanel.storeFieldContents(this.fTimer.getParamTime());
        }
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener listener) {
        super.addPropertyChangeListener(string, listener);
    }

    class SymItem
    implements ItemListener {
        SymItem() {
        }

        public void itemStateChanged(ItemEvent event) {
            Object object = event.getSource();
            if (object == TimeParameterJPanel.this.cobUnit) {
                TimeParameterJPanel.this.cobUnit_ItemStateChanged(event);
            }
        }
    }

    public class TimeInputListener
    implements NumericSpinnerListener {
        public void spinnerChanged(SpinnerChangedEvent se) {
            TimeUnit timeUnit = (TimeUnit)TimeParameterJPanel.this.cobUnit.getSelectedItem();
            TimeParameterJPanel.this.timeInputPanel.storeFieldContents(timeUnit);
            TimeParameterJPanel.this.firePropertyChange(TIME_UNIT_CHANGE_EVENT_NAME, null, timeUnit);
        }
    }
}

