/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.app.comp.NumericSpinnerListener;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TimeInputPanel
extends JPanel {
    public static String TIME_UNIT_CHANGE_EVENT_NAME = "timeUnitChangeEvent";
    EditableNumericSpinner highValueSpinner;
    EditableNumericSpinner lowValueSpinner;
    JLabel colon;
    private int minLowValue;

    public void addValueChangedListener(NumericSpinnerListener listener) {
        this.highValueSpinner.addNumericSpinnerListener(listener);
        this.lowValueSpinner.addNumericSpinnerListener(listener);
    }

    public TimeInputPanel() {
        int WIDTH = 128;
        int HEIGHT = 24;
        this.setLayout(null);
        this.setPreferredSize(new Dimension(128, 24));
        this.setSize(128, 24);
        this.highValueSpinner = new EditableNumericSpinner();
        this.highValueSpinner.setLayout(null);
        this.highValueSpinner.setBounds(0, 0, 64, 24);
        this.add(this.highValueSpinner);
        this.lowValueSpinner = new EditableNumericSpinner();
        this.lowValueSpinner.setLayout(null);
        this.lowValueSpinner.setBounds(80, 0, 48, 24);
        this.add(this.lowValueSpinner);
        this.colon = new JLabel();
        this.colon.setText(":");
        this.colon.setBounds(72, 0, 12, 24);
        this.add(this.colon);
    }

    public void changeTimeUnit(String unitKey) {
        TimeUnit newUnit = TimeUnit.getNewTimeObject(unitKey);
        this.highValueSpinner.setPropertiesWithoutCurrent(newUnit.getHigh());
        this.lowValueSpinner.setPropertiesWithoutCurrent(newUnit.getLow());
        int min = this.highValueSpinner.getMin();
        int max = this.highValueSpinner.getMax();
        this.highValueSpinner.setToolTipText(Language.getString("comp.spinner.tooltip", "Please enter a value between " + min + " and " + max + ".", new Object[]{new Integer(min), new Integer(max)}));
        min = this.lowValueSpinner.getMin();
        max = this.lowValueSpinner.getMax();
        this.lowValueSpinner.setToolTipText(Language.getString("comp.spinner.tooltip", "Please enter a value between " + min + " and " + max + ".", new Object[]{new Integer(min), new Integer(max)}));
    }

    public boolean checkChanged(TimeUnit timeObject) {
        if (timeObject == null) {
            if (this.highValueSpinner.checkChanged()) {
                return true;
            }
            if (this.lowValueSpinner.checkChanged()) {
                return true;
            }
        } else {
            if (this.highValueSpinner.getValue() != timeObject.getHigh().getCurrentValue()) {
                return true;
            }
            if (this.lowValueSpinner.getValue() != timeObject.getLow().getCurrentValue()) {
                return true;
            }
        }
        return false;
    }

    public boolean checkFieldContents() {
        if (!this.highValueSpinner.checkValue(true)) {
            this.highValueSpinner.requestFocus();
            return false;
        }
        if (!this.lowValueSpinner.checkValue(true)) {
            this.lowValueSpinner.requestFocus();
            return false;
        }
        if (this.highValueSpinner.getValue() == 0 && this.lowValueSpinner.getValue() < this.minLowValue) {
            new LogoError((Component)this, "dialog.timInputPanel.minValue", "Minimal value = 1", 2, 0).display();
            this.lowValueSpinner.requestFocus();
            return false;
        }
        return true;
    }

    public void displayHighValueError() {
        this.getHighValueError().display();
        this.highValueSpinner.requestFocus();
    }

    public void displayLowValueError() {
        this.getLowValueError().display();
        this.lowValueSpinner.requestFocus();
    }

    public final int getHighValue() {
        return this.highValueSpinner.getValue();
    }

    public LogoError getHighValueError() {
        return this.highValueSpinner.getError();
    }

    public final int getLowValue() {
        return this.lowValueSpinner.getValue();
    }

    public LogoError getLowValueError() {
        return this.lowValueSpinner.getError();
    }

    public void loadFieldContents(TimeUnit timeObject) {
        if (timeObject != null) {
            this.highValueSpinner.setProperties(timeObject.getHigh());
            this.lowValueSpinner.setProperties(timeObject.getLow());
        }
    }

    public void setEnabled(boolean state) {
        this.highValueSpinner.setEnabled(state);
        this.lowValueSpinner.setEnabled(state);
    }

    public void setHighValue(int value) {
        this.highValueSpinner.setValue(value);
    }

    public void setInitialHighValue(int initValue) {
        this.highValueSpinner.setInitialValue(initValue);
    }

    public void setInitialLowValue(int initValue) {
        this.lowValueSpinner.setInitialValue(initValue);
    }

    public void setLowValue(int value) {
        this.lowValueSpinner.setValue(value);
    }

    public void setLowValueMinimum(int value) {
        this.minLowValue = value;
    }

    public void requestFocus() {
        this.highValueSpinner.requestFocus();
    }

    public void setSeparator(String separator) {
        this.colon.setText(separator);
    }

    public void storeFieldContents(TimeUnit timeObject) {
        if (timeObject != null) {
            timeObject.setTime(this.highValueSpinner.getValue(), this.lowValueSpinner.getValue());
        }
    }

    public void setHighEnabled(boolean state) {
        this.highValueSpinner.setEnabled(state);
    }

    public void setLowEnabled(boolean state) {
        this.lowValueSpinner.setEnabled(state);
    }
}

