/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.TransmissionFailedException;
import DE.siemens.ad.logo.dialog.comp.display.DefaultDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.LogoDisplay;
import DE.siemens.ad.logo.dialog.comp.display.OneCharacterCellEditor;
import DE.siemens.ad.logo.dialog.comp.display.PowerOnScreenDisplayModel;
import DE.siemens.ad.logo.util.ExceptionAlreadyHandledException;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.Memory;
import DE.siemens.ad.logo.util.MessageGlobalInfo;
import DE.siemens.ad.logo.util.PowerOnScreenLine;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SetPowerOnScreenPanel
extends DataInputPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton ivjReadBtn = null;
    private JButton ivjWriteBtn = null;
    private JButton ivjClearBtn = null;
    private BorderJPanel ivjDisplayPanelBorder = null;
    private LogoDisplay fLogoDisplay = null;
    private JComboBox fMessageLang1 = null;
    protected static final String POWER_ON_SCREEN = "Power on screen.";
    protected static final int START_ADDRESS = 17324;
    Memory fMemory = null;
    protected int fCharSet = 1;
    protected PowerOnScreenLine[] fLines;

    public SetPowerOnScreenPanel() {
        this.initialize();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getWriteBtn()) {
            this.actionPerformed_WriteButton();
        }
        if (e.getSource() == this.getReadBtn()) {
            this.actionPerformed_ReadButton();
        }
        if (e.getSource() == this.getClearBtn()) {
            this.actionPerformed_ClearButton();
        }
    }

    private void initialize() {
        try {
            this.setName(Language.getString("dialog.powerOnScreen.title", "Set LOGO! TD Power-on screen"));
            this.setLayout(null);
            this.setSize(this.getPreferredSize());
            this.fMemory = new Memory(POWER_ON_SCREEN, 17324, 1, 65);
            this.add(this.getTD_Screen(), this.getTD_Screen().getName());
            this.add((Component)this.getReadBtn(), this.getReadBtn().getName());
            this.add((Component)this.getWriteBtn(), this.getWriteBtn().getName());
            this.add((Component)this.getClearBtn(), this.getClearBtn().getName());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.getWriteBtn().addActionListener(this);
        this.getReadBtn().addActionListener(this);
        this.getClearBtn().addActionListener(this);
    }

    private Component getTD_Screen() {
        if (this.ivjDisplayPanelBorder == null) {
            try {
                this.ivjDisplayPanelBorder = new BorderJPanel();
                this.ivjDisplayPanelBorder.setLayout(new BoxLayout(this.ivjDisplayPanelBorder, 1));
                this.ivjDisplayPanelBorder.setName("DatePanelBorder");
                this.ivjDisplayPanelBorder.add(this.getLogoDisplay());
                this.ivjDisplayPanelBorder.add(new JLabel(" "));
                this.ivjDisplayPanelBorder.add(this.getCharSetPanel());
                this.ivjDisplayPanelBorder.setBounds(80, 15, this.getLogoDisplay().getWidth() + 20, this.getLogoDisplay().getHeight() + 50);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDisplayPanelBorder;
    }

    private JPanel getCharSetPanel() {
        JPanel charSetPanel = new JPanel();
        charSetPanel.setLayout(new BoxLayout(charSetPanel, 0));
        JLabel label = new JLabel();
        label.setText("Character Set: ");
        String[][] charSetMap = MessageGlobalInfo.getCharSetMap();
        String[] value = new String[charSetMap.length];
        for (int i = 0; i < charSetMap.length; ++i) {
            value[i] = charSetMap[i][0];
        }
        this.fMessageLang1 = new JComboBox<String>(value);
        this.fMessageLang1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SetPowerOnScreenPanel.this.fCharSet = MessageGlobalInfo.getCharSetKey(SetPowerOnScreenPanel.this.fMessageLang1.getSelectedItem().toString());
                SetPowerOnScreenPanel.this.getLogoDisplay().setModel(SetPowerOnScreenPanel.this.getNewModel());
                System.out.println("charset: " + SetPowerOnScreenPanel.this.fCharSet);
                SetPowerOnScreenPanel.this.fMemory.put(0, 0, SetPowerOnScreenPanel.this.fCharSet);
            }
        });
        this.fMessageLang1.setSelectedItem(MessageGlobalInfo.getCharSetName(this.fCharSet));
        charSetPanel.add(label);
        charSetPanel.add(this.fMessageLang1);
        return charSetPanel;
    }

    private LogoDisplay getLogoDisplay() {
        if (this.fLogoDisplay == null) {
            this.fLogoDisplay = new LogoDisplay();
            this.fLogoDisplay.setModel(this.getNewModel());
            this.fLogoDisplay.setDefaultCellEditor(new OneCharacterCellEditor());
        }
        return this.fLogoDisplay;
    }

    private DisplayModel getNewModel() {
        this.fLines = new PowerOnScreenLine[4];
        for (int i = 0; i < this.fLines.length; ++i) {
            this.fLines[i] = new PowerOnScreenLine(this.fCharSet);
        }
        PowerOnScreenDisplayModel model = new PowerOnScreenDisplayModel(this.fLines, this.fCharSet);
        return model;
    }

    private JButton getReadBtn() {
        if (this.ivjReadBtn == null) {
            try {
                this.ivjReadBtn = new JButton();
                this.ivjReadBtn.setName("ReadBtn");
                this.ivjReadBtn.setText("unknown");
                this.ivjReadBtn.setMaximumSize(new Dimension(69, 25));
                this.ivjReadBtn.setActionCommand("Read");
                this.ivjReadBtn.setBounds(12, 227, 107, 25);
                this.ivjReadBtn.setMinimumSize(new Dimension(69, 25));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjReadBtn;
    }

    private JButton getWriteBtn() {
        if (this.ivjWriteBtn == null) {
            try {
                this.ivjWriteBtn = new JButton();
                this.ivjWriteBtn.setName("WriteBtn");
                this.ivjWriteBtn.setText("unknown");
                this.ivjWriteBtn.setMaximumSize(new Dimension(93, 25));
                this.ivjWriteBtn.setActionCommand("Write");
                this.ivjWriteBtn.setBounds(131, 227, 107, 25);
                this.ivjWriteBtn.setMinimumSize(new Dimension(93, 25));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjWriteBtn;
    }

    private JButton getClearBtn() {
        if (this.ivjClearBtn == null) {
            try {
                this.ivjClearBtn = new JButton();
                this.ivjClearBtn.setName("ClearBtn");
                this.ivjClearBtn.setText("unknown");
                this.ivjClearBtn.setMaximumSize(new Dimension(93, 25));
                this.ivjClearBtn.setActionCommand("Clear");
                this.ivjClearBtn.setBounds(250, 227, 107, 25);
                this.ivjClearBtn.setMinimumSize(new Dimension(93, 25));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjClearBtn;
    }

    public void actionPerformed_ReadButton() {
        this.readDate();
        String charSetName = MessageGlobalInfo.getCharSetName(this.fMemory.get(0));
        if (charSetName == null) {
            Log.println("No screen read or wrong character set");
            return;
        }
        this.fMessageLang1.setSelectedItem(charSetName);
        for (int i = 0; i < this.fLines.length; ++i) {
            int[] bytes = this.fMemory.asArray();
            this.fLines[i].setContentsBytes(bytes, i * 16 + 1);
        }
        ((PowerOnScreenDisplayModel)this.fLogoDisplay.getModel()).updateDisplayElement();
        this.fLogoDisplay.repaint();
        System.out.println(this.fLogoDisplay.size());
    }

    public void testReadDate() {
        String testString = "hello, this is the test string.";
        this.fMemory.setPosition(0);
        this.fMemory.put(this.fCharSet);
        for (int i = 0; i < 64; ++i) {
            this.fMemory.put(testString.charAt(i % testString.length()));
        }
    }

    private void readDate() {
        DataTransfer dt = null;
        try {
            dt = DataTransfer.openConnection(true);
            if (!dt.isTransmissionPossible((JComponent)this.getParent()) || !this.isAvailable(dt)) {
                dt.closePort();
                System.out.println("No read and return");
                return;
            }
        }
        catch (ExceptionAlreadyHandledException eahe) {
            return;
        }
        boolean tryAgain = true;
        boolean printLog = true;
        while (tryAgain) {
            try {
                dt.reset();
                this.fMemory.upload(dt);
                Log.printStartSequence("log.msg.readpowerOnScreen", "Read LOGO! TD Power-On-Screen successful");
                tryAgain = false;
            }
            catch (TransmissionFailedException tfe) {
                if (printLog) {
                    Log.printStartSequence("log.err.readpowerOnScreen", "Read LOGO! TD Power-On-Screen failed");
                    printLog = false;
                }
                tryAgain = LogoError.checkRepeatTransmission(tfe);
            }
        }
        dt.closePort();
    }

    public void actionPerformed_WriteButton() {
        this.writeModelToLines();
        this.fMemory.put(0, 0, this.fCharSet);
        this.fMemory.setPosition(1);
        for (int i = 0; i < 4; ++i) {
            this.fMemory.put(this.fLines[i].getContentsBytes());
        }
        this.writeDate();
    }

    public void actionPerformed_ClearButton() {
        int preCharset = this.fMemory.get(0);
        this.fMemory.put(0, 0, 255);
        this.clearModel();
        this.writeDate();
    }

    private void clearModel() {
        DisplayModel model = this.getLogoDisplay().getModel();
        for (int y = 0; y < model.getDisplayDimension().height; ++y) {
            for (int x = 0; x < model.getDisplayDimension().width; ++x) {
                model.setElementAt(null, new Point(x, y));
            }
        }
        this.getLogoDisplay().repaint();
    }

    private void writeModelToLines() {
        DisplayModel model = this.getLogoDisplay().getModel();
        for (int y = 0; y < this.fLines.length; ++y) {
            int x = 0;
            while (x < this.fLines[0].getLineWidth()) {
                DisplayElement displayElement = model.getElementAt(new Point(x, y));
                this.fLines[y].setDisplayElement((DefaultDisplayElement)displayElement, x);
                if (displayElement != null) {
                    x += displayElement.getWidth();
                    continue;
                }
                ++x;
            }
        }
    }

    private void writeDate() {
        DataTransfer dt = null;
        try {
            dt = DataTransfer.openConnection(true);
            if (!dt.isTransmissionPossible((JComponent)this.getParent()) || !this.isAvailable(dt)) {
                dt.closePort();
                return;
            }
        }
        catch (ExceptionAlreadyHandledException eahe) {
            return;
        }
        boolean tryAgain = true;
        boolean printLog = true;
        while (tryAgain) {
            try {
                dt.reset();
                this.fMemory.download(dt);
                Log.printStartSequence("log.msg.writePowerOnScreenOK", "Write LOGO! TD Power-On-Screen sucessfull");
                tryAgain = false;
            }
            catch (TransmissionFailedException tfe) {
                if (printLog) {
                    Log.printStartSequence("log.err.writePowerOnScreenFailed", "Write LOGO! TD Power-On-Screen failed");
                    printLog = false;
                }
                tryAgain = LogoError.checkRepeatTransmission(tfe);
            }
        }
        dt.closePort();
    }

    public void setLabels() {
        this.getReadBtn().setText(Language.getString("dialog.setClock.readBtn", "Read"));
        this.getWriteBtn().setText(Language.getString("dialog.setClock.writeBtn", "Write"));
        this.getClearBtn().setText(Language.getString("dialog.setPowerOnScreen.clearBtn", "Clear"));
    }

    public Dimension getPreferredSize() {
        return new Dimension(370, 256);
    }

    protected boolean isAvailable(DataTransfer dt) {
        if (dt != null) {
            try {
                return dt.getHardware().supports("Start Screen");
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private void handleException(Throwable exception) {
    }
}

